/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.count;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.consts.InvCountSchemeConst;

public class InvCountBillAuditOp
extends AbstractOperationServicePlugIn {
    private static final String algoKey = InvCountBillAuditOp.class.getName();
    private static final Log log = LogFactory.getLog(InvCountBillAuditOp.class);
    public static final String INVTYPE_VMI = "113";
    private Map<String, List<String>> dimensionExLotMap = InvCountSchemeConst.getDymaccModelDimensionExcludeLotNum();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("schemenumber");
        fieldKeys.add("gainqty");
        fieldKeys.add("lossqty");
        fieldKeys.add("basegainqty");
        fieldKeys.add("baselossqty");
        fieldKeys.add("gainqty2nd");
        fieldKeys.add("lossqty2nd");
        fieldKeys.add("invtype");
        fieldKeys.add("nogenotherinout");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        if (objs == null || objs.length == 0) {
            return;
        }
        HashSet<Long> billIds = new HashSet<Long>(objs.length);
        for (DynamicObject obj : objs) {
            boolean noGenOtherInOut = obj.getBoolean("nogenotherinout");
            if (noGenOtherInOut) continue;
            this.pushOtherInAndOtherOut(obj);
            billIds.add(obj.getLong("id"));
        }
        this.groupOtherInAndOut(billIds);
        this.setInvCountSchemeStatus(objs);
    }

    private void groupOtherInAndOut(Set<Long> billIds) {
        List<String> otherOutDimension = this.dimensionExLotMap.get("im_otheroutbill");
        List<String> otherInDimension = this.dimensionExLotMap.get("im_otherinbill");
        if (otherInDimension == null || otherOutDimension == null) {
            log.info("\u5373\u65f6\u5e93\u5b58\u4f59\u989d\u8868\u6216\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u7684\u5373\u65f6\u5e93\u5b58\u4f59\u989d\u66f4\u65b0\u89c4\u5219\u88ab\u7981\u7528");
            return;
        }
        MainEntityType otherOutEntityType = MetadataServiceHelper.getDataEntityType((String)"im_otheroutbill");
        MainEntityType otherInEntityType = MetadataServiceHelper.getDataEntityType((String)"im_otherinbill");
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"im_invcountbill", (Long[])billIds.toArray(new Long[0]));
        HashSet otherOutBillIds = (HashSet)targetBills.get("im_otheroutbill");
        HashSet otherInBillIds = (HashSet)targetBills.get("im_otherinbill");
        if (otherOutBillIds != null && otherInBillIds != null) {
            DynamicObject[] otherOutBills = BusinessDataServiceHelper.load((Object[])otherOutBillIds.toArray(), (DynamicObjectType)otherOutEntityType);
            HashMap<String, Object> fieldValueMap = new HashMap<String, Object>(16);
            for (DynamicObject otherOutBill : otherOutBills) {
                DynamicObjectCollection entrys = otherOutBill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    String dimensionStr = this.getDimensionStr(entry, otherOutDimension);
                    fieldValueMap.put(dimensionStr, entry.getPkValue());
                }
            }
            if (!fieldValueMap.isEmpty()) {
                DynamicObject[] otherInBills;
                for (DynamicObject otherInBill : otherInBills = BusinessDataServiceHelper.load((Object[])otherInBillIds.toArray(), (DynamicObjectType)otherInEntityType)) {
                    DynamicObjectCollection entrys = otherInBill.getDynamicObjectCollection("billentry");
                    for (DynamicObject entry : entrys) {
                        String dimensionStr = this.getDimensionStr(entry, otherInDimension);
                        Object otherOutEntryId = fieldValueMap.get(dimensionStr);
                        entry.set("srcbillentryid", otherOutEntryId);
                    }
                }
                SaveServiceHelper.update((DynamicObject[])otherInBills);
            }
        }
    }

    private String getDimensionStr(DynamicObject entry, List<String> dimenFields) {
        StringBuilder fieldValueStr = new StringBuilder();
        String srcBillNumber = entry.getString("srcbillnumber");
        if (StringUtils.isNotBlank((CharSequence)srcBillNumber)) {
            fieldValueStr.append(srcBillNumber);
            fieldValueStr.append(",");
        }
        for (String field : dimenFields) {
            Object dimensionValue = this.getDimensionValue(entry, field);
            if (!StringUtils.isNotBlank((Object)dimensionValue)) continue;
            fieldValueStr.append(dimensionValue);
            fieldValueStr.append(",");
        }
        return fieldValueStr.substring(0, fieldValueStr.lastIndexOf(","));
    }

    private void setInvCountSchemeStatus(DynamicObject[] objs) {
        HashSet<String> schemeNumberSet = new HashSet<String>(objs.length);
        HashSet<Long> currentAuditBill = new HashSet<Long>(objs.length);
        for (DynamicObject obj : objs) {
            currentAuditBill.add(obj.getLong("id"));
            schemeNumberSet.add(obj.getString("schemenumber"));
        }
        QFilter filter = new QFilter("schemenumber", "in", schemeNumberSet);
        DataSet invCountBillDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_invcountbill", (String)"id,schemenumber,billstatus", (QFilter[])filter.toArray(), null);
        while (invCountBillDataSet.hasNext()) {
            Row resultRow = invCountBillDataSet.next();
            Long billId = resultRow.getLong("id");
            String billStatus = resultRow.getString("billstatus");
            String schemeNumber = resultRow.getString("schemenumber");
            if (currentAuditBill.contains(billId) || !schemeNumberSet.contains(schemeNumber) || "C".equals(billStatus)) continue;
            schemeNumberSet.remove(schemeNumber);
        }
        if (!schemeNumberSet.isEmpty()) {
            DynamicObject[] invCountScheme;
            QFilter qfilter = new QFilter("billno", "in", schemeNumberSet);
            qfilter.and("completestatus", "=", (Object)"A");
            for (DynamicObject dynamicObject : invCountScheme = BusinessDataServiceHelper.load((String)"im_invcountscheme", (String)"completestatus", (QFilter[])qfilter.toArray())) {
                dynamicObject.set("completestatus", (Object)"B");
            }
            SaveServiceHelper.save((DynamicObject[])invCountScheme);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void pushOtherInAndOtherOut(DynamicObject obj) {
        errorMessage = new StringBuilder();
        variables = this.getOption().getVariables();
        variableKeys = variables.keySet();
        try {
            h = TX.required((String)this.getClass().getName());
            var6_7 = null;
            try {
                if (this.isPushOtherBill(obj, "lossqty", "baselossqty", "lossqty2nd")) {
                    this.pushOtherOutBill(obj, errorMessage);
                }
                if (variableKeys.contains("isSleep")) {
                    sleepTime = this.getOption().getVariableValue("isSleep");
                    if (StringUtils.isNotBlank((CharSequence)sleepTime)) {
                        txHandle = TX.requiresNew((String)this.getClass().getName());
                        var9_12 = null;
                        try {
                            try {
                                TimeUnit.SECONDS.sleep(Long.parseLong(sleepTime));
                            }
                            catch (InterruptedException ex) {
                                InvCountBillAuditOp.log.error(ex.getMessage(), (Throwable)ex);
                            }
                            if (!this.isPushOtherBill(obj, "gainqty", "basegainqty", "gainqty2nd")) ** GOTO lbl43
                            this.pushBill("pushotherinbill", obj, errorMessage, ResManager.loadKDString((String)"\u5176\u4ed6\u5165\u5e93\u5355\uff1a", (String)"InvCountBillAuditOp_0", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                        }
                        catch (Throwable var10_15) {
                            var9_12 = var10_15;
                            throw var10_15;
                        }
                        finally {
                            if (txHandle != null) {
                                if (var9_12 != null) {
                                    try {
                                        txHandle.close();
                                    }
                                    catch (Throwable var10_14) {
                                        var9_12.addSuppressed(var10_14);
                                    }
                                } else {
                                    txHandle.close();
                                }
                            }
                        }
                    } else if (this.isPushOtherBill(obj, "gainqty", "basegainqty", "gainqty2nd")) {
                        this.pushBill("pushotherinbill", obj, errorMessage, ResManager.loadKDString((String)"\u5176\u4ed6\u5165\u5e93\u5355\uff1a", (String)"InvCountBillAuditOp_0", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                    }
                } else if (this.isPushOtherBill(obj, "gainqty", "basegainqty", "gainqty2nd")) {
                    this.pushBill("pushotherinbill", obj, errorMessage, ResManager.loadKDString((String)"\u5176\u4ed6\u5165\u5e93\u5355\uff1a", (String)"InvCountBillAuditOp_0", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                }
lbl43:
                // 6 sources

                if (errorMessage.toString().trim().length() > 0) {
                    h.markRollback();
                    throw new KDBizException(errorMessage.toString());
                }
            }
            catch (Throwable var7_10) {
                var6_7 = var7_10;
                throw var7_10;
            }
            finally {
                if (h != null) {
                    if (var6_7 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable var7_9) {
                            var6_7.addSuppressed(var7_9);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        catch (KDException e) {
            InvCountBillAuditOp.log.error(ResManager.loadKDString((String)"\u76d8\u70b9\u8868\u5ba1\u6838\u751f\u6210\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u636e\u5931\u8d25\u3002", (String)"InvCountBillAuditOp_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u76d8\u70b9\u8868\u5ba1\u6838\u751f\u6210\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u636e\u5931\u8d25\uff0c{0}\u3002", (String)"InvCountBillAuditOp_3", (String)"scmc-im-opplugin", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private void pushOtherOutBill(DynamicObject obj, StringBuilder errorMessage) {
        DynamicObjectCollection VMIEntrys = new DynamicObjectCollection();
        DynamicObjectCollection notVMIEntrys = new DynamicObjectCollection();
        DynamicObjectCollection entrys = obj.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entrys) {
            if (!this.isPushOtherBillByEntry(entry, "lossqty", "baselossqty", "lossqty2nd").booleanValue()) continue;
            DynamicObject invType = entry.getDynamicObject("invtype");
            String number = invType.getString("number");
            if (INVTYPE_VMI.equals(number)) {
                VMIEntrys.add((Object)entry);
                continue;
            }
            notVMIEntrys.add((Object)entry);
        }
        if (!VMIEntrys.isEmpty() && !notVMIEntrys.isEmpty()) {
            StringBuilder pushOtherOutErrorMessage = new StringBuilder();
            this.pushSingleBill(obj, VMIEntrys, pushOtherOutErrorMessage);
            this.pushSingleBill(obj, notVMIEntrys, pushOtherOutErrorMessage);
            if (pushOtherOutErrorMessage.length() > 0) {
                errorMessage.append((CharSequence)pushOtherOutErrorMessage);
            }
        } else {
            this.pushBill("pushotheroutbill", obj, errorMessage, ResManager.loadKDString((String)"\u5176\u4ed6\u51fa\u5e93\u5355\uff1a", (String)"InvCountBillAuditOp_1", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }

    private void pushSingleBill(DynamicObject bill, DynamicObjectCollection entrys, StringBuilder pushOtherOutErrorMessage) {
        DynamicObject cloneObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)bill, (boolean)true, (boolean)false);
        cloneObj.getDynamicObjectCollection("billentry").clear();
        cloneObj.getDynamicObjectCollection("billentry").addAll((Collection)entrys);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(entrys.size());
        for (DynamicObject entry : entrys) {
            ListSelectedRow selectedRow = new ListSelectedRow(cloneObj.getPkValue());
            selectedRow.setEntryEntityKey("billentry");
            selectedRow.setEntryPrimaryKeyValue(entry.getPkValue());
            selectedRows.add(selectedRow);
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("im_invcountbill");
        pushArgs.setTargetEntityNumber("im_otheroutbill");
        pushArgs.setHasRight(true);
        pushArgs.setAppId("im");
        pushArgs.setBuildConvReport(true);
        pushArgs.setSelectedRows(selectedRows);
        pushArgs.setAutoSave(true);
        ConvertOperationResult pushResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            if (pushOtherOutErrorMessage.length() == 0) {
                pushOtherOutErrorMessage.append(ResManager.loadKDString((String)"\u5176\u4ed6\u51fa\u5e93\u5355\uff1a", (String)"InvCountBillAuditOp_1", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
            pushOtherOutErrorMessage.append(pushResult.getBillReports().toString());
        }
    }

    private Object getDimensionValue(DynamicObject entry, String field) {
        Object value = entry.get(field);
        if (value instanceof String) {
            value = ((String)value).trim();
        } else if (value instanceof DynamicObject) {
            value = ((DynamicObject)value).getPkValue();
        } else if (value instanceof BigDecimal) {
            value = ((BigDecimal)value).intValue() == 0 ? BigDecimal.ZERO : value;
        }
        return value;
    }

    private boolean isPushOtherBill(DynamicObject obj, String qtyField, String baseQtyField, String qty2ndField) {
        DynamicObjectCollection billEntry = obj.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : billEntry) {
            Boolean isPushOtherBill = this.isPushOtherBillByEntry(entry, qtyField, baseQtyField, qty2ndField);
            if (!isPushOtherBill.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private Boolean isPushOtherBillByEntry(DynamicObject entry, String qtyField, String baseQtyField, String qty2ndField) {
        BigDecimal entryQty = entry.getBigDecimal(qtyField);
        BigDecimal entryBaseQty = entry.getBigDecimal(baseQtyField);
        BigDecimal entryQty2nd = entry.getBigDecimal(qty2ndField);
        if (entryQty != null && entryQty.compareTo(BigDecimal.ZERO) > 0 || entryBaseQty != null && entryBaseQty.compareTo(BigDecimal.ZERO) > 0 || entryQty2nd != null && entryQty2nd.compareTo(BigDecimal.ZERO) > 0) {
            return true;
        }
        return false;
    }

    private void pushBill(String operationKey, DynamicObject obj, StringBuilder errorMessage, String errMsgPre) {
        List allErrorInfo1;
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)operationKey, (String)"im_invcountbill", (Object[])new Object[]{obj.getPkValue()}, (OperateOption)OperateOption.create());
        ValidateResultCollection validateResult = executeOperate.getValidateResult();
        List validateErrors = validateResult.getValidateErrors();
        if (validateErrors != null && validateErrors.size() > 0) {
            errorMessage.append(errMsgPre);
            for (int i = 0; i < validateErrors.size(); ++i) {
                ValidateResult validateError = (ValidateResult)validateErrors.get(i);
                List allErrorInfo = validateError.getAllErrorInfo();
                if (allErrorInfo == null || allErrorInfo.size() <= 0) continue;
                for (int j = 0; j < allErrorInfo.size(); ++j) {
                    OperateErrorInfo operateErrorInfo = (OperateErrorInfo)allErrorInfo.get(j);
                    errorMessage.append(operateErrorInfo.getMessage());
                    if (i == validateErrors.size() - 1) continue;
                    errorMessage.append('\uff0c');
                }
            }
        }
        if (!(allErrorInfo1 = executeOperate.getAllErrorInfo()).isEmpty()) {
            for (int i = 0; i < allErrorInfo1.size(); ++i) {
                OperateErrorInfo operateErrorInfo = (OperateErrorInfo)allErrorInfo1.get(i);
                errorMessage.append(operateErrorInfo.getMessage());
                if (i == allErrorInfo1.size() - 1) continue;
                errorMessage.append('\uff0c');
            }
        }
    }
}

