/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.count;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class InvCountBillUnAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("schemenumber");
        fieldKeys.add("billentry");
        fieldKeys.add("billentry.material");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        this.UnAuditAndDeleteTargetBill(objs);
        this.setInvCountSchemeStatus(objs);
    }

    private void setInvCountSchemeStatus(DynamicObject[] objs) {
        HashSet<String> schemeNumberSet = new HashSet<String>(objs.length);
        for (DynamicObject obj : objs) {
            String schemeNumber = obj.getString("schemenumber");
            schemeNumberSet.add(schemeNumber);
        }
        QFilter qfilter = new QFilter("billno", "in", schemeNumberSet);
        qfilter.and("completestatus", "=", (Object)"B");
        Object[] invCountScheme = BusinessDataServiceHelper.load((String)"im_invcountscheme", (String)"completestatus", (QFilter[])qfilter.toArray());
        if (ObjectUtils.isEmpty((Object[])invCountScheme)) {
            return;
        }
        for (Object scheme : invCountScheme) {
            scheme.set("completestatus", (Object)"A");
        }
        SaveServiceHelper.save((DynamicObject[])invCountScheme);
    }

    private void UnAuditAndDeleteTargetBill(DynamicObject[] objs) {
        int i;
        int size;
        ArrayList<String> invCountBillNos = new ArrayList<String>(10);
        for (int i2 = 0; i2 < objs.length; ++i2) {
            DynamicObject bill = objs[i2];
            invCountBillNos.add(bill.getString("billno"));
        }
        QFilter qfilter = new QFilter("billentry.srcbillnumber", "in", invCountBillNos);
        qfilter.and("billstatus", "!=", (Object)"A");
        DynamicObjectCollection targetOtherOutBill = QueryServiceHelper.query((String)"im_otheroutbill", (String)"id", (QFilter[])new QFilter[]{qfilter});
        DynamicObjectCollection targetOtherInBill = QueryServiceHelper.query((String)"im_otherinbill", (String)"id", (QFilter[])new QFilter[]{qfilter});
        if (!targetOtherOutBill.isEmpty() || !targetOtherInBill.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff1a\u4e0b\u6e38\u5355\u636e\u4e0d\u662f\u6682\u5b58\u72b6\u6001\u3002", (String)"InvCountBillUnAuditOp_0", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
        qfilter = new QFilter("billentry.srcbillnumber", "in", invCountBillNos);
        qfilter.and("billstatus", "=", (Object)"A");
        targetOtherOutBill = QueryServiceHelper.query((String)"im_otheroutbill", (String)"id", (QFilter[])new QFilter[]{qfilter});
        Object[] ids = null;
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        if (!targetOtherOutBill.isEmpty()) {
            this.checkEnableSerialNumber(objs);
            size = targetOtherOutBill.size();
            ids = new Object[size];
            for (i = 0; i < size; ++i) {
                ids[i] = ((DynamicObject)targetOtherOutBill.get(i)).get("id");
            }
            OperationServiceHelper.executeOperate((String)"delete", (String)"im_otheroutbill", (Object[])ids, (OperateOption)option);
        }
        if (!(targetOtherInBill = QueryServiceHelper.query((String)"im_otherinbill", (String)"id", (QFilter[])new QFilter[]{qfilter})).isEmpty()) {
            this.checkEnableSerialNumber(objs);
            size = targetOtherInBill.size();
            ids = new Object[size];
            for (i = 0; i < size; ++i) {
                ids[i] = ((DynamicObject)targetOtherInBill.get(i)).get("id");
            }
            OperationServiceHelper.executeOperate((String)"delete", (String)"im_otherinbill", (Object[])ids, (OperateOption)option);
        }
    }

    private void checkEnableSerialNumber(DynamicObject[] objs) {
        Boolean isUnAudit = Boolean.FALSE;
        for (DynamicObject bill : objs) {
            if (!this.isEnableSerialNumber(bill)) continue;
            isUnAudit = Boolean.TRUE;
            break;
        }
        if (isUnAudit.booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76d8\u70b9\u8868\u4e2d\u6709\u7269\u6599\u5f00\u542f\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u8bf7\u5148\u5220\u9664\u5173\u8054\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u636e\u3002", (String)"InvCountBillUnAuditOp_1", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean isEnableSerialNumber(DynamicObject bill) {
        DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
        Boolean isEnableSerialNumber = Boolean.FALSE;
        for (DynamicObject entry : billEntry) {
            DynamicObject material = entry.getDynamicObject("material");
            if (material == null || !material.getBoolean("enableserial")) continue;
            isEnableSerialNumber = Boolean.TRUE;
        }
        return isEnableSerialNumber;
    }
}

