/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.disassemblebill;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.scmc.im.business.helper.acct.BalanceHelper;
import kd.scmc.im.errorcode.InvBaseErrorCode;
import kd.scmc.im.helper.TriggerEventHelper;
import kd.scmc.im.opplugin.disassemblebill.AbstractDisassembleBillOp;
import kd.scmc.im.validator.plugin.TransFormBillValidatorPlugin;

public class DisassembleBillUnAuditOp
extends AbstractDisassembleBillOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        TransFormBillValidatorPlugin tplValidator = new TransFormBillValidatorPlugin(e, "unaudit", this.billEntityType.getName());
        tplValidator.validate();
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] invBills = e.getDataEntities();
        if (invBills == null || invBills.length == 0) {
            throw new KDBizException(InvBaseErrorCode.getBILL_NOT_EXISTS(), new Object[0]);
        }
        String formId = this.billEntityType.getName();
        ArrayList<Long> pks = new ArrayList<Long>(invBills.length);
        for (int i = 0; i < invBills.length; ++i) {
            pks.add(invBills[i].getLong("id"));
        }
        BalanceHelper.unAuditBalanceUpdate((String)formId, pks);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operate = (String)this.operateMeta.get("type");
        String formId = this.billEntityType.getName();
        TriggerEventHelper triggerEventHelper = new TriggerEventHelper();
        triggerEventHelper.triggerEventByOp(e.getDataEntities(), operate, formId, this.getOption());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }
}

