/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.importop.count;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class InvCountImportOp
extends BatchImportPlugin {
    private Map<String, Map<Object, Object>> bizOperatorMap = new HashMap<String, Map<Object, Object>>();

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Map option = this.ctx.getOption();
        String importType = (String)option.get("importtype");
        if (!"override".equals(importType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76d8\u70b9\u8868\u53ea\u5141\u8bb8\u66f4\u65b0\u5bfc\u5165\u3002", (String)"InvCountImportOp_0", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
        this.checkChecker2nd(rowdatas, logger);
        this.cacheBaseData(rowdatas, logger);
        this.beforeImportBill(rowdatas, logger);
        if (rowdatas.isEmpty()) {
            return null;
        }
        return super.save(rowdatas, logger);
    }

    private void checkChecker2nd(List<ImportBillData> rowdatas, ImportLogger logger) {
        Object billnoObj = rowdatas.get(0).getData().get((Object)"billno");
        if (null == billnoObj) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5355\u636e\u7f16\u53f7\u3002", (String)"InvCountImportOp_1", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
        String billno = (String)rowdatas.get(0).getData().get((Object)"billno");
        QFilter filter = new QFilter("billno", "=", (Object)billno);
        DynamicObject invcountBill = BusinessDataServiceHelper.loadSingleFromCache((String)"im_invcountbill", (String)"enablecheck", (QFilter[])filter.toArray());
        if (null == invcountBill) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u5b58\u5728\u3002", (String)"InvCountImportOp_2", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
        Boolean enableCheck = (Boolean)invcountBill.get("enablecheck");
        Object checker2nd = rowdatas.get(0).getData().get((Object)"checker2nd");
        if (enableCheck.booleanValue() && checker2nd == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76d8\u70b9\u8868\u5df2\u5f00\u542f\u590d\u76d8\uff0c\u8bf7\u8f93\u5165\u590d\u76d8\u4eba\u3002", (String)"InvCountImportOp_3", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }

    protected void cacheBaseData(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.cacheOperator(rowdatas);
    }

    private void cacheOperator(List<ImportBillData> rowdatas) {
        HashSet<Object> bizOperatorNums = new HashSet<Object>(16);
        HashSet<Object> bizOpergrpnumbers = new HashSet<Object>(16);
        HashSet orgNumbers = new HashSet(16);
        for (ImportBillData rowdata : rowdatas) {
            Map orgMap;
            Map checker2nd;
            Map checker;
            Map operatorGroup;
            JSONObject data = rowdata.getData();
            Map operator = (Map)data.get((Object)"operator");
            if (operator != null && operator.get(operator.getOrDefault("importprop", "number")) != null) {
                bizOperatorNums.add(operator.get(operator.getOrDefault("importprop", "number")));
            }
            if ((operatorGroup = (Map)data.get((Object)"operatorgroup")) != null && operatorGroup.get(operatorGroup.getOrDefault("importprop", "number")) != null) {
                bizOpergrpnumbers.add(operatorGroup.get(operatorGroup.getOrDefault("importprop", "number")));
            }
            if ((checker = (Map)data.get((Object)"checker")) != null && checker.get(checker.getOrDefault("importprop", "number")) != null) {
                bizOperatorNums.add(checker.get(checker.getOrDefault("importprop", "number")));
            }
            if ((checker2nd = (Map)data.get((Object)"checker2nd")) != null && checker2nd.get(checker2nd.getOrDefault("importprop", "number")) != null) {
                bizOperatorNums.add(checker2nd.get(checker2nd.getOrDefault("importprop", "number")));
            }
            if ((orgMap = (Map)data.get((Object)"org")) == null || orgMap.get(orgMap.getOrDefault("importprop", "number")) == null) continue;
            orgNumbers.add(orgMap.get(orgMap.getOrDefault("importprop", "number")));
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter("number", "in", orgNumbers).toArray());
        if (org == null) {
            return;
        }
        Long orgId = org.getLong("id");
        this.cache4BizOperator(bizOperatorNums, bizOpergrpnumbers, orgId);
    }

    protected void beforeImportBill(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.update4BizOperator(rowdatas, "operator", "operatorgroup", logger);
        this.update4BizOperator(rowdatas, "checker", "operatorgroup", logger);
        this.update4BizOperator(rowdatas, "checker2nd", "operatorgroup", logger);
        for (ImportBillData rowdata : rowdatas) {
            this.importCountBindData(rowdata);
            this.initHeadData(rowdata.getData());
        }
    }

    protected void initHeadData(JSONObject data) {
        data.put("billstatus", (Object)"A");
        data.put("billcretype", (Object)"1");
    }

    private void importCountBindData(ImportBillData rowdata) {
        JSONObject data = rowdata.getData();
        List listData = (List)data.get((Object)"billentry");
        data.put("billentry", (Object)listData);
    }

    protected void update4BizOperator(List<ImportBillData> rowdatas, String bizOperatorKey, String bizOperatorGroupKey, ImportLogger logger) {
        String operatorName = "";
        switch (bizOperatorKey) {
            case "operator": {
                operatorName = ResManager.loadKDString((String)"\u5e93\u7ba1\u5458", (String)"InvCountImportOp_4", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                break;
            }
            case "checker": {
                operatorName = ResManager.loadKDString((String)"\u76d8\u70b9\u4eba", (String)"InvCountImportOp_5", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                break;
            }
            case "checker2nd": {
                operatorName = ResManager.loadKDString((String)"\u590d\u76d8\u4eba", (String)"InvCountImportOp_6", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                break;
            }
        }
        String operatorGroupName = "";
        switch (bizOperatorGroupKey) {
            case "operatorgroup": {
                operatorGroupName = ResManager.loadKDString((String)"\u5e93\u7ba1\u7ec4", (String)"InvCountImportOp_7", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                break;
            }
        }
        Iterator<ImportBillData> rowIterator = rowdatas.iterator();
        while (rowIterator.hasNext()) {
            Map<Object, Object> pkValueMap;
            ImportBillData rowdata = rowIterator.next();
            JSONObject data = rowdata.getData();
            int startIndex = rowdata.getStartIndex();
            String billNo = (String)data.get((Object)"billno");
            Map bizOperator = (Map)data.get((Object)bizOperatorKey);
            Map bizOperatorgroup = (Map)data.get((Object)bizOperatorGroupKey);
            if (bizOperator == null || bizOperator.get(bizOperator.getOrDefault("importprop", "number")) == null) {
                if (bizOperatorgroup != null && !"checker2nd".equals(bizOperatorKey)) {
                    data.remove((Object)bizOperatorGroupKey);
                }
                return;
            }
            String key = (String)bizOperator.get(bizOperator.getOrDefault("importprop", "number"));
            Map bizOpergrp = (Map)data.get((Object)bizOperatorGroupKey);
            bizOpergrp = bizOpergrp == null ? new HashMap(1) : bizOpergrp;
            String bizOperGrpNum = (String)bizOpergrp.get(bizOpergrp.getOrDefault("importprop", "number"));
            if (bizOperGrpNum != null) {
                key = key + "_" + bizOperGrpNum;
            }
            if ((pkValueMap = this.bizOperatorMap.get(key)) != null) {
                Iterator<Map.Entry<Object, Object>> iterator = pkValueMap.entrySet().iterator();
                if (!iterator.hasNext()) continue;
                Map.Entry<Object, Object> next = iterator.next();
                bizOperator.put("id", next.getKey());
                if (!bizOpergrp.isEmpty() || !"operator".equals(bizOperatorKey)) continue;
                bizOpergrp.put("id", next.getValue());
                data.put(bizOperatorGroupKey, (Object)bizOpergrp);
                continue;
            }
            String erroInfo = "";
            erroInfo = "checker".equals(bizOperatorKey) || "checker2nd".equals(bizOperatorKey) ? String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1s\u201d\uff1a%2s %3s \u5931\u6548\u6216\u8005\u6240\u5c5e\u4e1a\u52a1\u7ec4\u7c7b\u578b\u4e0d\u662f\u5e93\u7ba1\u7ec4\u3002", (String)"InvCountImportOp_8", (String)"scmc-im-opplugin", (Object[])new Object[0]), billNo, operatorName, key) : String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1s\u201d\uff1a%2s\u548c%3s\u4e0d\u5339\u914d\u3002", (String)"InvCountImportOp_9", (String)"scmc-im-opplugin", (Object[])new Object[0]), billNo, operatorName, operatorGroupName);
            logger.log(Integer.valueOf(startIndex), erroInfo).fail();
            rowIterator.remove();
        }
    }

    protected void cache4BizOperator(Set<Object> bizOperatorNums, Set<Object> bizOpergrpnumbers, Long orgId) {
        if (bizOperatorNums.isEmpty()) {
            return;
        }
        String bizGroupType = OperatorGrpTypeEnum.INVENTORYGRP.getValue();
        QFilter operFilter = new QFilter("entryentity.operatornumber", "in", bizOperatorNums);
        QFilter bizGroupTypeF = new QFilter("operatorgrouptype", "=", (Object)bizGroupType);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        if (!bizOpergrpnumbers.isEmpty()) {
            operFilter.and("number", "in", bizOpergrpnumbers);
        }
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        Map bizOperatorGrps = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,number,createorg,entryentity.id,entryentity.operatornumber,entryentity.invalid", (QFilter[])new QFilter[]{operFilter, qFilter, bizGroupTypeF, enableFilter});
        for (DynamicObject bizOperatorGrp : bizOperatorGrps.values()) {
            String grpNum = bizOperatorGrp.getString("number");
            DynamicObjectCollection entryentity = bizOperatorGrp.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                boolean invalid = entry.getBoolean("invalid");
                if (invalid) continue;
                String operatorNum = entry.getString("operatornumber");
                String key = operatorNum + "_" + grpNum;
                HashMap<Object, Object> pkValueMap = new HashMap<Object, Object>(1);
                pkValueMap.put(entry.getPkValue(), bizOperatorGrp.getPkValue());
                this.bizOperatorMap.put(key, pkValueMap);
                this.bizOperatorMap.put(operatorNum, pkValueMap);
            }
        }
    }
}

