/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.importop.inspect;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.scmc.im.business.helper.InspectionHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import kd.scmc.im.opplugin.tpl.BillTplImportOp;
import org.apache.commons.lang3.StringUtils;

public class InvInspectBillImportOp
extends BillTplImportOp {
    @Override
    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.beforeImportBill(rowdatas, logger);
        if (rowdatas.isEmpty()) {
            return null;
        }
        return super.save(rowdatas, logger);
    }

    @Override
    protected void beforeImportBill(List<ImportBillData> rowdatas, ImportLogger logger) {
        super.beforeImportBill(rowdatas, logger);
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            this.handleRow(logger, iterator);
        }
    }

    private void handleRow(ImportLogger logger, Iterator<ImportBillData> iterator) {
        ImportBillData rowData = iterator.next();
        int index = rowData.getStartIndex();
        JSONObject data = rowData.getData();
        JSONObject bizTypeJson = data.getJSONObject("biztype");
        String bizType = bizTypeJson.getString("number");
        JSONObject invSchemeJson = data.getJSONObject("invscheme");
        String invSchemeId = invSchemeJson.getString("number");
        if (data.getLong("id") == null) {
            if (!"430".equals(bizType)) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u65b0\u589e\u65f6\uff0c\u4e1a\u52a1\u7c7b\u578b\u4e0d\u662f\u5e93\u5b58\u68c0\u9a8c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"InvInspectBillImportOp_5", (String)"scmc-im-opplugin", (Object[])new Object[0])).fail();
                iterator.remove();
                return;
            }
            if (!"450".equals(invSchemeId)) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u65b0\u589e\u65f6\uff0c\u5e93\u5b58\u4e8b\u52a1\u4e0d\u662f\u7269\u6599\u5e93\u5b58\u8bf7\u68c0\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"InvInspectBillImportOp_6", (String)"scmc-im-opplugin", (Object[])new Object[0])).fail();
                iterator.remove();
                return;
            }
        }
        this.handleMaterial(logger, data, index, iterator);
    }

    private void handleMaterial(ImportLogger logger, JSONObject data, int index, Iterator<ImportBillData> iterator) {
        HashSet<String> numberSet = new HashSet<String>();
        Set<Object> inspectIndexs = new HashSet();
        JSONObject bizTypeJson = data.getJSONObject("biztype");
        String bizType = bizTypeJson.getString("number");
        List listData = (List)data.get((Object)"billentry");
        if (listData == null) {
            return;
        }
        boolean hasNoInSpect = false;
        if (SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0003")) {
            inspectIndexs = this.checkInspectApi(data, bizType);
            for (Map row : listData) {
                Map material = (Map)row.get("material");
                if (material == null) continue;
                String materialNum = (String)material.get("number");
                if (inspectIndexs.contains(row.get("rowNum") + "")) continue;
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8be5\u884c{0}\u7684\u7269\u6599\u4e0d\u53ef\u8d28\u68c0\uff0c\u8bf7\u68c0\u67e5\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u3002", (String)"InvInspectBillImportOp_7", (String)"scmc-im-opplugin", (Object[])new Object[]{materialNum})).fail();
                hasNoInSpect = true;
                break;
            }
        } else {
            this.checkBaseData(listData, numberSet);
            for (Map row : listData) {
                String materialNum;
                Map material = (Map)row.get("material");
                if (material == null || numberSet.contains(materialNum = (String)material.get("number"))) continue;
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8be5\u884c{0}\u7684\u7269\u6599\u4e0d\u53ef\u8d28\u68c0\u3002", (String)"InvInspectBillImportOp_8", (String)"scmc-im-opplugin", (Object[])new Object[]{materialNum})).fail();
                hasNoInSpect = true;
                break;
            }
        }
        if (hasNoInSpect) {
            iterator.remove();
        }
    }

    private void checkBaseData(List<Map<String, Object>> listData, Set<String> numberSet) {
        ArrayList<String> numberList = new ArrayList<String>();
        for (Map<String, Object> row : listData) {
            String materialNum;
            Map material = (Map)row.get("material");
            if (material == null || StringUtils.isEmpty((CharSequence)(materialNum = (String)material.get("number")))) continue;
            numberList.add(materialNum);
        }
        DynamicObject[] invMaterials = this.getInvMaterialByNo(numberList);
        if (invMaterials != null) {
            for (DynamicObject invMaterial : invMaterials) {
                boolean enableInspect = invMaterial.getBoolean("enableinspect");
                if (!enableInspect) continue;
                numberSet.add(invMaterial.getString("number"));
            }
        }
    }

    private Set<Object> checkInspectApi(JSONObject data, String bizType) {
        List listData = (List)data.get((Object)"billentry");
        ArrayList params = new ArrayList(listData.size());
        ArrayList<String> materialNos = new ArrayList<String>(listData.size());
        ArrayList<String> inspOrgNos = new ArrayList<String>(listData.size());
        listData.forEach(row -> {
            Map material = (Map)row.get("material");
            Map inspOrg = (Map)row.get("insporg");
            if (material != null && inspOrg != null) {
                materialNos.add((String)material.get("number"));
                inspOrgNos.add((String)inspOrg.get("number"));
            }
        });
        if (CollectionUtils.isEmpty(materialNos) || CollectionUtils.isEmpty(inspOrgNos)) {
            return Collections.emptySet();
        }
        DynamicObject[] invMaterials = this.getInvMaterialByNo(materialNos);
        DynamicObject[] inspectOrgs = this.getInspectOrg(inspOrgNos);
        if (invMaterials == null || inspectOrgs == null) {
            return Collections.emptySet();
        }
        HashMap<String, Long> invMaterialMap = new HashMap<String, Long>(invMaterials.length);
        for (DynamicObject invMaterial : invMaterials) {
            invMaterialMap.put(invMaterial.getString("number"), invMaterial.getLong("id"));
        }
        HashMap<String, Long> inspectOrgMap = new HashMap<String, Long>(invMaterials.length);
        for (DynamicObject inspectOrg : inspectOrgs) {
            inspectOrgMap.put(inspectOrg.getString("number"), inspectOrg.getLong("id"));
        }
        Long bizTypeId = InspectionHelper.getBizTypeId((String)bizType);
        for (Map row2 : listData) {
            Map material = (Map)row2.get("material");
            Map inspOrg = (Map)row2.get("insporg");
            if (material == null || inspOrg == null) continue;
            String materialNo = (String)material.get("number");
            String inspOrgNo = (String)inspOrg.get("number");
            Object materialId = invMaterialMap.get(materialNo);
            Object inspOrgId = inspectOrgMap.get(inspOrgNo);
            if (materialId == null || inspOrgId == null) continue;
            HashMap paramMap = new HashMap(4);
            paramMap.put("materialId", materialId);
            paramMap.put("inspectOrgId", inspOrgId);
            paramMap.put("bizType", bizTypeId);
            paramMap.put("id", row2.get("rowNum"));
            params.add(paramMap);
        }
        if (CollectionUtils.isNotEmpty(params)) {
            return InspectionHelper.calInspectForApi(params);
        }
        return Collections.emptySet();
    }

    private DynamicObject[] getInvMaterialByNo(List<String> materialNums) {
        QFilter qFilter = new QFilter("number", "in", materialNums);
        DynamicObject[] d = BusinessDataServiceHelper.load((String)"bd_material", (String)"id,number,enableinspect", (QFilter[])qFilter.toArray());
        return d;
    }

    private DynamicObject[] getInspectOrg(List<String> orgNos) {
        QFilter qFilter = new QFilter("number", "in", orgNos);
        return BusinessDataServiceHelper.load((String)"bos_org", (String)"id,number", (QFilter[])qFilter.toArray());
    }
}

