/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.inbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.InvCheckRecInBillMatBaseQtyHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.directTran.HandleResult;
import kd.scmc.im.business.helper.directTran.InvDirectTranHelper;
import kd.scmc.im.business.helper.logisticsbill.LogisticsBillHelper;
import kd.scmc.im.consts.InvschemeConsts;

public class PurInBillUnAuditOp
extends AbstractOperationServicePlugIn {
    protected static final Log logger = LogFactory.getLog(PurInBillUnAuditOp.class);
    private static final String SALEOUTBILL_SRCBILLID_COLNAME = "billentry.srcbillid";
    private static final List<String> SALEOUTBILL_SELECT_COLS = Arrays.asList("id", "billno", "billstatus", "supplytrans", "invscheme", "billentry.srcbillid");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("isinitbill");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("supplytrans");
        e.getFieldKeys().add("returnqty");
        e.getFieldKeys().add("returnbaseqty");
        e.getFieldKeys().add("remainreturnqty");
        e.getFieldKeys().add("remainreturnbaseqty");
        e.getFieldKeys().add("remainjoinpriceqty");
        e.getFieldKeys().add("remainjoinpricebaseqty");
        e.getFieldKeys().add("joinpriceqty");
        e.getFieldKeys().add("joinpricebaseqty");
        e.getFieldKeys().add("verifyqty");
        e.getFieldKeys().add("verifybaseqty");
        e.getFieldKeys().add("unverifyqty");
        e.getFieldKeys().add("unverifybaseqty");
        e.getFieldKeys().add("vmisettleqty");
        e.getFieldKeys().add("vmisettlebaseqty");
        e.getFieldKeys().add("vmiremainsettleqty");
        e.getFieldKeys().add("vmiremainsettlebaseqty");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills;
        super.beginOperationTransaction(e);
        for (DynamicObject bill : bills = e.getDataEntities()) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                entry.set("returnqty", (Object)BigDecimal.ZERO);
                entry.set("returnbaseqty", (Object)BigDecimal.ZERO);
                entry.set("remainreturnqty", (Object)BigDecimal.ZERO);
                entry.set("remainreturnbaseqty", (Object)BigDecimal.ZERO);
                entry.set("remainjoinpriceqty", (Object)BigDecimal.ZERO);
                entry.set("remainjoinpricebaseqty", (Object)BigDecimal.ZERO);
                entry.set("joinpriceqty", (Object)BigDecimal.ZERO);
                entry.set("joinpricebaseqty", (Object)BigDecimal.ZERO);
                entry.set("vmisettleqty", (Object)BigDecimal.ZERO);
                entry.set("vmisettlebaseqty", (Object)BigDecimal.ZERO);
                entry.set("vmiremainsettleqty", (Object)BigDecimal.ZERO);
                entry.set("vmiremainsettlebaseqty", (Object)BigDecimal.ZERO);
            }
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        this.delDirectTransSaleOutBill(e);
        if (e.isCancel()) {
            return;
        }
        DynamicObject[] bills = e.getDataEntities();
        this.apAutoVerify(bills);
    }

    private void apAutoVerify(DynamicObject[] bills) {
        logger.info("PurInBillUnAuditOp:\u5224\u65ad\u662f\u5426\u542f\u7528AP\u5e94\u7528\uff0c\u662f\u5426\u8c03\u7528\u53cd\u6838\u9500\u63a5\u53e3");
        if (!MetaDataHelper.isBizAppExistAp()) {
            return;
        }
        Object[] billpks = new Object[bills.length];
        for (int i = 0; i < bills.length; ++i) {
            DynamicObject bill = bills[i];
            boolean isLogisticsBill = LogisticsBillHelper.isLogisticsBill((DynamicObject)bill);
            if (isLogisticsBill) continue;
            billpks[i] = bill.getPkValue();
        }
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"apautoverify", (String)"unAutoVerify", (Object[])new Object[]{billpks, Boolean.TRUE});
        logger.info(String.format("PurInBillUnAuditOp:\u8c03\u7528AP\uff0c%s unAutoVerify\u63a5\u53e3\u5b8c\u6bd5", Arrays.toString(billpks)));
    }

    private void delDirectTransSaleOutBill(BeforeOperationArgs e) {
        DynamicObject[] salOutBills;
        ArrayList<Object> passDataEntitys = new ArrayList<Object>();
        HashMap<Long, ExtendedDataEntity> directTranPurInMaps = new HashMap<Long, ExtendedDataEntity>();
        ArrayList<String> errSaleOutBillNos = new ArrayList<String>();
        for (ExtendedDataEntity entity : e.getValidExtDataEntities()) {
            DynamicObject[] bill = entity.getDataEntity();
            if (InvDirectTranHelper.isSupplyTrans((DynamicObject)bill)) {
                directTranPurInMaps.put((Long)bill.getPkValue(), entity);
                continue;
            }
            passDataEntitys.add(entity);
        }
        if (!directTranPurInMaps.isEmpty() && (salOutBills = BusinessDataServiceHelper.load((String)"im_saloutbill", (String)String.join((CharSequence)",", SALEOUTBILL_SELECT_COLS), (QFilter[])new QFilter("invscheme", "=", (Object)InvschemeConsts.INVSCHEM_DIRECTTRAN_SALE_OUT).and(new QFilter(SALEOUTBILL_SRCBILLID_COLNAME, "in", directTranPurInMaps.keySet())).toArray())) != null && salOutBills.length > 0) {
            HashSet<Long> directTranSaleoutIds = new HashSet<Long>(salOutBills.length);
            for (DynamicObject salOutBill : salOutBills) {
                directTranSaleoutIds.add((Long)salOutBill.getPkValue());
            }
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"im_saloutbill", (Long[])((Long[])directTranSaleoutIds.stream().toArray(Long[]::new)));
            if (!targetBills.isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u76f4\u8fd0\u91c7\u8d2d\u5165\u5e93\u5355\u5bf9\u5e94\u7684\u76f4\u8fd0\u9500\u552e\u51fa\u5e93\u5355\u5b58\u5728\u4e0b\u6e38\u5355\u636e,\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"PurInBillUnAuditOp_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            StringBuilder resultMsgBuilder = new StringBuilder();
            for (DynamicObject salOutBill : salOutBills) {
                Long srcBillId = ((DynamicObject)salOutBill.getDynamicObjectCollection("billentry").get(0)).getLong("srcbillid");
                HandleResult result = InvDirectTranHelper.deleteSaleOutBill((DynamicObject)salOutBill);
                if (result.isSuccess()) continue;
                directTranPurInMaps.remove(srcBillId);
                errSaleOutBillNos.add(salOutBill.getString("billno"));
                resultMsgBuilder.append("PurInBillUnAuditOp.delDirectTransSaleOutBill:").append(result.getMsg());
            }
            if (resultMsgBuilder.length() > 0) {
                logger.info(resultMsgBuilder.toString());
            }
        }
        if (!directTranPurInMaps.isEmpty()) {
            passDataEntitys.addAll(directTranPurInMaps.values());
        }
        e.getValidExtDataEntities().clear();
        String errMsg = errSaleOutBillNos.isEmpty() ? "" : String.format(ResManager.loadKDString((String)"\u76f4\u8fd0\u91c7\u8d2d\u5165\u5e93\u5355\u5bf9\u5e94\u7684\u76f4\u8fd0\u9500\u552e\u51fa\u5e93\u5355\u201c%s\u201d\u53cd\u5ba1\u6838/\u5220\u9664\u5931\u8d25\u3002", (String)"PurInBillUnAuditOp_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), ((Object)errSaleOutBillNos).toString());
        if (passDataEntitys.isEmpty()) {
            e.setCancel(true);
            e.setCancelMessage((Objects.isNull(e.getCancelMessage()) ? "" : e.getCancelMessage() + "\n") + errMsg);
        } else {
            e.getValidExtDataEntities().addAll(passDataEntitys);
            logger.info("PurInBillUnAuditOp.delDirectTransSaleOutBill:" + errMsg);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"PurInBillUnAuditOp", (String)"endOperationTransaction");){
            super.endOperationTransaction(e);
            DynamicObject[] bills = e.getDataEntities();
            InvCheckRecInBillMatBaseQtyHelper.checkBaseQtyList((DynamicObject[])bills, (String)e.getOperationKey());
        }
    }
}

