/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.inspect;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.im.consts.InvInspectBillConst;
import kd.scmc.im.validator.general.LocationMustInputValidator;
import kd.scmc.im.validator.general.StartDateValidator;
import kd.scmc.im.validator.inspect.InvInspectBillSaveValidator;
import kd.scmc.im.validator.inspect.InvInspectEntryInvTypeValidator;
import kd.scmc.im.validator.inspect.InvInspectMaterialValidator;
import kd.scmc.im.validator.inspect.LocationWithTransValidator;

public class InvInspectBillSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billentry.qualifiedwarehouse");
        e.getFieldKeys().add("billentry.qualifiedlocation");
        e.getFieldKeys().add("billentry.unqualifiedwarehouse");
        e.getFieldKeys().add("billentry.unqualifiedlocation");
        e.getFieldKeys().add("billentry.leftinspqty");
        e.getFieldKeys().add("billentry.leftinspbaseqty");
        e.getFieldKeys().add("billentry.outwarehouse");
        e.getFieldKeys().add("billentry.outlocation");
        e.getFieldKeys().add("billentry.warehouse");
        e.getFieldKeys().add("billentry.location");
        e.getFieldKeys().add("billentry.baseqty");
        e.getFieldKeys().add("billentry.qty");
        e.getFieldKeys().add("billentry.qualifiedqty");
        e.getFieldKeys().add("billentry.qualifiedbaseqty");
        e.getFieldKeys().add("billentry.unqualifiedqty");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new LocationWithTransValidator("outwarehouse", "outlocation"));
        e.addValidator((AbstractValidator)new LocationMustInputValidator("qualifiedwarehouse", "qualifiedlocation"));
        e.addValidator((AbstractValidator)new LocationMustInputValidator("unqualifiedwarehouse", "unqualifiedlocation"));
        e.addValidator((AbstractValidator)new InvInspectEntryInvTypeValidator());
        e.addValidator((AbstractValidator)new InvInspectBillSaveValidator());
        e.addValidator((AbstractValidator)new InvInspectMaterialValidator());
        e.addValidator((AbstractValidator)new StartDateValidator("org", "outwarehouse", "org", null, false));
        e.addValidator((AbstractValidator)new StartDateValidator("org", "qualifiedwarehouse", "org", null, false));
        e.addValidator((AbstractValidator)new StartDateValidator("org", "unqualifiedwarehouse", "org", null, false));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null) {
            return;
        }
        for (DynamicObject obj : dataEntities) {
            DynamicObjectCollection billEntryList = obj.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntryList) {
                entry.set("leftinspqty", (Object)entry.getBigDecimal("qty"));
                entry.set("leftinspbaseqty", (Object)entry.getBigDecimal("baseqty"));
                DynamicObject qualifiedWarehouse = entry.getDynamicObject("qualifiedwarehouse");
                if (qualifiedWarehouse != null) continue;
                DynamicObject outWarehouse = entry.getDynamicObject("outwarehouse");
                DynamicObject outLocation = entry.getDynamicObject("outlocation");
                DynamicObject bizType = obj.getDynamicObject("biztype");
                if (InvInspectBillConst.BIZ_TYPE_MAT_SALE_RETURN_SET.contains(bizType.getString("number"))) {
                    outWarehouse = entry.getDynamicObject("warehouse");
                    outLocation = entry.getDynamicObject("location");
                }
                if (outWarehouse == null || outLocation == null) continue;
                entry.set("qualifiedwarehouse", (Object)outWarehouse);
                entry.set("qualifiedlocation", (Object)outLocation);
            }
        }
    }
}

