/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.outbill;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.validator.general.ServiceAttributeValidator;
import kd.scmc.im.validator.general.StartDateValidator;
import kd.scmc.im.validator.plugin.ApplyBillValidatorPlugin;

public class MaterialReqBillSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("location");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("unit2nd");
        e.getFieldKeys().add("qtyunit2nd");
        e.getFieldKeys().add("billentry");
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("auditqty");
        e.getFieldKeys().add("outbaseqty");
        e.getFieldKeys().add("outqty");
        e.getFieldKeys().add("remainoutbaseqty");
        e.getFieldKeys().add("remainoutqty");
        e.getFieldKeys().add("ecostcenter");
        e.getFieldKeys().add("rowstatus");
        e.getFieldKeys().add("lotnumber");
        e.getFieldKeys().add("biztime");
        e.getFieldKeys().add("lastupdateuser");
        e.getFieldKeys().add("lastupdatetime");
        e.getFieldKeys().add("linetype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        ApplyBillValidatorPlugin tplValidator = new ApplyBillValidatorPlugin(e, "submit", this.billEntityType.getName());
        tplValidator.validate();
        e.addValidator((AbstractValidator)new StartDateValidator("bizorg", "warehouse", null, null, false));
        e.addValidator((AbstractValidator)new ServiceAttributeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills;
        super.beginOperationTransaction(e);
        for (DynamicObject bill : bills = e.getDataEntities()) {
            bill.set("lastupdateuser", (Object)UserServiceHelper.getCurrentUser((String)"id"));
            bill.set("lastupdatetime", (Object)new Date());
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                BigDecimal auditQty = entry.getBigDecimal("auditqty");
                entry.set("outbaseqty", (Object)BigDecimal.ZERO);
                entry.set("outqty", (Object)BigDecimal.ZERO);
                entry.set("remainoutqty", (Object)auditQty);
                entry.set("remainoutbaseqty", (Object)baseQty);
            }
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection billentrys = dynamicObject.getDynamicObjectCollection("billentry");
            for (DynamicObject billentry : billentrys) {
                billentry.set("rowstatus", (Object)"B");
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }
}

