/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.outbill;

import java.math.BigDecimal;
import kd.bd.sbd.consts.BizTypeConsts;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;

public class MaterialReqOutBillAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("amount");
        e.getFieldKeys().add("vmisettleqty");
        e.getFieldKeys().add("vmisettlebaseqty");
        e.getFieldKeys().add("vmiremainsettleqty");
        e.getFieldKeys().add("vmiremainsettlebaseqty");
        e.getFieldKeys().add("returnqty");
        e.getFieldKeys().add("remainreturnqty");
        e.getFieldKeys().add("returnbaseqty");
        e.getFieldKeys().add("remainreturnbaseqty");
        e.getFieldKeys().add("purchasedqty");
        e.getFieldKeys().add("remainpurqty");
        e.getFieldKeys().add("purchasedamount");
        e.getFieldKeys().add("remainpuramount");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills;
        super.beginOperationTransaction(e);
        for (DynamicObject bill : bills = e.getDataEntities()) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                BigDecimal qty = entry.getBigDecimal("qty");
                DynamicObject bizType = bill.getDynamicObject("biztype");
                if (BizTypeConsts.BIZTYPE_MOUTRETURN_VMI.equals(bizType.getPkValue()) || BizTypeConsts.BIZTYPE_MOUT_VMI.equals(bizType.getPkValue())) {
                    entry.set("vmisettleqty", (Object)BigDecimal.ZERO);
                    entry.set("vmiremainsettleqty", (Object)qty);
                    entry.set("vmisettlebaseqty", (Object)BigDecimal.ZERO);
                    entry.set("vmiremainsettlebaseqty", (Object)baseQty);
                }
                entry.set("returnqty", (Object)BigDecimal.ZERO);
                entry.set("remainreturnqty", (Object)qty);
                entry.set("returnbaseqty", (Object)BigDecimal.ZERO);
                entry.set("remainreturnbaseqty", (Object)baseQty);
                BigDecimal amount = entry.getBigDecimal("amount");
                entry.set("purchasedqty", (Object)BigDecimal.ZERO);
                entry.set("remainpurqty", (Object)qty);
                entry.set("purchasedamount", (Object)BigDecimal.ZERO);
                entry.set("remainpuramount", (Object)amount);
            }
        }
    }
}

