/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.outbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.InverseBillHelper;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.consts.BizTypeConsts;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.validator.outbill.MaterialReqOutSetPriceValidator;

public class MaterialReqOutBillSetPriceOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MaterialReqOutBillSetPriceOp.class);
    public static final String COSTPRICE = "price";
    public static final String SETTLECURRENCY = "settlecurrency";
    private static Map<String, DynamicObject> tarCurrencyMap = new HashMap<String, DynamicObject>(16);
    private static Map<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>(16);
    private static final String selectFields = "bizbillid,entry.bizbillentryid as bizbillentryid,entry.unitactualcost as unitactualcost,localcurrency.name, billno";
    private static final String methodName1 = "getSrcCurrency";
    private static final String methodName2 = "getActualCost";

    public MaterialReqOutBillSetPriceOp() {
        logger.info("\u8fdb\u5165\u83b7\u53d6\u6210\u672c\u4ef7\u64cd\u4f5c\u63d2\u4ef6\u64cd\u4f5c\u63d2\u4ef6");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new MaterialReqOutSetPriceValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("amount");
        e.getFieldKeys().add("vmisettleqty");
        e.getFieldKeys().add("vmisettlebaseqty");
        e.getFieldKeys().add("vmiremainsettleqty");
        e.getFieldKeys().add("vmiremainsettlebaseqty");
        e.getFieldKeys().add("returnqty");
        e.getFieldKeys().add("remainreturnqty");
        e.getFieldKeys().add("returnbaseqty");
        e.getFieldKeys().add("remainreturnbaseqty");
        e.getFieldKeys().add("purchasedqty");
        e.getFieldKeys().add("remainpurqty");
        e.getFieldKeys().add("purchasedamount");
        e.getFieldKeys().add("remainpuramount");
        e.getFieldKeys().add(COSTPRICE);
        e.getFieldKeys().add(SETTLECURRENCY);
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("settleorg");
        e.getFieldKeys().add("biztime");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("ischargeoff");
        String entityName = this.billEntityType.getName();
        String[] needInverseColumns = InverseBillHelper.getNeedInverseColumns((String)entityName);
        e.getFieldKeys().addAll(Arrays.asList(needInverseColumns));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        logger.info("\u9886\u6599\u51fa\u5e93\u8bbe\u7f6e\u6210\u672c\u4ef7----begin");
        DynamicObject[] bills = e.getDataEntities();
        HashSet<Long> billEntryIds = new HashSet<Long>(16);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            billEntryIds.addAll(this.getBillEntryIds(entrys));
        }
        Map<Object, Object> srcCurrencyAndOrgMap = this.getSplitResultMap(billEntryIds, methodName1);
        for (DynamicObject bill : bills) {
            Long exchangeRateTableID;
            Map currencyAndExRateTable;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            billEntryIds.addAll(this.getBillEntryIds(entrys));
            Date bizTime = bill.getDate("biztime");
            String billNo = bill.getString("billno");
            DynamicObject tarCurrency = bill.getDynamicObject(SETTLECURRENCY);
            Long[] srcCurrencyAndOrg = (Long[])srcCurrencyAndOrgMap.get(billNo);
            if (srcCurrencyAndOrg == null) continue;
            Long srcCurrencyID = srcCurrencyAndOrg[0];
            Long srcOrgId = srcCurrencyAndOrg[1];
            if (srcOrgId == null || (currencyAndExRateTable = CurrencyHelper.getCurrencyAndExRateTable((Long)srcOrgId)) == null || currencyAndExRateTable.isEmpty() || (exchangeRateTableID = (Long)currencyAndExRateTable.get("exchangeRateTableID")) == null || srcCurrencyID == null || tarCurrency == null || bizTime == null) continue;
            Long tarCurrencyId = tarCurrency.getLong("id");
            BigDecimal exchangeRate = srcCurrencyID.equals(tarCurrencyId) ? BigDecimal.ONE : BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableID, (Long)srcCurrencyID, (Long)tarCurrencyId, (Date)bizTime);
            tarCurrencyMap.put(billNo, tarCurrency);
            exchangeRateMap.put(billNo, exchangeRate);
        }
        Map<Object, Object> actualCostMap = this.getSplitResultMap(billEntryIds, methodName2);
        String entityName = this.billEntityType.getName();
        String[] needInverseColumns = InverseBillHelper.getNeedInverseColumns((String)entityName);
        for (DynamicObject bill : bills) {
            if (actualCostMap.size() == 0) continue;
            this.setInverseValues(bill, needInverseColumns);
            this.setActualCostByMap(actualCostMap, bill);
        }
        logger.info("\u9886\u6599\u51fa\u5e93\u8bbe\u7f6e\u6210\u672c\u4ef7----end");
    }

    private void setActualCostByMap(Map<Object, Object> actualCostMap, DynamicObject bill) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Long billEntryId = (Long)entry.getPkValue();
            BigDecimal actualCost = (BigDecimal)actualCostMap.get(billEntryId);
            entry.set(COSTPRICE, (Object)actualCost);
        }
        this.setQty(bill);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{bill});
    }

    private void setQty(DynamicObject bill) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        DynamicObject bizType = bill.getDynamicObject("biztype");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            BigDecimal baseQty = (BigDecimal)entry.get("baseqty");
            BigDecimal qty = (BigDecimal)entry.get("qty");
            BigDecimal amount = (BigDecimal)entry.get("amount");
            if (BizTypeConsts.BIZTYPE_MOUTRETURN_VMI.equals(bizType.getPkValue()) || BizTypeConsts.BIZTYPE_MOUT_VMI.equals(bizType.getPkValue())) {
                entry.set("vmisettleqty", (Object)BigDecimal.ZERO);
                entry.set("vmiremainsettleqty", (Object)qty);
                entry.set("vmisettlebaseqty", (Object)BigDecimal.ZERO);
                entry.set("vmiremainsettlebaseqty", (Object)baseQty);
            }
            entry.set("purchasedqty", (Object)BigDecimal.ZERO);
            entry.set("remainpurqty", (Object)qty);
            entry.set("purchasedamount", (Object)BigDecimal.ZERO);
            entry.set("remainpuramount", (Object)amount);
            this.setAmonut(bill, entry);
        }
    }

    private void setInverseValues(DynamicObject bill, String[] needInverseColumns) {
        boolean negativeBill = this.isNegativeBill(bill);
        if (negativeBill) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                for (String column : needInverseColumns) {
                    BigDecimal value = entry.getBigDecimal(column);
                    if (value.compareTo(BigDecimal.ZERO) <= 0) continue;
                    entry.set(column, (Object)value.negate());
                }
            }
        }
    }

    private boolean isNegativeBill(DynamicObject bill) {
        String bizDirection;
        DynamicObject invScheme = bill.getDynamicObject("invscheme");
        boolean caBill = bill.getBoolean("ischargeoff");
        boolean negativeBill = false;
        if (invScheme != null && "1".equals(bizDirection = invScheme.getString("bizdirection"))) {
            negativeBill = true;
        }
        if (caBill) {
            return !negativeBill;
        }
        return negativeBill;
    }

    private void setAmonut(DynamicObject bill, DynamicObject entry) {
        BigDecimal price = (BigDecimal)entry.get(COSTPRICE);
        BigDecimal qty = (BigDecimal)entry.get("qty");
        if (qty == null || price == null || price.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0) {
            entry.set("amount", (Object)BigDecimal.ZERO);
            return;
        }
        this.calAmonutByPriceChange(entry, COSTPRICE, "qty", "amount", SETTLECURRENCY, bill);
        this.calAmonutByPriceChange(entry, COSTPRICE, "qty", "remainpuramount", SETTLECURRENCY, bill);
    }

    protected void calAmonutByPriceChange(DynamicObject entry, String pricef, String qtyf, String amountf, String currencyf, DynamicObject bill) {
        BigDecimal qty = (BigDecimal)entry.get(qtyf);
        BigDecimal price = (BigDecimal)entry.get(pricef);
        if (null == qty || qty.compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_QTY_NOT_NULL()));
        }
        int precision = this.getPrecision(currencyf, "amtprecision", bill);
        BigDecimal amount_all = qty.multiply(price);
        MaterialReqOutBillSetPriceOp.showAmountErrorTip(amount_all);
        entry.set(amountf, (Object)amount_all.setScale(precision, 4));
    }

    private static void showAmountErrorTip(BigDecimal amount_all) {
        if (amount_all.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MAX_AMOUNT()));
        }
    }

    protected int getPrecision(String currencyf, String pref, DynamicObject bill) {
        int precision = 2;
        if ("priceprecision".equals(pref)) {
            return 10;
        }
        DynamicObject currency = (DynamicObject)bill.get(currencyf);
        if (currency != null) {
            precision = currency.getInt(pref);
        }
        return precision;
    }

    public static Map<Long, BigDecimal> getActualCostMap(List<Long> billEntryIds) {
        HashMap<Long, BigDecimal> actualCost = new HashMap<Long, BigDecimal>(16);
        QFilter bizBillEntryIdFilter = new QFilter("entry.bizbillentryid", "in", billEntryIds);
        DataSet costDs = QueryServiceHelper.queryDataSet((String)MaterialReqOutBillSetPriceOp.class.getName(), (String)"cal_costrecord", (String)"bizbillid,entry.bizbillentryid as bizbillentryid,entry.unitactualcost as unitactualcost", (QFilter[])new QFilter[]{bizBillEntryIdFilter}, (String)"bizbillid,costaccount.ismainaccount desc");
        for (Row row : costDs) {
            actualCost.putIfAbsent(row.getLong("bizbillentryid"), row.getBigDecimal("unitactualcost"));
        }
        return actualCost;
    }

    public static Map<Long, BigDecimal> getActualCostMap(Set<Long> billEntryIds) {
        HashMap<Long, BigDecimal> actualCost = new HashMap<Long, BigDecimal>(16);
        QFilter bizBillEntryIdFilter = new QFilter("entry.bizbillentryid", "in", billEntryIds);
        DataSet costDs = QueryServiceHelper.queryDataSet((String)MaterialReqOutBillSetPriceOp.class.getName(), (String)"cal_costrecord", (String)selectFields, (QFilter[])new QFilter[]{bizBillEntryIdFilter}, (String)"bizbillid,costaccount.ismainaccount desc");
        for (Row row : costDs) {
            BigDecimal unitActualCost = row.getBigDecimal("unitactualcost");
            String srcCurrencyName = row.getString("localcurrency.name");
            String billNo = row.getString("billno");
            if (billNo == null) continue;
            BigDecimal exchangeRate = exchangeRateMap.get(billNo);
            DynamicObject tarCurrency = tarCurrencyMap.get(billNo);
            if (exchangeRate == null && tarCurrency != null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s:\u6c47\u7387\u8868\u4e2d\u672a\u67e5\u8be2\u5230\u201c%2$s\u201d\u548c\u201c%3$s\u201d\u95f4\u7684\u6709\u6548\u6c47\u7387\u3002", (String)"MaterialReqOutBillSetPriceOp_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), billNo, tarCurrency.getString("name"), srcCurrencyName));
            }
            if (exchangeRate == null) continue;
            BigDecimal multiActualCost = unitActualCost.multiply(exchangeRate);
            actualCost.putIfAbsent(row.getLong("bizbillentryid"), multiActualCost);
        }
        return actualCost;
    }

    private Map<String, Long[]> getSrcCurrencyAndOrgMap(Set<Long> billEntryIds) {
        QFilter bizBillEntryIdFilter = new QFilter("entry.bizbillentryid", "in", billEntryIds);
        DataSet currencyData = QueryServiceHelper.queryDataSet((String)MaterialReqOutBillSetPriceOp.class.getName(), (String)"cal_costrecord", (String)"calorg,localcurrency,billno", (QFilter[])new QFilter[]{bizBillEntryIdFilter}, (String)"");
        HashMap<String, Long[]> srcCurrencyMap = new HashMap<String, Long[]>(16);
        for (Row row : currencyData) {
            String billNo = row.getString("billno");
            Long localCurrencyId = row.getLong("localcurrency");
            Long orgId = row.getLong("calorg");
            Long[] currencyAndOrg = new Long[]{localCurrencyId, orgId};
            srcCurrencyMap.put(billNo, currencyAndOrg);
        }
        return srcCurrencyMap;
    }

    private Map<Object, Object> getSplitResultMap(Set<Long> billEntryIds, String methodName) {
        int MAXNUM;
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>(16);
        int size = billEntryIds.size();
        if (size >= (MAXNUM = 128)) {
            HashSet<Long> newBillEntryIds = new HashSet<Long>(16);
            for (Long billEntryId : billEntryIds) {
                newBillEntryIds.add(billEntryId);
                if (newBillEntryIds.size() != MAXNUM) continue;
                if (methodName1.equals(methodName)) {
                    resultMap.putAll(this.getSrcCurrencyAndOrgMap(newBillEntryIds));
                } else if (methodName2.equals(methodName)) {
                    resultMap.putAll(MaterialReqOutBillSetPriceOp.getActualCostMap(newBillEntryIds));
                }
                newBillEntryIds = new HashSet(16);
            }
            if (!newBillEntryIds.isEmpty()) {
                if (methodName1.equals(methodName)) {
                    resultMap.putAll(this.getSrcCurrencyAndOrgMap(newBillEntryIds));
                } else if (methodName2.equals(methodName)) {
                    resultMap.putAll(MaterialReqOutBillSetPriceOp.getActualCostMap(newBillEntryIds));
                }
            }
        } else if (methodName1.equals(methodName)) {
            resultMap.putAll(this.getSrcCurrencyAndOrgMap(billEntryIds));
        } else if (methodName2.equals(methodName)) {
            resultMap.putAll(MaterialReqOutBillSetPriceOp.getActualCostMap(billEntryIds));
        }
        return resultMap;
    }

    private List<Long> getBillEntryIds(DynamicObjectCollection entrys) {
        ArrayList<Long> billEntryIds = new ArrayList<Long>(16);
        for (DynamicObject entry : entrys) {
            Long billEntryId = (Long)entry.getPkValue();
            billEntryIds.add(billEntryId);
        }
        return billEntryIds;
    }
}

