/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.outbill;

import java.math.BigDecimal;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.consts.BizTypeConsts;
import kd.scmc.im.validator.general.TransitLocationMustInputValidator;
import kd.scmc.im.validator.outbill.SalOutBillSaveValidator;

public class SaleOutBillSubmitOp
extends AbstractOperationServicePlugIn {
    private static final String[] CUSTOMERKEYS = new String[]{"payingcustomer", "settlecustomer", "reccustomer"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("isinitbill");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("entrustverifyqty");
        e.getFieldKeys().add("entrustverifybaseqty");
        e.getFieldKeys().add("entrustunverifyqty");
        e.getFieldKeys().add("entrustunverifybaseqty");
        e.getFieldKeys().add("remainreturnqty");
        e.getFieldKeys().add("remainreturnbaseqty");
        e.getFieldKeys().add("remainjoinpriceqty");
        e.getFieldKeys().add("remainjoinpricebaseqty");
        e.getFieldKeys().add("returnqty");
        e.getFieldKeys().add("returnbaseqty");
        e.getFieldKeys().add("joinpriceqty");
        e.getFieldKeys().add("joinpricebaseqty");
        e.getFieldKeys().add("verifyqty");
        e.getFieldKeys().add("verifybaseqty");
        e.getFieldKeys().add("unverifyqty");
        e.getFieldKeys().add("unverifybaseqty");
        e.getFieldKeys().add("payingcustomer");
        e.getFieldKeys().add("settlecustomer");
        e.getFieldKeys().add("reccustomer");
        e.getFieldKeys().add("joincfmqty");
        e.getFieldKeys().add("joincfmbaseqty");
        e.getFieldKeys().add("remaincfmqty");
        e.getFieldKeys().add("remaincfmbaseqty");
        e.getFieldKeys().add("location");
        e.getFieldKeys().add("inwarehouse");
        e.getFieldKeys().add("inlocation");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("productline");
        e.getFieldKeys().add("kitproducttype");
        e.getFieldKeys().add("kitparent");
        e.getFieldKeys().add("kitchild");
        e.getFieldKeys().add("kitpid");
        e.getFieldKeys().add("kittransfermodel");
        e.getFieldKeys().add("mainbillentity");
        e.getFieldKeys().add("mainbillid");
        e.getFieldKeys().add("mainbillentryid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"SaleOutBillSubmitOp", (String)"beginOperationTransaction");){
            super.beginOperationTransaction(e);
            DynamicObject[] bills = e.getDataEntities();
            this.setRwFields(bills);
        }
    }

    private void setRwFields(DynamicObject[] bills) {
        if (Objects.isNull(bills)) {
            return;
        }
        for (DynamicObject bill : bills) {
            Object bizTypeId = bill.getDynamicObject("biztype").getPkValue();
            DynamicObjectCollection entryList = bill.getDynamicObjectCollection("billentry");
            Object customer = bill.get("customer");
            boolean updateWarehouse = this.isUpdateWarehouse(bill);
            for (DynamicObject entry : entryList) {
                if (updateWarehouse) {
                    this.updateWarehouse(entry);
                }
                this.setEntryCustomer(entry, customer == null ? null : (DynamicObject)customer, CUSTOMERKEYS);
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                BigDecimal qty = entry.getBigDecimal("qty");
                if (BizTypeConsts.BIZTYPE_SALOUT_ENTRUST.equals(bizTypeId) || BizTypeConsts.BIZTYPE_SALOUTRETURN_ENTRUST.equals(bizTypeId)) {
                    BigDecimal entrustVerifyQty = entry.getBigDecimal("entrustverifyqty");
                    entry.set("entrustunverifyqty", (Object)qty.subtract(entrustVerifyQty));
                    BigDecimal entrustVerifyBaseQty = entry.getBigDecimal("entrustverifybaseqty");
                    entry.set("entrustunverifybaseqty", (Object)baseQty.subtract(entrustVerifyBaseQty));
                }
                entry.set("returnbaseqty", (Object)BigDecimal.ZERO);
                entry.set("returnqty", (Object)BigDecimal.ZERO);
                BigDecimal returnQty = entry.getBigDecimal("returnqty");
                entry.set("remainreturnqty", (Object)qty.subtract(returnQty));
                BigDecimal returnBaseQty = entry.getBigDecimal("returnbaseqty");
                entry.set("remainreturnbaseqty", (Object)baseQty.subtract(returnBaseQty));
                entry.set("joinpriceqty", (Object)BigDecimal.ZERO);
                BigDecimal joinPriceQty = entry.getBigDecimal("joinpriceqty");
                entry.set("remainjoinpriceqty", (Object)qty.subtract(joinPriceQty));
                entry.set("joinpricebaseqty", (Object)BigDecimal.ZERO);
                BigDecimal joinPriceBaseQty = entry.getBigDecimal("joinpricebaseqty");
                entry.set("remainjoinpricebaseqty", (Object)baseQty.subtract(joinPriceBaseQty));
                entry.set("verifyqty", (Object)BigDecimal.ZERO);
                BigDecimal verifyQty = entry.getBigDecimal("verifyqty");
                entry.set("unverifyqty", (Object)qty.subtract(verifyQty));
                entry.set("verifybaseqty", (Object)BigDecimal.ZERO);
                BigDecimal verifyBaseQty = entry.getBigDecimal("verifybaseqty");
                entry.set("unverifybaseqty", (Object)baseQty.subtract(verifyBaseQty));
                entry.set("joincfmqty", (Object)BigDecimal.ZERO);
                entry.set("joincfmbaseqty", (Object)BigDecimal.ZERO);
                entry.set("remaincfmqty", (Object)qty);
                entry.set("remaincfmbaseqty", (Object)baseQty);
            }
        }
    }

    private void updateWarehouse(DynamicObject entry) {
        DynamicObject wareHouse = entry.getDynamicObject("warehouse");
        if (wareHouse == null) {
            return;
        }
        DynamicObject location = entry.getDynamicObject("location");
        DynamicObject outWareHouse = entry.getDynamicObject("inwarehouse");
        if (outWareHouse == null) {
            entry.set("inwarehouse", (Object)wareHouse);
            entry.set("inlocation", (Object)location);
        }
    }

    private boolean isUpdateWarehouse(DynamicObject bill) {
        DynamicObject invScheme = bill.getDynamicObject("invscheme");
        if (invScheme == null) {
            return false;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        return isInUpdate && isOutUpdate;
    }

    private void setEntryCustomer(DynamicObject entry, DynamicObject customer, String[] fieldKeys) {
        if (customer == null) {
            return;
        }
        for (String fieldKey : fieldKeys) {
            Object value = entry.get(fieldKey);
            if (value != null) continue;
            entry.set(fieldKey, (Object)customer);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new TransitLocationMustInputValidator("inwarehouse", "inlocation"));
        e.addValidator((AbstractValidator)new SalOutBillSaveValidator());
    }
}

