/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.outbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceHelper;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceSwitch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import kd.scmc.im.business.helper.logisticsbill.LogisticsBillHelper;
import org.apache.commons.lang3.StringUtils;

public class SaleOutBillUnAuditOp
extends AbstractOperationServicePlugIn {
    protected static final Log logger = LogFactory.getLog(SaleOutBillUnAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("supplytrans");
        e.getFieldKeys().add("remainreturnqty");
        e.getFieldKeys().add("remainreturnbaseqty");
        e.getFieldKeys().add("remainjoinpriceqty");
        e.getFieldKeys().add("remainjoinpricebaseqty");
        e.getFieldKeys().add("returnqty");
        e.getFieldKeys().add("returnbaseqty");
        e.getFieldKeys().add("joinpriceqty");
        e.getFieldKeys().add("joinpricebaseqty");
        e.getFieldKeys().add("verifyqty");
        e.getFieldKeys().add("verifybaseqty");
        e.getFieldKeys().add("unverifyqty");
        e.getFieldKeys().add("unverifybaseqty");
        e.getFieldKeys().add("entrustverifyqty");
        e.getFieldKeys().add("entrustverifybaseqty");
        e.getFieldKeys().add("entrustunverifyqty");
        e.getFieldKeys().add("entrustunverifybaseqty");
        e.getFieldKeys().add("isinitbill");
        e.getFieldKeys().add("joincfmqty");
        e.getFieldKeys().add("joincfmbaseqty");
        e.getFieldKeys().add("remaincfmqty");
        e.getFieldKeys().add("remaincfmbaseqty");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        logger.info("SaleOutBillUnAuditOp:\u5224\u65ad\u53cd\u6838\u9500\u63a5\u53e3");
        if (MetaDataHelper.isBizAppExistAp()) {
            DynamicObject[] invBills = e.getDataEntities();
            Object[] billpks = new Object[invBills.length];
            for (int i = 0; i < invBills.length; ++i) {
                DynamicObject invBill = invBills[i];
                boolean isLogisticsBill = LogisticsBillHelper.isLogisticsBill((DynamicObject)invBill);
                if (isLogisticsBill) continue;
                billpks[i] = invBill.getPkValue();
            }
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"arautoverify", (String)"unAutoVerify", (Object[])new Object[]{billpks, true});
            logger.info("SaleOutBillUnAuditOp:\u8c03\u7528\u53cd\u6838\u9500\u63a5\u53e3");
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        this.dealQtyField(bills);
    }

    private void dealQtyField(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                entry.set("returnbaseqty", (Object)BigDecimal.ZERO);
                entry.set("returnqty", (Object)BigDecimal.ZERO);
                entry.set("remainreturnqty", (Object)BigDecimal.ZERO);
                entry.set("remainreturnbaseqty", (Object)BigDecimal.ZERO);
                entry.set("joinpriceqty", (Object)BigDecimal.ZERO);
                entry.set("joinpricebaseqty", (Object)BigDecimal.ZERO);
                entry.set("remainjoinpriceqty", (Object)BigDecimal.ZERO);
                entry.set("remainjoinpricebaseqty", (Object)BigDecimal.ZERO);
                entry.set("joincfmqty", (Object)BigDecimal.ZERO);
                entry.set("joincfmbaseqty", (Object)BigDecimal.ZERO);
                entry.set("remaincfmqty", (Object)BigDecimal.ZERO);
                entry.set("remaincfmbaseqty", (Object)BigDecimal.ZERO);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.deleteDeliveryRecord(e.getDataEntities());
    }

    private void deleteDeliveryRecord(DynamicObject[] curBills) {
        if (!SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0002")) {
            return;
        }
        HashMap<Long, String> billNoMap = new HashMap<Long, String>(curBills.length);
        ArrayList<Long> billIds = new ArrayList<Long>(curBills.length);
        for (DynamicObject bill : curBills) {
            Long pk = bill.getLong("id");
            String billNo = bill.getString("billno");
            billIds.add(pk);
            billNoMap.put(pk, billNo);
        }
        logger.info("\u5220\u9664\u6e20\u9053\u4e91\u53d1\u8d27\u8bb0\u5f55-\u5f00\u59cb:" + StringUtils.join(billIds, (String)","));
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"drp", (String)"bbc", (String)"BBCBosExtendService", (String)"isSaloutbillUnaudit", (Object[])new Object[]{billIds});
        this.showErrorMsg(result, billNoMap);
        if (ECServiceSwitch.isOpened()) {
            CommonParam commonParam = CommonParam.valueOf(billNoMap);
            ECServiceHelper.execute((String)"im_saleoutbill_unaudit", (String)"delete_occ", (String)"occ", (String)"ocbsoc", (String)"OCBSOCBosExtendEventualServiceImpl", (Param)commonParam);
        } else {
            Map occResult = (Map)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbsoc", (String)"OCBSOCBosExtendService", (String)"isSaloutbillUnaudit", (Object[])new Object[]{billIds});
            this.showErrorMsg(occResult, billNoMap);
            logger.info("\u5220\u9664\u5168\u6e20\u9053\u4e91\u53d1\u8d27\u8bb0\u5f55-\u7ed3\u675f");
        }
    }

    private void showErrorMsg(Map<Object, Object> result, Map<Long, String> billNoMap) {
        Boolean isSuccess;
        if (result != null && !result.isEmpty() && !(isSuccess = (Boolean)result.get("result")).booleanValue()) {
            StringBuilder errorMsg = new StringBuilder();
            String message = (String)result.get("msg");
            Object[] billIds = (Object[])result.get("billIds");
            String str = String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u539f\u56e0\uff1a{0}\u3002", (String)"SaleOutBillUnAuditOp_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), message);
            errorMsg.append(str);
            errorMsg.append("[");
            for (int i = 0; i < billIds.length; ++i) {
                Object billId = billIds[i];
                String billNo = billNoMap.get(Long.valueOf(billId.toString()));
                if (StringUtils.isEmpty((CharSequence)billNo)) continue;
                if (i > 0) {
                    errorMsg.append(",");
                }
                errorMsg.append(billNo);
            }
            errorMsg.append("]");
            logger.info("\u5220\u9664\u6e20\u9053\u4e91\u53d1\u8d27\u8bb0\u5f55-\u5931\u8d25" + errorMsg);
            throw new KDBizException(errorMsg.toString());
        }
    }
}

