/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.setup;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.validator.setup.DefaultWarehouseSaveValidator;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.ObjectUtils;

public class DefaultWarehouseSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new DefaultWarehouseSaveValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("materialnumber");
        e.getFieldKeys().add("materialmasterid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] entities;
        super.beginOperationTransaction(e);
        for (DynamicObject data : entities = e.getDataEntities()) {
            DynamicObject materialInfo = data.getDynamicObject("materialnumber");
            if (materialInfo != null) {
                data.set("materialmasterid", (Object)materialInfo.getDynamicObject("masterid"));
                continue;
            }
            data.set("materialmasterid", null);
        }
        this.generateWarehouseSetup(entities);
    }

    private void generateWarehouseSetup(DynamicObject[] entities) {
        Long warehouseId;
        Long orgId;
        Map<Long, Set<Long>> orgWarehouseIdMap = Arrays.stream(entities).collect(Collectors.toMap(entity -> this.getPkId(entity.getDynamicObject("org")), entity -> Collections.singleton(this.getPkId(entity.getDynamicObject("defaultwarehouse"))), (list1, list2) -> {
            HashSet set = new HashSet();
            set.addAll(list1);
            set.addAll(list2);
            return set;
        }));
        QFilter qFilter = DefaultWarehouseSaveOp.getOrgWarehouseFilter(orgWarehouseIdMap);
        DynamicObject[] warehouseSetupDyms = BusinessDataServiceHelper.load((String)"im_warehousesetup", (String)"org,warehouse,materialentity.materialgrpnumber,materialentity.materialnumber,materialentity.materialmasterid", (QFilter[])qFilter.toArray());
        if (ObjectUtils.isEmpty((Object)warehouseSetupDyms)) {
            return;
        }
        MultiKeyMap warehouseSetupMap = new MultiKeyMap();
        MultiKeyMap materielWarehouseSetupMap = new MultiKeyMap();
        MultiKeyMap materielgrpWarehouseSetupMap = new MultiKeyMap();
        for (DynamicObject warehouseSetupDym : warehouseSetupDyms) {
            orgId = this.getPkId(warehouseSetupDym.getDynamicObject("org"));
            warehouseId = this.getPkId(warehouseSetupDym.getDynamicObject("warehouse"));
            warehouseSetupMap.put((Object)orgId, (Object)warehouseId, (Object)warehouseSetupDym);
            DynamicObjectCollection entryRows = warehouseSetupDym.getDynamicObjectCollection("materialentity");
            for (DynamicObject entryRow : entryRows) {
                DynamicObject materielGrpDym;
                DynamicObject materielDym = entryRow.getDynamicObject("materialnumber");
                if (null != materielDym) {
                    materielWarehouseSetupMap.put((Object)orgId, (Object)warehouseId, (Object)this.getPkId(materielDym), (Object)"1");
                }
                if (null == (materielGrpDym = entryRow.getDynamicObject("materialgrpnumber"))) continue;
                materielgrpWarehouseSetupMap.put((Object)orgId, (Object)warehouseId, (Object)this.getPkId(materielGrpDym), (Object)"1");
            }
        }
        for (DynamicObject entity2 : entities) {
            orgId = this.getPkId(entity2.getDynamicObject("org"));
            warehouseId = this.getPkId(entity2.getDynamicObject("defaultwarehouse"));
            Long materialId = this.getPkId(entity2.getDynamicObject("materialnumber"));
            Long materialGrpId = this.getPkId(entity2.getDynamicObject("materialgrpnumber"));
            DynamicObject warehouseSetup = (DynamicObject)warehouseSetupMap.get((Object)orgId, (Object)warehouseId);
            if (null == warehouseSetup || null != materialId && materielWarehouseSetupMap.containsKey((Object)orgId, (Object)warehouseId, (Object)materialId) || null != materialGrpId && materielgrpWarehouseSetupMap.containsKey((Object)orgId, (Object)warehouseId, (Object)materialGrpId)) continue;
            DynamicObjectCollection collection = warehouseSetup.getDynamicObjectCollection("materialentity");
            DynamicObject newRow = collection.addNew();
            if (null != materialId) {
                DynamicObject materialDym = BusinessDataServiceHelper.newDynamicObject((String)"bd_materialinventoryinfo");
                materialDym.set("id", (Object)materialId);
                newRow.set("materialnumber", (Object)materialDym);
                newRow.set("materialmasterid", (Object)entity2.getDynamicObject("materialmasterid"));
                continue;
            }
            if (null == materialGrpId) continue;
            DynamicObject dym = BusinessDataServiceHelper.newDynamicObject((String)"bd_materialgroup");
            dym.set("id", (Object)materialGrpId);
            newRow.set("materialgrpnumber", (Object)dym);
        }
        if (ObjectUtils.isEmpty((Object)warehouseSetupDyms)) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])warehouseSetupDyms);
    }

    private static QFilter getOrgWarehouseFilter(Map<Long, Set<Long>> orgWarehouseMap) {
        QFilter orgWarehouseFilters = new QFilter("1", "=", (Object)2);
        for (Map.Entry<Long, Set<Long>> entry : orgWarehouseMap.entrySet()) {
            QFilter orgf = new QFilter("org.id", "=", (Object)entry.getKey());
            QFilter orgWarehousef = new QFilter("warehouse.id", "in", (Object)entry.getValue().toArray());
            orgWarehousef.and(orgf);
            orgWarehouseFilters.or(orgWarehousef);
        }
        return orgWarehouseFilters;
    }

    private Long getPkId(Object obj) {
        if (obj instanceof DynamicObject) {
            return (Long)((DynamicObject)obj).getPkValue();
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return null;
    }
}

