/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.sn;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.consts.InvBillConst;
import kd.scmc.im.errorcode.InvBaseErrorCode;
import kd.scmc.im.helper.TriggerEventHelper;
import kd.scmc.im.validator.tpl.SerialNumberSaveValidator;

public class SerialNumberDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        InvBillConst.getSelectorListForAcc().forEach(field -> e.getFieldKeys().add(field));
        SerialNumberDeleteOp.getSubEntryList().forEach(field -> e.getFieldKeys().add(field));
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("billentry.afterentity.seq");
    }

    public static List<String> getSubEntryList() {
        List<String> selectors = Arrays.asList("ownertype", "owner", "keepertype", "keeper", "invstatus", "invtype", "material", "auxpty", "warehouse", "location", "lot", "lotnumber", "producedate", "expirydate", "project", "baseunit", "baseqty", "qty", "unit2nd", "qtyunit2nd", "entrycomment");
        selectors.forEach(field -> selectors.set(selectors.indexOf(field), field + "1"));
        return selectors;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new SerialNumberSaveValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"SerialNumberDeleteOp", (String)"endOperationTransaction");){
            DynamicObject[] invBills = e.getDataEntities();
            if (invBills == null) {
                throw new KDBizException(InvBaseErrorCode.getBILL_NOT_EXISTS(), new Object[0]);
            }
            String operate = (String)this.operateMeta.get("type");
            String formId = this.billEntityType.getName();
            TriggerEventHelper triggerEventHelper = new TriggerEventHelper();
            triggerEventHelper.triggerEventByOp(invBills, operate, formId, this.getOption());
        }
    }
}

