/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.sn;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.SerialNumberHelper;
import kd.scmc.im.consts.InvBillConst;
import kd.scmc.im.validator.tpl.SerialNumberSaveValidator;

public class SerialNumberSaveOp
extends AbstractOperationServicePlugIn {
    private boolean isFromDataBase = true;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        InvBillConst.getSelectorListForAcc().forEach(field -> e.getFieldKeys().add(field));
        SerialNumberSaveOp.getSubEntryList().forEach(field -> e.getFieldKeys().add(field));
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("billentry.afterentity.seq");
    }

    public static List<String> getSubEntryList() {
        List<String> selectors = Arrays.asList("ownertype", "owner", "keepertype", "keeper", "invstatus", "invtype", "material", "auxpty", "warehouse", "location", "lot", "lotnumber", "producedate", "expirydate", "project", "baseunit", "baseqty", "qty", "unit2nd", "qtyunit2nd", "entrycomment");
        selectors.forEach(field -> selectors.set(selectors.indexOf(field), field + "1"));
        return selectors;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities != null && dataEntities.length != 0) {
            this.isFromDataBase = dataEntities[0].getDataEntityState().getFromDatabase();
            if (this.isFromDataBase) {
                e.addValidator((AbstractValidator)new SerialNumberSaveValidator());
            }
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.isFromDataBase = e.getDataEntities()[0].getDataEntityState().getFromDatabase();
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] entities;
        for (DynamicObject bill : entities = e.getDataEntities()) {
            bill.set("lastupdateuser", (Object)UserServiceHelper.getCurrentUser((String)"id"));
            bill.set("lastupdatetime", (Object)new Date());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        if (entities == null || entities.length == 0) {
            return;
        }
        String billtype = entities[0].getDataEntityType().getName();
        boolean isHasSubEntry = false;
        if ("im_assembbill".equals(billtype) || "im_adjustbill".equals(billtype) || "im_disassemblebill".equals(billtype)) {
            isHasSubEntry = true;
        }
        HashSet<String> ids = new HashSet<String>(16);
        HashSet<String> entryIds = new HashSet<String>(16);
        for (DynamicObject entity : entities) {
            ids.add(entity.getPkValue().toString());
            DynamicObjectCollection billentries = entity.getDynamicObjectCollection("billentry");
            for (DynamicObject billentry : billentries) {
                DynamicObject material = billentry.getDynamicObject("material");
                if (material != null && material.getBoolean("enableserial")) {
                    entryIds.add(billentry.getPkValue().toString());
                }
                if (!isHasSubEntry) continue;
                DynamicObjectCollection subentries = billentry.getDynamicObjectCollection("afterentity");
                for (DynamicObject subentry : subentries) {
                    DynamicObject submaterial = subentry.getDynamicObject("material1");
                    if (submaterial == null || !submaterial.getBoolean("enableserial")) continue;
                    entryIds.add(subentry.getPkValue().toString());
                }
            }
        }
        if (this.isFromDataBase) {
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"BillSNRelationService", (String)"deleteSurplusRelation", (Object[])new Object[]{billtype, ids, entryIds});
        } else if (!isHasSubEntry) {
            if (entities == null || entities.length == 0) {
                return;
            }
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"CarryingSerialNumberService", (String)"carryingSerialNumber", (Object[])new Object[]{entities});
        }
        if (entryIds.size() > 0 && !isHasSubEntry) {
            SerialNumberHelper.copySerialnumToRel((DynamicObject[])entities, (String)"billentry");
        }
    }
}

