/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.tpl;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.scmc.im.helper.InvDbParamHelper;
import kd.scmc.im.utils.CommonUtils;

public class BillTplAuditTimeSaveOp
extends AbstractOperationServicePlugIn {
    private static String insertSql = "insert into t_im_audittimerecord (fid, fbillid, fentitynum, ftraceid, faudittime) values (?, ?, ?, ?, ?)";
    private static String deleteSqlPre = "delete from t_im_audittimerecord where fid in (%s)";
    private static String IS_SAVE_AUDITTIME = "issaveaudittime";
    private static String AUDIT_DATE = "auditdate";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add(AUDIT_DATE);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.auditTimeSave(e.getDataEntities(), this.billEntityType.getName());
    }

    private void auditTimeSave(DynamicObject[] invBills, String entityName) {
        if (invBills == null || invBills.length == 0 || !InvDbParamHelper.getInvDbParam((String)IS_SAVE_AUDITTIME)) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(invBills.length);
        DBRoute route = new DBRoute("scm");
        String traceId = RequestContext.get().getTraceId();
        ArrayList<Object> ids = new ArrayList<Object>(invBills.length);
        for (int i = 0; i < invBills.length; ++i) {
            DynamicObject invBill = invBills[i];
            ids.add(invBill.getPkValue());
            Date audittime = invBill.getDate(AUDIT_DATE);
            Object[] param = new Object[]{invBill.getPkValue(), invBill.getPkValue(), entityName, traceId, audittime};
            params.add(param);
        }
        String deleteSql = String.format(deleteSqlPre, CommonUtils.collectionToStr(ids));
        DB.execute((DBRoute)route, (String)deleteSql);
        DB.executeBatch((DBRoute)route, (String)insertSql, params);
    }
}

