/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.tpl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.scmc.im.business.helper.InvBillCalSyncHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import kd.scmc.im.business.listener.InvBillCalSyncListener;

public class BillTplCalSyncOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(BillTplCalSyncOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        if (!SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0001")) {
            return;
        }
        if (!SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0005")) {
            return;
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Object> billIds = new HashSet<Object>(16);
        for (DynamicObject dataEntity : dataEntities) {
            billIds.add(dataEntity.getPkValue());
        }
        final String requestId = RequestContext.get().getRequestId();
        String appId = this.billEntityType.getAppId();
        final IAppCache iAppCache = AppCache.get((String)appId);
        iAppCache.put(requestId, billIds);
        final DBRoute dbRoute = new DBRoute("scm");
        ThreadPools.executeOnce((String)"BillTplCalSync", (Runnable)new Runnable(){

            @Override
            public void run() {
                Set billIds;
                while ((billIds = (Set)iAppCache.get(requestId, Set.class)) != null) {
                    String updateSql = "update t_im_taskcollaborate set feffectivetime = ? where fbillid in (?) and frequestid = ?";
                    ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
                    long timeMillis = System.currentTimeMillis() + 10000L;
                    for (Object billId : billIds) {
                        Object[] param = new Object[]{timeMillis, billId, requestId};
                        updateParams.add(param);
                    }
                    try (TXHandle tx = TX.requiresNew();){
                        BillTplCalSyncOp.this.updateEffTime(dbRoute, updateSql, updateParams);
                    }
                    try {
                        TimeUnit.SECONDS.sleep(3L);
                    }
                    catch (InterruptedException ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        if (!SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0001")) {
            return;
        }
        if (!SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0005")) {
            return;
        }
        HashSet<Long> billIds = new HashSet<Long>(16);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            billIds.add(dataEntity.getLong("id"));
        }
        String requestId = RequestContext.get().getRequestId();
        CommonParam commonParam = InvBillCalSyncHelper.createParam(billIds, (String)requestId, (MainEntityType)this.billEntityType);
        InvBillCalSyncListener invBillCalSyncListener = new InvBillCalSyncListener(commonParam);
        TX.addCommitListener((CommitListener)invBillCalSyncListener);
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        if (!SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0001")) {
            return;
        }
        if (!SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0005")) {
            return;
        }
        IOperationResult iOperationResult = e.getOperationResult();
        List successPkIds = iOperationResult.getSuccessPkIds();
        if (iOperationResult instanceof OperationResult) {
            OperationResult operationResult = (OperationResult)iOperationResult;
            Map billNos = operationResult.getBillNos();
            Set billIds = billNos.keySet();
            billIds.removeAll(successPkIds);
            Map variables = this.getOption().getVariables();
            if (variables != null && variables.containsKey("afterFailbillIds")) {
                String afterFailBillIds = (String)variables.get("afterFailbillIds");
                String[] splitFailBillIds = afterFailBillIds.split(",");
                HashSet<Long> splitBillIds = new HashSet<Long>(16);
                for (String splitBillId : splitFailBillIds) {
                    splitBillIds.add(Long.valueOf(splitBillId));
                }
                billIds.removeAll(splitBillIds);
            }
            String requestId = RequestContext.get().getRequestId();
            if (!billIds.isEmpty()) {
                Object billId22;
                String updateSql = "update t_im_taskcollaborate set feffectivetime = ? where frequestid = ? and fbillid in (?) ";
                ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
                long currentTimeMillis = System.currentTimeMillis();
                for (Object billId22 : billIds) {
                    Object[] updateParam = new Object[]{currentTimeMillis, requestId, billId22};
                    updateParams.add(updateParam);
                }
                TXHandle tx = TX.requiresNew();
                billId22 = null;
                try {
                    DB.executeBatch((DBRoute)new DBRoute("scm"), (String)updateSql, updateParams);
                }
                catch (Throwable updateParam) {
                    billId22 = updateParam;
                    throw updateParam;
                }
                finally {
                    if (tx != null) {
                        if (billId22 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable updateParam) {
                                ((Throwable)billId22).addSuppressed(updateParam);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
                Set failBillIds = billIds.stream().map(billId -> (Long)billId).collect(Collectors.toSet());
                CommonParam commonParam = InvBillCalSyncHelper.createParam(failBillIds, (String)requestId, (MainEntityType)this.billEntityType);
                try (TXHandle tx2 = TX.requiresNew();){
                    try {
                        InvBillCalSyncHelper.createSession((String)"InvBillCalRollBackService", (CommonParam)commonParam);
                    }
                    catch (Exception ex) {
                        tx2.markRollback();
                        throw ex;
                    }
                }
            }
        }
    }

    private void updateEffTime(DBRoute dbRoute, String updateSql, List<Object[]> updateParams) {
        DB.executeBatch((DBRoute)dbRoute, (String)updateSql, updateParams);
    }
}

