/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.tpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.bizrule.asyncbizrule.enums.AsyncStatusEnum;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.BizGroupRecordHelper;
import kd.scmc.im.business.helper.CloseDateHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.logisticsbill.LogisticsBillModel;
import kd.scmc.im.consts.InvBillConst;
import kd.scmc.im.errorcode.InvBaseErrorCode;
import kd.scmc.im.errorcode.InvHomePageErrorCode;
import kd.scmc.im.helper.TriggerEventHelper;
import kd.scmc.im.utils.DateUtils;
import kd.scmc.im.validator.general.LocationMustInputValidator;
import kd.scmc.im.validator.general.ServiceAttributeValidator;
import kd.scmc.im.validator.plugin.BillTplBaseValidatorPlugin;

public final class BillTplSubmitOp
extends AbstractOperationServicePlugIn {
    private static Set<String> verifyFields = new HashSet<String>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(InvBillConst.getSelectorListForAcc());
        e.getFieldKeys().addAll(verifyFields);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        if (!"im_locationtransfer".equals(this.billEntityType.getName())) {
            e.getValidators().add(new LocationMustInputValidator("warehouse", "location"));
        }
        if (!"im_initbill".equals(this.billEntityType.getName())) {
            e.addValidator((AbstractValidator)new ServiceAttributeValidator());
        }
        BillTplBaseValidatorPlugin tplValidator = new BillTplBaseValidatorPlugin(e, "submit", this.billEntityType.getName());
        tplValidator.validate();
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        try (TraceSpan span = Tracer.create((String)"BillTplSubmitOp", (String)"beforeExecuteOperationTransaction");){
            super.beforeExecuteOperationTransaction(e);
            Map param = this.getOption().getVariables();
            if (param.get("qty") != null) {
                List nums = (List)SerializationUtils.fromJsonString((String)((String)param.get("qty")), List.class);
                List whs = (List)SerializationUtils.fromJsonString((String)((String)param.get("warehouse")), List.class);
                DynamicObjectCollection doc = ((ExtendedDataEntity)e.getValidExtDataEntities().get(0)).getDataEntity().getDynamicObjectCollection("billentry");
                if (doc.size() != nums.size()) {
                    throw new KDBizException(new InvHomePageErrorCode().getDATA_NOT_SHARE(), new Object[0]);
                }
                for (int i = 0; i < nums.size(); ++i) {
                    DynamicObject entity = (DynamicObject)doc.get(i);
                    entity.set("qty", nums.get(i));
                    entity.set("warehouse", whs.get(i));
                }
            }
            DynamicObject[] invBills = e.getDataEntities();
            String formId = this.billEntityType.getName();
            ArrayList<DynamicObject> logisticsBills = new ArrayList<DynamicObject>(invBills.length);
            for (DynamicObject bill : invBills) {
                logisticsBills.add(bill);
            }
            LogisticsBillModel logisticsBillModel = LogisticsBillModel.getInstance();
            logisticsBillModel.matchLogisticsBill(formId, logisticsBills);
            if (LotMainFileHelper.isUseLotMainFile()) {
                LotMainFileHelper.matchBillLotId((DynamicObject[])invBills, (String)"submit");
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"BillTplSubmitOp", (String)"beginOperationTransaction");){
            DynamicObject[] invBills = e.getDataEntities();
            CloseDateHelper.setBookdate2Biztime((String)this.billEntityType.getName(), (DynamicObject[])e.getDataEntities());
            for (DynamicObject invBill : invBills) {
                invBill.set("biztime", (Object)DateUtils.getDate((Date)invBill.getDate("biztime")));
                invBill.set("bookdate", (Object)DateUtils.getDate((Date)invBill.getDate("bookdate")));
                invBill.set("asyncstatus", (Object)AsyncStatusEnum.FINISHED.getValue());
                invBill.set("lastupdateuser", (Object)UserServiceHelper.getCurrentUser((String)"id"));
                invBill.set("lastupdatetime", (Object)new Date());
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"BillTplSubmitOp", (String)"endOperationTransaction");){
            DynamicObject[] invBills = e.getDataEntities();
            if (invBills == null) {
                throw new KDBizException(InvBaseErrorCode.getBILL_NOT_EXISTS(), new Object[0]);
            }
            String operate = (String)this.operateMeta.get("type");
            String formId = this.billEntityType.getName();
            TriggerEventHelper triggerEventHelper = new TriggerEventHelper();
            triggerEventHelper.triggerEventByOp(e.getDataEntities(), operate, formId, this.getOption());
            if (BizGroupRecordHelper.isBizGroupModel()) {
                HashSet<Long> invBillIds = new HashSet<Long>(16);
                for (DynamicObject invBill : invBills) {
                    Long id = invBill.getLong("id");
                    invBillIds.add(id);
                }
                BizGroupRecordHelper.createRecord(invBillIds, (String)formId, (boolean)true);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        try (TraceSpan span = Tracer.create((String)"BillTplSubmitOp", (String)"afterExecuteOperationTransaction");){
            super.afterExecuteOperationTransaction(e);
        }
    }

    static {
        verifyFields.add("warehouse");
        verifyFields.add("auditdate");
        verifyFields.add("asyncstatus");
        verifyFields.add("stockindate");
        verifyFields.add("lotnumber");
        verifyFields.add("isinitbill");
        verifyFields.add("isvirtualbill");
        verifyFields.add("operator");
        verifyFields.add("outoperator");
        verifyFields.add("material");
        verifyFields.add("unit2nd");
        verifyFields.add("qtyunit2nd");
        verifyFields.add("logisticsbill");
        verifyFields.add("invtype");
        verifyFields.add("outinvtype");
        verifyFields.add("ininvtype");
        verifyFields.add("billentry.seq");
        verifyFields.add("ownertype");
        verifyFields.add("owner");
        verifyFields.add("entrysettleorg");
        verifyFields.add("outownertype");
        verifyFields.add("outowner");
        verifyFields.add("settleorg");
        verifyFields.add("supplyowner");
        verifyFields.add("billentry_lk");
        verifyFields.add("billcretype");
        verifyFields.add("biztype");
        verifyFields.add("ischargeoff");
        verifyFields.add("ischargeoffed");
        verifyFields.add("kitproducttype");
    }
}

