/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.tpl;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.BizGroupRecordHelper;
import kd.scmc.im.business.helper.acct.BalanceHelper;
import kd.scmc.im.consts.InvBalanceConst;
import kd.scmc.im.consts.InvBillConst;
import kd.scmc.im.errorcode.InvBaseErrorCode;
import kd.scmc.im.helper.TriggerEventHelper;
import kd.scmc.im.validator.plugin.BillTplBaseValidatorPlugin;

public final class BillTplUnAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(InvBillConst.getSelectorListForAcc());
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("stockindate");
        e.getFieldKeys().add("entrysettleorg");
        e.getFieldKeys().add("logisticsbill");
        e.getFieldKeys().add("isinitbill");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("isvirtualbill");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        BillTplBaseValidatorPlugin tplValidator = new BillTplBaseValidatorPlugin(e, "unaudit", this.billEntityType.getName());
        tplValidator.validate();
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"BillTplUnAuditOp", (String)"beginOperationTransaction");){
            DynamicObject[] invBills = e.getDataEntities();
            if (invBills == null || invBills.length == 0) {
                throw new KDBizException(InvBaseErrorCode.getBILL_NOT_EXISTS(), new Object[0]);
            }
            ArrayList<Long> pks = new ArrayList<Long>(invBills.length + 1);
            for (DynamicObject invBill : invBills) {
                pks.add(invBill.getLong("id"));
            }
            String formId = this.billEntityType.getName();
            if (formId.equals("im_initbill")) {
                BalanceHelper.unInitBalanceUpdate((String)formId, pks);
            } else if (InvBalanceConst.getBalBillList().contains(formId)) {
                BalanceHelper.unAuditBalanceUpdate((String)formId, pks);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"BillTplUnAuditOp", (String)"endOperationTransaction");){
            String operate = (String)this.operateMeta.get("type");
            String formId = this.billEntityType.getName();
            TriggerEventHelper triggerEventHelper = new TriggerEventHelper();
            triggerEventHelper.triggerEventByOp(e.getDataEntities(), operate, formId, this.getOption());
            if (BizGroupRecordHelper.isBizGroupModel()) {
                DynamicObject[] invBills = e.getDataEntities();
                HashSet<Long> invBillIds = new HashSet<Long>(16);
                for (DynamicObject invBill : invBills) {
                    Long id = invBill.getLong("id");
                    invBillIds.add(id);
                }
                BizGroupRecordHelper.deleteRecord(invBillIds, (String)formId, (boolean)false);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        try (TraceSpan span = Tracer.create((String)"BillTplUnAuditOp", (String)"afterExecuteOperationTransaction");){
            super.afterExecuteOperationTransaction(e);
            DynamicObject[] bills = e.getDataEntities();
            if (bills == null || bills.length == 0) {
                return;
            }
        }
    }
}

