/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.tpl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.opplugin.tpl.BillTplImportOp;
import org.apache.commons.collections.CollectionUtils;

public class SalOutBillImportOp
extends BillTplImportOp {
    private Map<String, Object> cusLinkMansMap = new HashMap<String, Object>();
    private Map<String, DynamicObject> materProductlineMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> productlineMap = new HashMap<String, DynamicObject>(16);

    @Override
    protected void cacheBaseData(List<ImportBillData> rowdatas, ImportLogger logger) {
        super.cacheBaseData(rowdatas, logger);
        HashSet<Object> recCustomerNums = new HashSet<Object>(16);
        HashSet<Object> bizOperatorNums = new HashSet<Object>(16);
        HashSet<Object> bizOpergrpnumbers = new HashSet<Object>(16);
        HashSet<Object> productlineNums = new HashSet<Object>(16);
        HashSet orgNumbers = new HashSet(16);
        for (ImportBillData rowdata : rowdatas) {
            Map orgMap;
            Map productlineGroup;
            Map operatorGroup;
            Map operator;
            Map bizOpergrp;
            Map bizOperator;
            JSONObject data = rowdata.getData();
            Map customer = (Map)data.get((Object)"customer");
            if (customer != null && customer.get("number") != null) {
                recCustomerNums.add(customer.get("number"));
            }
            if ((bizOperator = (Map)data.get((Object)"bizoperator")) != null && bizOperator.get(bizOperator.getOrDefault("importprop", "number")) != null) {
                bizOperatorNums.add(bizOperator.get(bizOperator.getOrDefault("importprop", "number")));
            }
            if ((bizOpergrp = (Map)data.get((Object)"bizoperatorgroup")) != null && bizOpergrp.get(bizOpergrp.getOrDefault("importprop", "number")) != null) {
                bizOpergrpnumbers.add(bizOpergrp.get(bizOpergrp.getOrDefault("importprop", "number")));
            }
            if ((operator = (Map)data.get((Object)"operator")) != null && operator.get(operator.getOrDefault("importprop", "number")) != null) {
                bizOperatorNums.add(operator.get(operator.getOrDefault("importprop", "number")));
            }
            if ((operatorGroup = (Map)data.get((Object)"operatorgroup")) != null && operatorGroup.get(operatorGroup.getOrDefault("importprop", "number")) != null) {
                bizOpergrpnumbers.add(operatorGroup.get(operatorGroup.getOrDefault("importprop", "number")));
            }
            if ((productlineGroup = (Map)data.get((Object)"productline")) != null && productlineGroup.get(productlineGroup.getOrDefault("importprop", "number")) != null) {
                productlineNums.add(productlineGroup.get(productlineGroup.getOrDefault("importprop", "number")));
            }
            if ((orgMap = (Map)data.get((Object)"org")) == null || orgMap.get(orgMap.getOrDefault("importprop", "number")) == null) continue;
            orgNumbers.add(orgMap.get(orgMap.getOrDefault("importprop", "number")));
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter("number", "in", orgNumbers).toArray());
        if (org == null) {
            return;
        }
        Long orgId = org.getLong("id");
        this.cache4Customer(recCustomerNums);
        this.cache4BizOperator(bizOperatorNums, bizOpergrpnumbers, orgId);
        this.cache4Productline(productlineNums);
    }

    private void cache4Productline(Set<Object> productlineNums) {
        if (CollectionUtils.isNotEmpty(productlineNums)) {
            QFilter qFilter = new QFilter("number", "in", productlineNums);
            Map productlines = BusinessDataServiceHelper.loadFromCache((String)"bd_productline", (String)"id,name,number", (QFilter[])qFilter.toArray());
            for (Map.Entry mapEntry : productlines.entrySet()) {
                DynamicObject productlineDym = (DynamicObject)mapEntry.getValue();
                String productlineNum = productlineDym.getString("number");
                if (productlineDym == null) continue;
                this.productlineMap.put(productlineNum, productlineDym);
            }
        }
        HashSet materielNumbers = new HashSet(16);
        for (Map.Entry entry : this.materialDymOrgMap.entrySet()) {
            Map materielMap = (Map)entry.getValue();
            if (materielMap == null) continue;
            materielNumbers.addAll(materielMap.keySet());
        }
        if (CollectionUtils.isNotEmpty(materielNumbers)) {
            QFilter qFilter = new QFilter("number", "in", materielNumbers);
            Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"number,productline", (QFilter[])qFilter.toArray());
            for (Map.Entry mapEntry : map.entrySet()) {
                DynamicObject materielDym = (DynamicObject)mapEntry.getValue();
                String materielNumber = materielDym.getString("number");
                DynamicObject productlineDym = materielDym.getDynamicObject("productline");
                if (productlineDym == null) continue;
                this.materProductlineMap.put(materielNumber, productlineDym);
            }
        }
    }

    private void importSalBindData(ImportBillData rowdata) {
        JSONObject data = rowdata.getData();
        List listData = (List)data.get((Object)"billentry");
        for (Map row : listData) {
            this.update4Customer(data, row);
        }
        data.put("billentry", (Object)listData);
    }

    @Override
    protected void beforeImportBill(List<ImportBillData> rowdatas, ImportLogger logger) {
        super.beforeImportBill(rowdatas, logger);
        String saleName = ResManager.loadKDString((String)"\u9500\u552e\u5458", (String)"SalOutBillImportOp_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        String saleGroupName = ResManager.loadKDString((String)"\u9500\u552e\u7ec4", (String)"SalOutBillImportOp_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        this.update4BizOperator(rowdatas, "bizoperator", "bizoperatorgroup", logger, saleName, saleGroupName);
        String manageName = ResManager.loadKDString((String)"\u5e93\u7ba1\u5458", (String)"SalOutBillImportOp_2", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        String manageGroupName = ResManager.loadKDString((String)"\u5e93\u7ba1\u7ec4", (String)"SalOutBillImportOp_3", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        this.update4BizOperator(rowdatas, "operator", "operatorgroup", logger, manageName, manageGroupName);
        for (ImportBillData rowdata : rowdatas) {
            this.importSalBindData(rowdata);
        }
    }

    private void update4Customer(JSONObject data, Map<String, Object> entry) {
        Map reclinkman = (Map)entry.get("reclinkman");
        Map customer = (Map)data.get((Object)"customer");
        if (reclinkman != null) {
            if (customer == null) {
                entry.remove("reclinkman");
                return;
            }
            Object recCusNum = customer.get("number");
            Object recLinkmanNum = reclinkman.get("phone");
            String key = recCusNum + "_" + recLinkmanNum;
            Object cuslinkManId = this.cusLinkMansMap.get(key);
            if (cuslinkManId == null) {
                entry.remove("providerlinkman");
                return;
            }
            reclinkman.put("id", cuslinkManId);
        }
    }

    private void cache4Customer(Set<Object> recCustomerNums) {
        if (recCustomerNums.isEmpty()) {
            return;
        }
        DynamicObjectCollection recCustomers = QueryServiceHelper.query((String)"bd_customer", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", recCustomerNums)});
        HashMap<Long, String> cusMap = new HashMap<Long, String>(16);
        for (DynamicObject recCustomer : recCustomers) {
            cusMap.put(Long.parseLong(recCustomer.getString("id")), recCustomer.getString("number"));
        }
        if (!cusMap.isEmpty()) {
            DynamicObjectCollection providerLinkMans = QueryServiceHelper.query((String)"bd_customerlinkman", (String)"customerid,id,contactperson,phone", (QFilter[])new QFilter[]{new QFilter("customerid", "in", cusMap.keySet())});
            for (DynamicObject providerLinkMan : providerLinkMans) {
                String key = (String)cusMap.get(Long.parseLong(providerLinkMan.getString("customerid"))) + "_" + providerLinkMan.getString("phone");
                this.cusLinkMansMap.put(key, providerLinkMan.getLong("id"));
            }
        }
    }

    @Override
    protected void initBill2Qty(Map<String, Object> data, List<Map<String, Object>> listData, ImportLogger logger) {
        super.initBill2Qty(data, listData, logger);
        for (Map<String, Object> entry : listData) {
            entry.put("unverifyqty", BigDecimal.ZERO);
            entry.put("verifyqty", BigDecimal.ZERO);
            entry.put("returnqty", BigDecimal.ZERO);
            entry.put("remainreturnqty", BigDecimal.ZERO);
            entry.put("joinpriceqty", BigDecimal.ZERO);
            entry.put("remainjoinpriceqty", BigDecimal.ZERO);
            entry.put("unverifybaseqty", BigDecimal.ZERO);
            entry.put("verifybaseqty", BigDecimal.ZERO);
            entry.put("remainjoinpricebaseqty", BigDecimal.ZERO);
            entry.put("joinpricebaseqty", BigDecimal.ZERO);
            entry.put("remainreturnbaseqty", BigDecimal.ZERO);
            entry.put("returnbaseqty", BigDecimal.ZERO);
        }
    }

    @Override
    protected void initEntryData(JSONObject data, Map<String, Object> row) {
        String materielNumber;
        DynamicObject productlineDym;
        super.initEntryData(data, row);
        Map productline = (Map)row.get("productline");
        Map material = (Map)row.get("material");
        if (productline == null && material != null && null != (productlineDym = this.materProductlineMap.get(materielNumber = material.getOrDefault("number", "")))) {
            HashMap<String, String> initProductlineMap = new HashMap<String, String>(4);
            initProductlineMap.put("importprop", "number");
            initProductlineMap.put("number", productlineDym.getString("number"));
            initProductlineMap.put("name", productlineDym.getString("name"));
            row.put("productline", initProductlineMap);
        }
    }
}

