/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.transbill;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class TransDirAutoPushScmOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(TransDirAutoPushScmOp.class);
    private static final String MODULE_DELIVERY = "pur_moduledelivery";
    private static final String BILL_ENTRY = "billentry";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billentry.keeper");
        e.getFieldKeys().add(BILL_ENTRY);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try {
            DynamicObject[] dataEntities = e.getDataEntities();
            for (int i = 0; i < dataEntities.length; ++i) {
                DynamicObject dataEntity = dataEntities[i];
                DynamicObjectCollection billEntryEntity = dataEntity.getDynamicObjectCollection(BILL_ENTRY);
                Iterator iterator = billEntryEntity.iterator();
                ArrayList<ListSelectedRow> rows = new ArrayList<ListSelectedRow>(16);
                while (iterator.hasNext()) {
                    Object keeperId;
                    boolean isSup;
                    DynamicObject entry = (DynamicObject)iterator.next();
                    DynamicObject keeper = entry.getDynamicObject("keeper");
                    if (keeper == null || !Boolean.TRUE.equals(isSup = (keeper = BusinessDataServiceHelper.loadSingleFromCache((Object)(keeperId = keeper.getPkValue()), (String)"bd_supplier", (String)"issuppcolla")).getBoolean("issuppcolla"))) continue;
                    ListSelectedRow row = new ListSelectedRow();
                    row.setPrimaryKeyValue(dataEntity.getPkValue());
                    Object entryId = entry.getPkValue();
                    row.setEntryPrimaryKeyValue(entryId);
                    row.setEntryEntityKey(BILL_ENTRY);
                    rows.add(row);
                }
                if (rows.isEmpty()) continue;
                List<DynamicObject> targetEntityList = this.convertBOTP(rows);
                StringBuilder errorInfo = this.generateTargetBill(targetEntityList = this.afterConvert(targetEntityList));
                if (errorInfo.length() <= 0) continue;
                throw new KDBizException(errorInfo.toString());
            }
        }
        catch (KDBizException exception) {
            throw exception;
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
    }

    private StringBuilder generateTargetBill(List<DynamicObject> targetEntityList) {
        OperationResult result = null;
        StringBuilder errorInfo = new StringBuilder();
        result = OperationServiceHelper.executeOperate((String)"submit", (String)MODULE_DELIVERY, (DynamicObject[])targetEntityList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        this.buildErrorInfo(result, errorInfo);
        result = OperationServiceHelper.executeOperate((String)"audit", (String)MODULE_DELIVERY, (Object[])result.getSuccessPkIds().toArray(), (OperateOption)OperateOption.create());
        this.buildErrorInfo(result, errorInfo);
        return errorInfo;
    }

    private void buildErrorInfo(OperationResult result, StringBuilder errorInfo) {
        if (!result.isSuccess()) {
            result.getAllErrorOrValidateInfo().forEach(p -> errorInfo.append(p.getMessage()).append('\n'));
        }
    }

    private List<DynamicObject> convertBOTP(List<ListSelectedRow> rows) {
        PushArgs args = new PushArgs();
        args.setSelectedRows(rows);
        args.setSourceEntityNumber("im_transdirbill");
        args.setTargetEntityNumber(MODULE_DELIVERY);
        ConvertOperationResult convertResult = ConvertServiceHelper.push((PushArgs)args);
        if (!convertResult.isSuccess()) {
            StringBuilder errorMsgBuilder = new StringBuilder();
            if (!StringUtils.isEmpty((CharSequence)convertResult.getMessage())) {
                errorMsgBuilder.append(convertResult.getMessage()).append("\n");
            }
            if (convertResult.getBillReports() != null && !convertResult.getBillReports().isEmpty()) {
                for (SourceBillReport billReport : convertResult.getBillReports()) {
                    errorMsgBuilder.append(billReport.getRowInfo());
                    errorMsgBuilder.append(billReport.getFailMessage()).append("\n");
                }
            }
            throw new KDBizException(errorMsgBuilder.toString());
        }
        MainEntityType purReceiveType = MetadataServiceHelper.getDataEntityType((String)MODULE_DELIVERY);
        return convertResult.loadTargetDataObjects(BusinessDataReader::loadRefence, purReceiveType);
    }

    private List<DynamicObject> afterConvert(List<DynamicObject> targetEntityList) {
        for (DynamicObject data : targetEntityList) {
            DynamicObject bizPartner = data.getDynamicObject("bizpartner");
            if (bizPartner == null) continue;
            Object bizPartnerId = bizPartner.getPkValue();
            QFilter[] qFilters = new QFilter[]{new QFilter("isadmin", "=", (Object)"1").and("bizpartner", "=", bizPartnerId).and("enable", "=", (Object)"1")};
            List dataSet = QueryServiceHelper.queryPrimaryKeys((String)"pur_supuser", (QFilter[])qFilters, null, (int)1);
            if (dataSet.isEmpty()) continue;
            Long adminId = (Long)dataSet.get(0);
            QFilter filter = new QFilter("scpuser", "=", (Object)adminId);
            DynamicObject admin = BusinessDataServiceHelper.loadSingleFromCache((String)"scp_bizperson", (String)"id,name,number,scpuser", (QFilter[])filter.toArray());
            data.set("contacter", (Object)admin);
        }
        return targetEntityList;
    }
}

