/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.transbill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.scmc.im.validator.general.TransitLocationMustInputValidator;

public class TransOutSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("transtype");
        list.add("org");
        list.add("inorg");
        list.add("warehouse");
        list.add("inwarehouse");
        list.add("inlocation");
        list.add("remaintransinbaseqty");
        list.add("remaintransinqty");
        list.add("baseqty");
        list.add("qty");
        list.add("returnqty");
        list.add("returnbaseqty");
        list.add("remainreturnqty");
        list.add("remainreturnbaseqty");
        list.add("transitowner");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        BigDecimal baseQty = null;
        BigDecimal qty = null;
        for (DynamicObject bill : entities) {
            DynamicObjectCollection dt = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject row : dt) {
                qty = row.getBigDecimal("qty");
                baseQty = row.getBigDecimal("baseqty");
                row.set("remaintransinbaseqty", (Object)baseQty);
                row.set("remaintransinqty", (Object)qty);
                row.set("returnqty", (Object)BigDecimal.ZERO);
                row.set("returnbaseqty", (Object)BigDecimal.ZERO);
                row.set("remainreturnqty", (Object)qty);
                row.set("remainreturnbaseqty", (Object)baseQty);
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new TransitLocationMustInputValidator("inwarehouse", "inlocation"));
    }
}

