/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.adjustbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.scmc.im.business.helper.BotpPushHepler;
import org.apache.commons.lang3.BooleanUtils;

public class AdjustBillUnAuditValidator
extends AbstractValidator {
    public void validate() {
        if (this.dataEntities == null) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            Map<Long, Boolean> pushedMap;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            IDataEntityType dataEntityType = dataEntity.getDataEntityType();
            String name = dataEntityType.getName();
            dataEntity = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)name);
            Long id1 = dataEntity.getLong("id");
            ArrayList<Long> idList = new ArrayList<Long>();
            idList.add(id1);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("botp_track_only_dirt_link", "true");
            List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)name, (Long[])idList.toArray(new Long[0]), (OperateOption)operateOption);
            if (CollectionUtils.isEmpty((Collection)bfRowLinkUpNodes)) continue;
            Long srcBillId = 0L;
            block1: for (BFRowLinkUpNode row : bfRowLinkUpNodes) {
                Map sNodes = row.getSNodes();
                for (Map.Entry sNode : sNodes.entrySet()) {
                    BFRowId key = (BFRowId)sNode.getKey();
                    Long tableId = key.getTableId();
                    TableDefine tableDefine = EntityMetadataCache.loadTableDefine((Long)tableId);
                    if (!"im_invinspectbill".equals(tableDefine.getEntityNumber())) continue;
                    srcBillId = key.getBillId();
                    break block1;
                }
            }
            if (srcBillId.equals(0L)) continue;
            ArrayList<Long> srcIds = new ArrayList<Long>();
            srcIds.add(srcBillId);
            DynamicObject srcEntity = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)"im_invinspectbill");
            DynamicObjectCollection dynamicObjectCollection = srcEntity.getDynamicObjectCollection("billentry");
            ArrayList<Long> srcEntryIds = new ArrayList<Long>();
            HashMap<Long, BigDecimal> matMap = new HashMap<Long, BigDecimal>(8);
            for (DynamicObject objEntity : dynamicObjectCollection) {
                srcEntryIds.add(objEntity.getLong("id"));
                DynamicObject material = objEntity.getDynamicObject("material");
                BigDecimal baseQty = objEntity.getBigDecimal("baseqty");
                Long masterId = material.getLong("id");
                if (matMap.containsKey(masterId)) {
                    matMap.put(masterId, baseQty.add((BigDecimal)matMap.get(masterId)));
                    continue;
                }
                matMap.put(masterId, baseQty);
            }
            Map trackUpBillInfo = BotpPushHepler.getTrackDownBillMap((String)"im_invinspectbill", (String)"billentry", srcIds, srcEntryIds, (String)"im_invinspectbill", (String)"billentry");
            if (!trackUpBillInfo.isEmpty()) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u4e8c\u6b21\u8bf7\u68c0\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"AdjustBillUnAuditValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
            if (!BooleanUtils.isTrue((Boolean)(pushedMap = this.invokeUnionPushService(srcBillId)).get(srcBillId))) continue;
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u51fa\u5e93\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"AdjustBillUnAuditValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }

    private Map<Long, Boolean> invokeUnionPushService(Long srcBillId) {
        Map pushedMap = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msisv", (String)"MsisvUnionPushRecordService", (String)"existUnionPushRecordByRelationObj", (Object[])new Object[]{"im_invinspectbill", Collections.singleton(srcBillId)});
        return pushedMap;
    }
}

