/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.adjustbill;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class AdjustLocationMustInputValidator
extends AbstractValidator {
    private String warehouse;
    private String loaction;

    public AdjustLocationMustInputValidator(String warehouse, String loaction) {
        this.warehouse = warehouse;
        this.loaction = loaction;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkLoaction(dataEntity);
        }
    }

    private void checkLoaction(ExtendedDataEntity entity) {
        DynamicObject invBill = entity.getDataEntity();
        DynamicObjectCollection col = invBill.getDynamicObjectCollection("billentry");
        int seq = 0;
        Object[] errorMsgParams = null;
        InvBillErrorCode errorCodeObj = null;
        for (DynamicObject entry : col) {
            String tip;
            ++seq;
            ArrayList<Integer> set = new ArrayList<Integer>(col.size());
            HashSet<Integer> errLocSet = new HashSet<Integer>(col.size());
            DynamicObjectCollection subCol = entry.getDynamicObjectCollection("afterentity");
            for (DynamicObject dym : subCol) {
                DynamicObject Wh = dym.getDynamicObject(this.warehouse);
                if (CommonUtils.isNull((Object)Wh)) continue;
                boolean isOpenLocation = Wh.getBoolean("isopenlocation");
                DynamicObject loc = dym.getDynamicObject(this.loaction);
                if (!isOpenLocation) {
                    if (loc == null) continue;
                    errLocSet.add(seq);
                    continue;
                }
                if (!CommonUtils.isNull((Object)loc)) continue;
                set.add(dym.getInt("seq"));
            }
            errorCodeObj = new InvBillErrorCode();
            String entryName = col.getDynamicObjectType().getDisplayName().getLocaleValue();
            String afterEntryName = subCol.getDynamicObjectType().getDisplayName().getLocaleValue();
            if (set.size() > 0) {
                errorMsgParams = new Object[]{entryName, seq, afterEntryName, set};
                tip = CommonUtils.getCodeErrorMessage((ErrorCode)errorCodeObj.getCONFIRM_AFTER_ENTRY_LOACTION(), (Object[])errorMsgParams);
                this.addErrorMessage(entity, tip);
            }
            if (errLocSet.size() <= 0) continue;
            tip = CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getCONFIRM_AFTER_ENTRY_NO_LOACTION(), (Object[])new Object[]{entryName, seq, afterEntryName, errLocSet});
            this.addErrorMessage(entity, tip);
        }
    }
}

