/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.assembbill;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.scmc.im.utils.IMStringUtils;

public class AssembAuxptyMustInputValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.checkAuxpty(entity);
        }
    }

    private void checkAuxpty(ExtendedDataEntity entity) {
        DynamicObject billEntity = entity.getDataEntity();
        DynamicObjectCollection col = billEntity.getDynamicObjectCollection("billentry");
        if (col == null || col.size() == 0) {
            return;
        }
        ArrayList<Long> allMasterid = new ArrayList<Long>();
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject row = (DynamicObject)col.get(i);
            DynamicObjectCollection afterEntrys = row.getDynamicObjectCollection("afterentity");
            for (DynamicObject afterEntry : afterEntrys) {
                DynamicObject billMat = afterEntry.getDynamicObject("material1");
                if (billMat == null) continue;
                if ("bd_material".equals(billMat.getDataEntityType().getName())) {
                    if (!billMat.getBoolean("isuseauxpty")) continue;
                    allMasterid.add((Long)billMat.getPkValue());
                    continue;
                }
                if (!billMat.getBoolean("masterid.isuseauxpty")) continue;
                DynamicObject mat = billMat.getDynamicObject("masterid");
                allMasterid.add((Long)mat.getPkValue());
            }
        }
        QFilter filter = new QFilter("id", "in", allMasterid);
        Map res = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (QFilter[])new QFilter[]{filter});
        LinkedHashSet<Integer> sets = null;
        LinkedHashSet<Integer> fulsets = null;
        for (int i = 0; i < col.size(); ++i) {
            sets = new LinkedHashSet<Integer>();
            fulsets = new LinkedHashSet<Integer>();
            DynamicObject row = (DynamicObject)col.get(i);
            DynamicObjectCollection afterEntrys = row.getDynamicObjectCollection("afterentity");
            for (DynamicObject afterEntry : afterEntrys) {
                DynamicObject auxpty;
                DynamicObject mat;
                DynamicObject billMat = afterEntry.getDynamicObject("material1");
                if (billMat == null) continue;
                if ("bd_material".equals(billMat.getDataEntityType().getName())) {
                    mat = billMat;
                    if (!billMat.getBoolean("isuseauxpty")) {
                        continue;
                    }
                } else {
                    mat = billMat.getDynamicObject("masterid");
                    if (!mat.getBoolean("isuseauxpty")) continue;
                }
                if (null != (auxpty = afterEntry.getDynamicObject("auxpty1"))) {
                    DynamicObjectCollection auxCol;
                    if (!res.containsKey(mat.getPkValue()) || (auxCol = (mat = (DynamicObject)res.get(mat.getPkValue())).getDynamicObjectCollection("auxptyentry")) == null || auxCol.size() == 0) continue;
                    String auxValue = auxpty.get("value").toString();
                    try {
                        Map map = (Map)JSONUtils.cast((String)auxValue, HashMap.class);
                        int billAuxSize = map.size();
                        if (auxCol.size() == billAuxSize) continue;
                        fulsets.add(afterEntry.getInt("seq"));
                        continue;
                    }
                    catch (IOException e) {
                        throw new KDBizException(IMStringUtils.append((String)ResManager.loadKDString((String)"\u89e3\u6790\u201c\u8f85\u52a9\u5c5e\u6027\u503c\u201d\u5f02\u5e38\u3002", (String)"AssembAuxptyMustInputValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{e.getMessage()}));
                    }
                }
                sets.add(afterEntry.getInt("seq"));
            }
            if (sets.size() != 0) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ec4\u88c5\u540e\u5206\u5f55\u7b2c{0}\u884c\u4e2d\uff0c\u7ec4\u88c5\u524d\u5206\u5f55\u7b2c{1}\u884c\u4e2d\u201c\u8f85\u52a9\u5c5e\u6027\u201d\u3002", (String)"AssembAuxptyMustInputValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1, sets}));
            }
            if (fulsets.size() == 0) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ec4\u88c5\u540e\u5206\u5f55\u7b2c{0}\u884c\u4e2d\uff0c\u7ec4\u88c5\u524d\u5206\u5f55\u7b2c{1}\u884c\u4e2d\u201c\u8f85\u52a9\u5c5e\u6027\u201d\u3002", (String)"AssembAuxptyMustInputValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1, sets}));
        }
    }
}

