/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.disassemblebill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class DisassembleBeforeMIValidator
extends AbstractValidator {
    public void validate() {
        this.materialMustInputValidate();
        this.currencyMustInputValidate();
    }

    private void currencyMustInputValidate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Object currency;
            if (dataEntity == null || (currency = dataEntity.getDataEntity().get("currency")) != null) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5e93\u5b58\u7ec4\u7ec7\u6838\u7b97\u7684\u4e3b\u4f53\u672c\u4f4d\u5e01\u3002", (String)"DisassembleBeforeMIValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }

    private void materialMustInputValidate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            StringBuilder strs = new StringBuilder();
            DynamicObjectCollection billentry = dataEntity.getDataEntity().getDynamicObjectCollection("billentry");
            if (billentry == null || billentry.size() == 0) continue;
            for (DynamicObject entry : billentry) {
                DynamicObjectCollection beforeMaterial = entry.getDynamicObjectCollection("afterentity");
                if (beforeMaterial != null && beforeMaterial.size() != 0) continue;
                String erroMessage = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u62c6\u5378\u524d\u7269\u6599\u201d\u5206\u5f55\u7b2c%s\u884c\u201c\u62c6\u5378\u540e\u7269\u6599\u201d\u3002", (String)"DisassembleBeforeMIValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                strs.append(String.format(erroMessage, entry.get("seq")));
                strs.append('\n');
            }
            String erroMessage = strs.toString();
            if (erroMessage.trim().equals("")) continue;
            this.addErrorMessage(dataEntity, erroMessage);
        }
    }
}

