/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.general;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class LocationMustInputValidator
extends AbstractValidator {
    private String warehouse;
    private String location;

    public LocationMustInputValidator(String warehouse, String location) {
        this.warehouse = warehouse;
        this.location = location;
    }

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"LocationMustInputValidator", (String)"validate");){
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                this.checkLocation(dataEntity);
            }
        }
    }

    private void checkLocation(ExtendedDataEntity entity) {
        String tip;
        String locationName;
        DynamicObject invBill = entity.getDataEntity();
        DynamicObjectCollection col = invBill.getDynamicObjectCollection("billentry");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.entityKey);
        IDataEntityProperty property = dataEntityType.findProperty(this.warehouse);
        IDataEntityProperty fieldProperty = dataEntityType.findProperty(this.location);
        ArrayList<Integer> set = new ArrayList<Integer>(col.size());
        HashSet<Integer> errLocSet = new HashSet<Integer>(col.size());
        int seq = 0;
        for (DynamicObject dym : col) {
            ++seq;
            DynamicObject Wh = dym.getDynamicObject(this.warehouse);
            if (CommonUtils.isNull((Object)Wh)) continue;
            boolean isOpenLocation = Wh.getBoolean("isopenlocation");
            DynamicObject loc = dym.getDynamicObject(this.location);
            if (!isOpenLocation) {
                if (loc == null) continue;
                errLocSet.add(seq);
                continue;
            }
            if (!CommonUtils.isNull((Object)loc)) continue;
            set.add(seq);
        }
        String warehouseName = property == null ? null : property.getDisplayName().getLocaleValue();
        String string = locationName = fieldProperty == null ? null : fieldProperty.getDisplayName().getLocaleValue();
        if (set.size() > 0) {
            tip = CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getCONFIRM_ENTRY_LOACTION(), (Object[])new Object[]{set, warehouseName, locationName});
            this.addErrorMessage(entity, tip);
        }
        if (errLocSet.size() > 0) {
            tip = CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getCONFIRM_ENTRY_NO_LOACTION(), (Object[])new Object[]{errLocSet, warehouseName, locationName});
            this.addErrorMessage(entity, tip);
        }
    }
}

