/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.general;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.linetype.BillTypeMaterialHelper;
import kd.scmc.im.business.helper.linetype.LineTypeParam;
import kd.scmc.im.utils.IMStringUtils;

public class ServiceAttributeValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("linetype");
        return set;
    }

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"ServiceAttributeValidator", (String)"validate");){
            HashSet<Long> bizTypes = new HashSet<Long>(16);
            for (ExtendedDataEntity data : this.dataEntities) {
                DynamicObject bill = data.getDataEntity();
                DynamicObject bizType = bill.getDynamicObject("biztype");
                if (bizType == null) continue;
                bizTypes.add(bizType.getLong("id"));
            }
            Map lineTypeByBillType = BillTypeMaterialHelper.getLineTypeByBillType(new ArrayList(bizTypes));
            for (ExtendedDataEntity data : this.dataEntities) {
                DynamicObject bill = data.getDataEntity();
                DynamicObject bizType = bill.getDynamicObject("biztype");
                if (bizType == null) continue;
                Set lineTypes = new HashSet(16);
                if (lineTypeByBillType.size() != 0) {
                    LineTypeParam lineTypeParam = (LineTypeParam)lineTypeByBillType.get(bizType.getLong("id"));
                    if (lineTypeParam == null) continue;
                    lineTypes = lineTypeParam.getLineTypeIds();
                }
                DynamicObjectCollection billentrys = bill.getDynamicObjectCollection("billentry");
                for (int i = 0; i < billentrys.size(); ++i) {
                    DynamicObject billentry = (DynamicObject)billentrys.get(i);
                    DynamicObject lineType = billentry.getDynamicObject("linetype");
                    if (lineType == null || lineTypes.contains(lineType.getLong("id"))) continue;
                    this.addErrorMessage(data, IMStringUtils.append((String)ResManager.loadKDString((String)"\u7b2c", (String)"ServiceAttributeValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{i + 1, ResManager.loadKDString((String)"\u884c\u7684\u884c\u7c7b\u578b\u2018", (String)"ServiceAttributeValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[0]), lineType.get("number"), lineType.get("name"), ResManager.loadKDString((String)"\u2019\u4e0d\u662f\u4e1a\u52a1\u7c7b\u578b\u2018", (String)"ServiceAttributeValidator_7", (String)"scmc-im-opplugin", (Object[])new Object[0]), bizType.get("number"), bizType.get("name"), ResManager.loadKDString((String)"\u2019\u7684\u5173\u8054\u884c\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"ServiceAttributeValidator_8", (String)"scmc-im-opplugin", (Object[])new Object[0])}));
                }
            }
        }
    }
}

