/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.general;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.CloseDateHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.DateUtils;

public class StartDateValidator
extends AbstractValidator {
    private String orgField = "org";
    private String warehouseField = "warehouse";
    private String outOrgField = "outorg";
    private String outWarehouseField = "outwarehouse";
    private boolean isOrgInEntry = false;

    private String getNotinitMsgFormat() {
        return ResManager.loadKDString((String)"%1s\u65e5\u671f\u201c%2s\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4ed3\u5e93\u201c%3s\u201d\u7684\u542f\u7528\u65e5\u671f\u201c%4s\u201d\u3002", (String)"StartDateValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[0]);
    }

    private String getInitMsgFormat() {
        return ResManager.loadKDString((String)"%1s\u65e5\u671f\u201c%2s\u201d\u5fc5\u987b\u5c0f\u4e8e\u4ed3\u5e93\u201c%3s\u201d\u7684\u542f\u7528\u65e5\u671f\u201c%4s\u201d\u3002", (String)"StartDateValidator_7", (String)"scmc-im-opplugin", (Object[])new Object[0]);
    }

    public StartDateValidator() {
    }

    public StartDateValidator(String orgField, String warehouseField, String outOrgField, String outWarehouseField, boolean isOrgInEntry) {
        this.orgField = orgField;
        this.warehouseField = warehouseField;
        this.outOrgField = CommonUtils.isNull((Object)outOrgField) ? this.outOrgField : outOrgField;
        this.outWarehouseField = CommonUtils.isNull((Object)outWarehouseField) ? this.outOrgField : outWarehouseField;
        this.isOrgInEntry = isOrgInEntry;
    }

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"StartDateValidator", (String)"validate");){
            if (CommonUtils.isNull((Object)this.dataEntities)) {
                return;
            }
            HashMap<String, Set<Integer>> warehouseRowMap = new HashMap<String, Set<Integer>>();
            HashMap<Long, Set<Long>> orgWarehouseMap = this.getAllOrgWarehouseMap(warehouseRowMap);
            if (orgWarehouseMap.isEmpty()) {
                return;
            }
            List startDateDyc = WarehouseHelper.getOrgWarehouseSetupTimeDyc(orgWarehouseMap);
            this.addUnInitMessage(warehouseRowMap, startDateDyc);
        }
    }

    private HashMap<Long, Set<Long>> getAllOrgWarehouseMap(HashMap<String, Set<Integer>> warehouseRowMap) {
        HashMap<Long, Set<Long>> orgWarehouseMap = new HashMap<Long, Set<Long>>(this.dataEntities.length);
        boolean isCheckOutOrgWarehouse = this.isCheckOutOrgWarehouse();
        boolean isTransBill = this.getEntityKey().equals("im_assembbill") || this.getEntityKey().equals("im_disassemblebill") || this.getEntityKey().equals("im_adjustbill");
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject item : entry) {
                DynamicObject orgSource = this.isOrgInEntry ? item : bill;
                this.getAllOrgWarehouse(entity, orgWarehouseMap, warehouseRowMap, item, orgSource.getDynamicObject(this.orgField), this.warehouseField);
                if (isCheckOutOrgWarehouse) {
                    this.getAllOrgWarehouse(entity, orgWarehouseMap, warehouseRowMap, item, orgSource.getDynamicObject(this.outOrgField), this.outWarehouseField);
                }
                if (!isTransBill) continue;
                DynamicObjectCollection afterEntryDycs = item.getDynamicObjectCollection("afterentity");
                for (DynamicObject afterDyc : afterEntryDycs) {
                    this.getAllOrgWarehouse(entity, orgWarehouseMap, warehouseRowMap, afterDyc, orgSource.getDynamicObject(this.orgField), "warehouse1");
                }
            }
        }
        return orgWarehouseMap;
    }

    private boolean isCheckOutOrgWarehouse() {
        boolean hasOutOrg = false;
        boolean hasOutWareHouse = false;
        DynamicObjectCollection entryDyc = this.dataEntities[0].getDataEntity().getDynamicObjectCollection("billentry");
        hasOutOrg = this.isOrgInEntry && !CommonUtils.isNull((Object)entryDyc) ? entryDyc.getDynamicObjectType().getProperties().containsKey((Object)this.outOrgField) : this.dataEntities[0].getDataEntity().getDynamicObjectType().getProperties().containsKey((Object)this.outOrgField);
        if (hasOutOrg && !CommonUtils.isNull((Object)entryDyc)) {
            hasOutWareHouse = entryDyc.getDynamicObjectType().getProperties().containsKey((Object)this.outWarehouseField);
        }
        return hasOutOrg && hasOutWareHouse;
    }

    private void getAllOrgWarehouse(ExtendedDataEntity entity, HashMap<Long, Set<Long>> orgWarehouseMap, HashMap<String, Set<Integer>> warehouseRowMap, DynamicObject entry, DynamicObject org, String warehouse) {
        DynamicObject warehouseDyc = entry.getDynamicObject(warehouse);
        if (CommonUtils.isNull((Object)org) || CommonUtils.isNull((Object)warehouseDyc)) {
            return;
        }
        orgWarehouseMap.computeIfAbsent((Long)org.getPkValue(), k -> new HashSet());
        orgWarehouseMap.get(org.getPkValue()).add((Long)warehouseDyc.getPkValue());
        StringBuilder orgWarehouseBuilder = new StringBuilder();
        orgWarehouseBuilder.append(org.getPkValue());
        orgWarehouseBuilder.append(',');
        orgWarehouseBuilder.append(warehouseDyc.getPkValue());
        String orgWarehouseKey = orgWarehouseBuilder.toString();
        warehouseRowMap.computeIfAbsent(orgWarehouseKey, k -> new HashSet());
        warehouseRowMap.get(orgWarehouseKey).add(entity.getDataEntityIndex());
    }

    private void addUnInitMessage(HashMap<String, Set<Integer>> warehouseRowMap, List<DynamicObject> startDateDyc) {
        boolean isInitBill = this.getEntityKey().equals("im_initbill");
        boolean includeInitBizBill = MetaDataHelper.isExistField((IDataEntityType)EntityMetadataCache.getDataEntityType((String)this.getEntityKey()), (String)"isinitbill");
        boolean bookDateBill = MetaDataHelper.isExistField((IDataEntityType)EntityMetadataCache.getDataEntityType((String)this.getEntityKey()), (String)"bookdate");
        String dateName = ResManager.loadKDString((String)"\u4e1a\u52a1", (String)"StartDateValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        for (DynamicObject item : startDateDyc) {
            StringBuilder orgWarehouseSbf = new StringBuilder();
            orgWarehouseSbf.append(item.getDynamicObject("org").getPkValue());
            orgWarehouseSbf.append(',');
            orgWarehouseSbf.append(item.getDynamicObject("warehouse").getPkValue());
            String orgWarehouseKey = orgWarehouseSbf.toString();
            for (Integer index : warehouseRowMap.get(orgWarehouseKey)) {
                boolean initBillCheck;
                DynamicObject dataEntity = this.dataEntities[index].getDataEntity();
                Date date = dataEntity.getDate("biztime");
                if (bookDateBill) {
                    if (!"unaudit".equals(this.getOperateKey()) && !"unsubmit".equals(this.getOperateKey())) {
                        CloseDateHelper.initBookDate((String)this.entityKey, (DynamicObject)dataEntity);
                    }
                    date = dataEntity.getDate("bookdate");
                    dateName = ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u540e\u8bb0\u8d26", (String)"StartDateValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                }
                Date startDate = item.getDate("startdate");
                if (date == null || startDate == null) continue;
                isInitBill = isInitBill ? isInitBill : includeInitBizBill && dataEntity.getBoolean("isinitbill");
                boolean notInitBillCheck = !isInitBill && date.compareTo(startDate) < 0;
                boolean bl = initBillCheck = isInitBill && date.compareTo(startDate) >= 0;
                if (!notInitBillCheck && !initBillCheck) continue;
                String orgName = item.getDynamicObject("org").getLocaleString("name").getLocaleValue();
                String warehouseName = item.getDynamicObject("warehouse").getString("name");
                this.addMessage(this.dataEntities[index], String.format(notInitBillCheck ? this.getNotinitMsgFormat() : this.getInitMsgFormat(), dateName, DateUtils.getDateString((Date)date), warehouseName, DateUtils.getDateString((Date)startDate)), ErrorLevel.Error);
            }
        }
    }
}

