/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.general;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class TransitLocationMustInputValidator
extends AbstractValidator {
    private String warehouseField;
    private String locationField;

    public TransitLocationMustInputValidator(String warehouse, String location) {
        this.warehouseField = warehouse;
        this.locationField = location;
    }

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"TransitLocationMustInputValidator", (String)"validate");){
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                this.checkLocation(dataEntity);
            }
        }
    }

    private void checkLocation(ExtendedDataEntity entity) {
        DynamicObject invBill = entity.getDataEntity();
        DynamicObjectCollection col = invBill.getDynamicObjectCollection("billentry");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.entityKey);
        IDataEntityProperty property = dataEntityType.findProperty(this.warehouseField);
        IDataEntityProperty fieldProperty = dataEntityType.findProperty(this.locationField);
        ArrayList<Integer> set = new ArrayList<Integer>();
        int seq = 0;
        for (DynamicObject dym : col) {
            DynamicObject loc;
            boolean isOpenLocation;
            ++seq;
            DynamicObject wh = dym.getDynamicObject(this.warehouseField);
            if (wh == null || !(isOpenLocation = wh.getBoolean("isopenlocation")) || !CommonUtils.isNull((Object)(loc = dym.getDynamicObject(this.locationField)))) continue;
            set.add(seq);
        }
        if (set.size() > 0) {
            String warehouseName = property == null ? null : property.getDisplayName().getLocaleValue();
            String locationName = fieldProperty == null ? null : fieldProperty.getDisplayName().getLocaleValue();
            String tip = CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getCONFIRM_ENTRY_TRANS_LOACTION(), (Object[])new Object[]{set, warehouseName, locationName});
            this.addErrorMessage(entity, tip);
        }
    }
}

