/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.general;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.utils.CommonUtils;

public class WarehouseUnFinishInitValidator
extends AbstractValidator {
    private String orgField = "org";
    private String warehouseField = "warehouse";
    private String outOrgField = "outorg";
    private String outWarehouseField = "outwarehouse";
    private String inWarehouseField = "inwarehouse";
    private boolean isOrgInEntry = false;

    private String getMessageFormat() {
        return ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1s\u201d\u7684\u4ed3\u5e93\u201c%2s\u201d\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5e93\u5b58\u4e1a\u52a1\u3002", (String)"WarehouseUnFinishInitValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
    }

    public WarehouseUnFinishInitValidator() {
    }

    public Set<String> preparePropertys() {
        Set fields = super.preparePropertys();
        fields.add("org");
        fields.add("warehouse");
        fields.add("warehouse");
        fields.add("outorg");
        fields.add("outwarehouse");
        fields.add("transit");
        if ("im_invinspectbill".equals(this.entityKey)) {
            fields.add("qualifiedwarehouse");
            fields.add("unqualifiedwarehouse");
        }
        return fields;
    }

    public WarehouseUnFinishInitValidator(String orgField, String warehouseField, String outOrgField, String outWarehouseField, boolean isOrgInEntry) {
        this.orgField = orgField;
        this.warehouseField = warehouseField;
        this.outOrgField = CommonUtils.isNull((Object)outOrgField) ? this.outOrgField : outOrgField;
        this.outWarehouseField = CommonUtils.isNull((Object)outWarehouseField) ? this.outOrgField : outWarehouseField;
        this.isOrgInEntry = isOrgInEntry;
    }

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"WarehouseUnFinishInitValidator", (String)"validate");){
            if (CommonUtils.isNull((Object)this.dataEntities)) {
                return;
            }
            HashMap<String, Set<Integer>> warehouseRowMap = new HashMap<String, Set<Integer>>();
            HashMap<Long, Set<Long>> orgWarehouseMap = this.getAllOrgWarehouseMap(warehouseRowMap);
            if (orgWarehouseMap.isEmpty()) {
                return;
            }
            Map resultMap = WarehouseHelper.getAllUnInitWarehouse(orgWarehouseMap);
            this.addUnInitMessage(warehouseRowMap, new ArrayList<DynamicObject>(resultMap.values()));
        }
    }

    private HashMap<Long, Set<Long>> getAllOrgWarehouseMap(HashMap<String, Set<Integer>> warehouseRowMap) {
        HashMap<Long, Set<Long>> orgWarehouseMap = new HashMap<Long, Set<Long>>(this.dataEntities.length);
        boolean isCheckOutOrgWarehouse = this.isCheckOutOrgWarehouse();
        boolean isTransBill = this.getEntityKey().equals("im_assembbill") || this.getEntityKey().equals("im_disassemblebill") || this.getEntityKey().equals("im_adjustbill");
        boolean isInitTypeBill = this.getEntityKey().equals("im_purinbill") || this.getEntityKey().equals("im_saloutbill");
        boolean isTransIn = "im_transinbill".equals(this.getEntityKey());
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject bill = entity.getDataEntity();
            if (isInitTypeBill && bill.getBoolean("isinitbill")) continue;
            String transOrgField = this.getTransOrgField(bill);
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject item : entry) {
                DynamicObject orgSource = this.isOrgInEntry ? item : bill;
                this.getAllOrgWarehouse(entity, orgWarehouseMap, warehouseRowMap, item, orgSource.getDynamicObject(this.orgField), this.warehouseField);
                if (isCheckOutOrgWarehouse && !isTransIn) {
                    this.getAllOrgWarehouse(entity, orgWarehouseMap, warehouseRowMap, item, orgSource.getDynamicObject(this.outOrgField), this.outWarehouseField);
                }
                if (isTransBill) {
                    DynamicObjectCollection afterEntryDycs = item.getDynamicObjectCollection("afterentity");
                    for (DynamicObject afterDyc : afterEntryDycs) {
                        this.getAllOrgWarehouse(entity, orgWarehouseMap, warehouseRowMap, afterDyc, orgSource.getDynamicObject(this.orgField), "warehouse1");
                    }
                }
                if ("im_purinbill".equals(this.entityKey)) {
                    this.getAllOrgWarehouse(entity, orgWarehouseMap, warehouseRowMap, item, orgSource.getDynamicObject(this.orgField), this.outWarehouseField);
                }
                if ("im_invinspectbill".equals(this.entityKey)) {
                    this.getAllOrgWarehouse(entity, orgWarehouseMap, warehouseRowMap, item, orgSource.getDynamicObject(this.orgField), this.outWarehouseField);
                    this.getAllOrgWarehouse(entity, orgWarehouseMap, warehouseRowMap, item, orgSource.getDynamicObject(this.orgField), "qualifiedwarehouse");
                    this.getAllOrgWarehouse(entity, orgWarehouseMap, warehouseRowMap, item, orgSource.getDynamicObject(this.orgField), "unqualifiedwarehouse");
                }
                if ("im_saloutbill".equals(this.entityKey)) {
                    this.getAllOrgWarehouse(entity, orgWarehouseMap, warehouseRowMap, item, orgSource.getDynamicObject(this.orgField), this.inWarehouseField);
                }
                if ("im_transoutbill".equals(this.entityKey)) {
                    this.getAllOrgWarehouse(entity, orgWarehouseMap, warehouseRowMap, item, orgSource.getDynamicObject(transOrgField), this.inWarehouseField);
                }
                if (!"im_transinbill".equals(this.entityKey)) continue;
                this.getAllOrgWarehouse(entity, orgWarehouseMap, warehouseRowMap, item, orgSource.getDynamicObject(transOrgField), this.outWarehouseField);
            }
        }
        return orgWarehouseMap;
    }

    private String getTransOrgField(DynamicObject bill) {
        String transOrgField = "";
        if ("im_transoutbill".equals(this.entityKey)) {
            String transSit = bill.getString("transit");
            transOrgField = "B".equals(transSit) ? "inorg" : "org";
        } else if ("im_transinbill".equals(this.entityKey)) {
            String transSit = bill.getString("transit");
            transOrgField = "A".equals(transSit) ? "outorg" : "org";
        }
        return transOrgField;
    }

    private boolean isCheckOutOrgWarehouse() {
        boolean hasOutOrg = false;
        boolean hasOutWareHouse = false;
        DynamicObjectCollection entryDyc = this.dataEntities[0].getDataEntity().getDynamicObjectCollection("billentry");
        hasOutOrg = this.isOrgInEntry && !CommonUtils.isNull((Object)entryDyc) ? entryDyc.getDynamicObjectType().getProperties().containsKey((Object)this.outOrgField) : this.dataEntities[0].getDataEntity().getDynamicObjectType().getProperties().containsKey((Object)this.outOrgField);
        if (hasOutOrg && !CommonUtils.isNull((Object)entryDyc)) {
            hasOutWareHouse = entryDyc.getDynamicObjectType().getProperties().containsKey((Object)this.outWarehouseField);
        }
        return hasOutOrg && hasOutWareHouse;
    }

    private void getAllOrgWarehouse(ExtendedDataEntity entity, HashMap<Long, Set<Long>> orgWarehouseMap, HashMap<String, Set<Integer>> warehouseRowMap, DynamicObject entry, DynamicObject org, String warehouse) {
        DynamicObject warehouseDyc = entry.getDynamicObject(warehouse);
        if (CommonUtils.isNull((Object)org) || CommonUtils.isNull((Object)warehouseDyc)) {
            return;
        }
        orgWarehouseMap.computeIfAbsent((Long)org.getPkValue(), k -> new HashSet());
        orgWarehouseMap.get(org.getPkValue()).add((Long)warehouseDyc.getPkValue());
        StringBuilder orgWarehouseSbf = new StringBuilder();
        orgWarehouseSbf.append(org.getPkValue());
        orgWarehouseSbf.append(',');
        orgWarehouseSbf.append(warehouseDyc.getPkValue());
        String orgWarehouseKey = orgWarehouseSbf.toString();
        warehouseRowMap.computeIfAbsent(orgWarehouseKey, k -> new HashSet());
        warehouseRowMap.get(orgWarehouseKey).add(entity.getDataEntityIndex());
    }

    private void addUnInitMessage(HashMap<String, Set<Integer>> warehouseRowMap, List<DynamicObject> startDateDyc) {
        for (DynamicObject item : startDateDyc) {
            String orgWarehouseKey = item.getDynamicObject("org").getPkValue() + "," + item.getDynamicObject("warehouse").getPkValue();
            for (Integer index : warehouseRowMap.get(orgWarehouseKey)) {
                String orgName = item.getDynamicObject("org").getLocaleString("name").getLocaleValue();
                String warehouseName = item.getDynamicObject("warehouse").getLocaleString("name").getLocaleValue();
                this.addMessage(this.dataEntities[index], String.format(this.getMessageFormat(), orgName, warehouseName), ErrorLevel.Error);
            }
        }
    }
}

