/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.importdata.ImptValidateHelper;
import kd.scmc.im.business.pojo.ValidateResult;
import kd.scmc.im.business.pojo.ValidateResultCollection;
import kd.scmc.im.enums.EnableStatusEnum;
import kd.scmc.im.validator.improt.billFiledMapper.BillFieldMapper;
import kd.scmc.im.validator.improt.billFiledMapper.BillFieldMapperFactory;

public abstract class AbstractBillImptValidator
extends AbstractValidator {
    private String billKey;
    protected Set<Long> queryExratetableIds = new HashSet<Long>();
    protected Set<Long> querySettleCurrencyIds = new HashSet<Long>();
    protected List<DynamicObject> startedInvOrgs = new ArrayList<DynamicObject>(50);

    protected void cacheStartedInvOrgs() {
        List startedInvOrgs;
        this.startedInvOrgs = startedInvOrgs = NewInvOrgHelper.getStartedInvOrgs();
    }

    protected void cacheSettleCurrency() {
        if (this.querySettleCurrencyIds.isEmpty()) {
            QFilter filter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
            filter.and("status", "=", (Object)"C");
            DynamicObjectCollection settleCurrencys = QueryServiceHelper.query((String)"bd_currency", (String)"id", (QFilter[])filter.toArray());
            for (DynamicObject settleCurrency : settleCurrencys) {
                Long settleCurrencyId = settleCurrency.getLong("id");
                this.querySettleCurrencyIds.add(settleCurrencyId);
            }
        }
    }

    protected void cacheExratetable() {
        if (this.queryExratetableIds.isEmpty()) {
            QFilter filter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
            filter.and("status", "=", (Object)"C");
            DynamicObjectCollection exratetables = QueryServiceHelper.query((String)"bd_exratetable", (String)"id", (QFilter[])filter.toArray());
            for (DynamicObject exratetable : exratetables) {
                Long exratetableId = exratetable.getLong("id");
                this.queryExratetableIds.add(exratetableId);
            }
        }
    }

    protected String getBillKey() {
        this.billKey = this.dataEntities[0].getDataEntity().getDataEntityType().getName();
        return this.billKey;
    }

    public void validate() {
        String opKey = this.getOperateKey();
        boolean isCheck = ImptValidateHelper.isCheck((String)opKey, (ExtendedDataEntity)this.dataEntities[0]);
        if (isCheck) {
            this.cacheData(this.dataEntities);
            this.imptValidate();
        }
    }

    protected void imptValidate() {
        ValidateResultCollection validateResults = new ValidateResultCollection();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            ValidateResult valResult;
            boolean isValid;
            DynamicObject billObj = dataEntity.getDataEntity();
            String billId = String.valueOf(billObj.getPkValue());
            this.checkF7(billObj, validateResults);
            this.checkText(billObj, validateResults);
            this.checkDate(billObj, validateResults);
            this.checkNumeric(billObj, validateResults);
            BillFieldMapper billFieldMapper = BillFieldMapperFactory.getBillFieldMapper(this.billKey);
            String entryKey = billFieldMapper.getBillEntryKey();
            DynamicObjectCollection entryObjs = billObj.getDynamicObjectCollection(entryKey);
            for (DynamicObject entryObj : entryObjs) {
                this.checkEntryF7(billObj, entryObj, validateResults);
                this.checkEntryText(billObj, entryObj, validateResults);
                this.checkEntryDate(billObj, entryObj, validateResults);
                this.checkEntryNumeric(billObj, entryObj, validateResults);
            }
            if (billFieldMapper.hasSubEntry()) {
                String subEntryKey = billFieldMapper.getSubEntryBillFiledMapper().getBillEntryKey();
                DynamicObjectCollection subEntryObjs = billObj.getDynamicObjectCollection(entryKey + '.' + subEntryKey);
                for (DynamicObject subEntryObj : subEntryObjs) {
                    this.checkSubEntryF7(billObj, subEntryObj, validateResults);
                    this.checkSubEntryText(billObj, subEntryObj, validateResults);
                    this.checkSubEntryDate(billObj, subEntryObj, validateResults);
                    this.checkSubEntryNumeric(billObj, subEntryObj, validateResults);
                }
            }
            if (isValid = (valResult = validateResults.getValidateResult(billId)).getIsVaild().booleanValue()) continue;
            List errMsgs = valResult.getValResults();
            StringBuilder errMsgBuf = new StringBuilder();
            for (String errMsg : errMsgs) {
                errMsgBuf.append(errMsg);
                errMsgBuf.append("\n");
            }
            this.addErrorMessage(dataEntity, errMsgBuf.toString());
        }
    }

    protected void checkSubEntryNumeric(DynamicObject billObj, DynamicObject subEntryObj, ValidateResultCollection validateResults) {
    }

    protected void checkSubEntryDate(DynamicObject billObj, DynamicObject subEntryObj, ValidateResultCollection validateResults) {
    }

    protected void checkSubEntryText(DynamicObject billObj, DynamicObject subEntryObj, ValidateResultCollection validateResults) {
    }

    protected void checkSubEntryF7(DynamicObject billObj, DynamicObject subEntryObj, ValidateResultCollection validateResults) {
    }

    protected void checkEntryF7(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
    }

    protected void checkEntryNumeric(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
    }

    protected void checkEntryText(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
    }

    protected void checkEntryDate(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
    }

    protected void cacheData(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject billObj = dataEntity.getDataEntity();
            this.cacheHeadData(billObj);
            BillFieldMapper billFieldMapper = BillFieldMapperFactory.getBillFieldMapper(this.getBillKey());
            String entryKey = billFieldMapper.getBillEntryKey();
            DynamicObjectCollection entryObjs = billObj.getDynamicObjectCollection(entryKey);
            for (DynamicObject entryObj : entryObjs) {
                this.cacheEntryData(billObj, entryObj);
            }
            if (!billFieldMapper.hasSubEntry()) continue;
            String subEntryKey = billFieldMapper.getSubEntryBillFiledMapper().getBillEntryKey();
            DynamicObjectCollection subEntryObjs = billObj.getDynamicObjectCollection(entryKey + '.' + subEntryKey);
            for (DynamicObject subEntryObj : subEntryObjs) {
                this.cacheSubEntryData(billObj, subEntryObj);
            }
        }
    }

    protected void cacheEntryData(DynamicObject billObj, DynamicObject entryObj) {
    }

    protected void cacheSubEntryData(DynamicObject billObj, DynamicObject subEntryObj) {
    }

    protected void cacheHeadData(DynamicObject billObj) {
    }

    protected void checkF7(DynamicObject billObj, ValidateResultCollection validateResults) {
    }

    protected void checkText(DynamicObject billObj, ValidateResultCollection validateResults) {
    }

    protected void checkDate(DynamicObject billObj, ValidateResultCollection validateResults) {
    }

    protected void checkNumeric(DynamicObject billObj, ValidateResultCollection validateResults) {
    }

    protected void checkExchangeRateAndCurrency(DynamicObject billObj, ValidateResultCollection validateResults) {
        this.checkExchangeRateAndCurrency(billObj, "org", "exratetable", "settlecurrency", "exratedate", "exchangerate", validateResults);
    }

    protected void checkExchangeRateAndCurrency(DynamicObject billObj, String orgKey, String exratetableKey, String settleCurrencyKey, String exrateDateKey, String exchangeRateKey, ValidateResultCollection validateResults) {
        DynamicObject supplier;
        DynamicObject settleCurrency;
        DynamicObject org = billObj.getDynamicObject(orgKey);
        if (org == null) {
            return;
        }
        Long orgId = org.getLong("id");
        String orgNum = org.getString("number");
        String billId = String.valueOf(billObj.getLong("id"));
        DynamicObject currencyDy = CurrencyHelper.getCurrency((Long)orgId);
        if (currencyDy == null) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u5b58\u5728\u672c\u4f4d\u5e01\u3002", (String)"AbstractBillImptValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), orgNum);
            validateResults.addValidateInfo(billId, errMsg);
            return;
        }
        billObj.set("currency", (Object)currencyDy);
        DynamicObject exratetable = billObj.getDynamicObject(exratetableKey);
        if (exratetable == null) {
            exratetable = CurrencyHelper.getExRateTable((Long)orgId);
            billObj.set("exratetable", (Object)exratetable);
        }
        if ((settleCurrency = billObj.getDynamicObject(settleCurrencyKey)) == null && "im_purinbill".equals(this.getBillKey()) && (supplier = billObj.getDynamicObject("supplier")) != null) {
            DynamicObject settlementcy = supplier.getDynamicObject("settlementcyid");
            if (settlementcy == null) {
                billObj.set("settlecurrency", (Object)currencyDy);
            } else {
                billObj.set("settlecurrency", (Object)settlementcy);
            }
        }
        settleCurrency = billObj.getDynamicObject(settleCurrencyKey);
        if (exratetable == null || settleCurrency == null) {
            return;
        }
        Long exratetableId = exratetable.getLong("id");
        String exratetableNum = exratetable.getString("number");
        if (!this.queryExratetableIds.contains(exratetableId)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u672a\u5ba1\u6838\u6216\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"AbstractBillImptValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), exratetableNum);
            validateResults.addValidateInfo(billId, errMsg);
            return;
        }
        Long settleCurrencyId = settleCurrency.getLong("id");
        String settleCurrencyNum = settleCurrency.getString("number");
        if (!this.querySettleCurrencyIds.contains(settleCurrencyId)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u7981\u7528\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u8f93\u5165\u3002", (String)"AbstractBillImptValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), settleCurrencyNum);
            validateResults.addValidateInfo(billId, errMsg);
            return;
        }
        Date exrateDate = billObj.getDate(exrateDateKey);
        if (exrateDate == null) {
            String errMsg = ResManager.loadKDString((String)"\u6c47\u7387\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u91cd\u65b0\u8f93\u5165\u3002", (String)"AbstractBillImptValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            validateResults.addValidateInfo(billId, errMsg);
            return;
        }
        Long currencyId = currencyDy.getLong("id");
        if (currencyId.equals(settleCurrencyId)) {
            billObj.set(exchangeRateKey, (Object)new BigDecimal("1"));
        } else {
            BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exratetableId, (Long)settleCurrencyId, (Long)currencyId, (Date)exrateDate);
            if (exchangeRate == null) {
                billObj.set(exchangeRateKey, (Object)new BigDecimal("0"));
            } else {
                billObj.set(exchangeRateKey, (Object)exchangeRate);
            }
        }
    }
}

