/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.consts.AdjustBillConst;

public class AdjustbillImportValidator
extends AbstractValidator {
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"AdjustbillImportValidator", (String)"validate");){
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject bizType;
                DynamicObject billObj = dataEntity.getDataEntity();
                String billCreType = billObj.getString("billcretype");
                if (!"1".equals(billCreType) && !"3".equals(billCreType) || (bizType = billObj.getDynamicObject("biztype")) == null) continue;
                Object bizTypeId = bizType.getPkValue();
                if (AdjustBillConst.BIZTYPE_MATERIALADJUST.equals(bizTypeId)) {
                    this.checkMaterialAdjust(dataEntity, billObj);
                    continue;
                }
                if (AdjustBillConst.BIZTYPE_LOTADJUST.equals(bizTypeId)) {
                    this.checkLotAdjust(dataEntity, billObj);
                    continue;
                }
                if (AdjustBillConst.BIZTYPE_SNADJUST.equals(bizTypeId)) {
                    this.checkSnAdjust(dataEntity, billObj);
                    continue;
                }
                if (AdjustBillConst.BIZTYPE_STATUSADJUST.equals(bizTypeId)) {
                    this.checkStatusAdjust(dataEntity, billObj);
                    continue;
                }
                if (AdjustBillConst.BIZTYPE_UNITADJUST.equals(bizTypeId)) {
                    this.checkUnitAdjust(dataEntity, billObj);
                    continue;
                }
                if (!AdjustBillConst.BIZTYPE_OTHERADJUST.equals(bizTypeId)) continue;
                this.checkOtherAdjust(dataEntity, billObj);
            }
        }
    }

    private void checkOtherAdjust(ExtendedDataEntity dataEntity, DynamicObject billObj) {
        DynamicObjectCollection billEntrys = billObj.getDynamicObjectCollection("billentry");
        for (DynamicObject billEntry : billEntrys) {
            DynamicObject material = billEntry.getDynamicObject("material");
            int seq = billEntry.getInt("seq");
            DynamicObjectCollection subEntrys = billEntry.getDynamicObjectCollection("afterentity");
            for (DynamicObject subEntry : subEntrys) {
                DynamicObject subMaterial = subEntry.getDynamicObject("material1");
                if (subMaterial == null || material == null || subMaterial.getPkValue().equals(material.getPkValue())) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u5176\u4ed6\u8f6c\u6362\u65f6\uff0c\u8f6c\u6362\u524d\u5206\u5f55\u884c%1$s\u4e0e\u8f6c\u6362\u540e\u5206\u5f55\u4e2d\u7684\u7269\u6599\u5fc5\u987b\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdjustbillImportValidator_10", (String)"scmc-im-opplugin", (Object[])new Object[0]), seq);
                this.addErrorMessage(dataEntity, msg);
            }
        }
    }

    private void checkUnitAdjust(ExtendedDataEntity dataEntity, DynamicObject billObj) {
        DynamicObjectCollection billEntrys = billObj.getDynamicObjectCollection("billentry");
        for (DynamicObject billEntry : billEntrys) {
            DynamicObject material = billEntry.getDynamicObject("material");
            DynamicObject unit = billEntry.getDynamicObject("unit");
            int seq = billEntry.getInt("seq");
            DynamicObjectCollection subEntrys = billEntry.getDynamicObjectCollection("afterentity");
            for (DynamicObject subEntry : subEntrys) {
                String msg;
                DynamicObject subMaterial = subEntry.getDynamicObject("material1");
                DynamicObject subUnit = subEntry.getDynamicObject("unit1");
                if (subMaterial != null && material != null && !subMaterial.getPkValue().equals(material.getPkValue())) {
                    msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u8ba1\u91cf\u5355\u4f4d\u8f6c\u6362\u65f6\uff0c\u8f6c\u6362\u524d\u5206\u5f55\u884c%1$s\u4e0e\u8f6c\u6362\u540e\u5206\u5f55\u4e2d\u7684\u7269\u6599\u5fc5\u987b\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdjustbillImportValidator_9", (String)"scmc-im-opplugin", (Object[])new Object[0]), seq);
                    this.addErrorMessage(dataEntity, msg);
                }
                if (unit == null || subUnit == null || !unit.getPkValue().equals(subUnit.getPkValue())) continue;
                msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u8ba1\u91cf\u5355\u4f4d\u8f6c\u6362\u65f6\uff0c\u8f6c\u6362\u524d\u5206\u5f55\u884c%1$s\u4e0e\u8f6c\u6362\u540e\u5206\u5f55\u4e2d\u7684\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdjustbillImportValidator_8", (String)"scmc-im-opplugin", (Object[])new Object[0]), seq);
                this.addErrorMessage(dataEntity, msg);
            }
        }
    }

    private void checkStatusAdjust(ExtendedDataEntity dataEntity, DynamicObject billObj) {
        DynamicObjectCollection billEntrys = billObj.getDynamicObjectCollection("billentry");
        for (DynamicObject billEntry : billEntrys) {
            DynamicObject material = billEntry.getDynamicObject("material");
            int seq = billEntry.getInt("seq");
            DynamicObject invStatus = billEntry.getDynamicObject("invstatus");
            DynamicObject invType = billEntry.getDynamicObject("invtype");
            DynamicObjectCollection subEntrys = billEntry.getDynamicObjectCollection("afterentity");
            for (DynamicObject subEntry : subEntrys) {
                String msg;
                DynamicObject subMaterial = subEntry.getDynamicObject("material1");
                DynamicObject subInvStatus = subEntry.getDynamicObject("invstatus1");
                DynamicObject subInvType = subEntry.getDynamicObject("invtype1");
                if (subMaterial != null && material != null && !subMaterial.getPkValue().equals(material.getPkValue())) {
                    msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u5e93\u5b58\u72b6\u6001\u8f6c\u6362\u65f6\uff0c\u8f6c\u6362\u524d\u5206\u5f55\u884c%1$s\u4e0e\u8f6c\u6362\u540e\u5206\u5f55\u4e2d\u7684\u7269\u6599\u5fc5\u987b\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdjustbillImportValidator_7", (String)"scmc-im-opplugin", (Object[])new Object[0]), seq);
                    this.addErrorMessage(dataEntity, msg);
                }
                if (invStatus == null || invType == null || subInvStatus == null || subInvType == null || !invStatus.getPkValue().equals(subInvStatus.getPkValue()) || !invType.getPkValue().equals(subInvType.getPkValue())) continue;
                msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u5e93\u5b58\u72b6\u6001\u8f6c\u6362\u65f6\uff0c\u8f6c\u6362\u524d\u5206\u5f55\u884c%1$s\u4e0e\u8f6c\u6362\u540e\u5206\u5f55\u4e2d\u7684\u5e93\u5b58\u72b6\u6001\u6216\u5e93\u5b58\u7c7b\u578b\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdjustbillImportValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[0]), seq);
                this.addErrorMessage(dataEntity, msg);
            }
        }
    }

    private void checkSnAdjust(ExtendedDataEntity dataEntity, DynamicObject billObj) {
        DynamicObjectCollection billEntrys = billObj.getDynamicObjectCollection("billentry");
        for (DynamicObject billEntry : billEntrys) {
            DynamicObject material = billEntry.getDynamicObject("material");
            int seq = billEntry.getInt("seq");
            if (material != null && !material.getBoolean("enableserial")) {
                String msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u5e8f\u5217\u53f7\u8f6c\u6362\u65f6\uff0c\u8f6c\u6362\u524d\u5206\u5f55\u884c%1$s\u4e0e\u8f6c\u6362\u540e\u5206\u5f55\u4e2d\u7684\u7269\u6599\u9700\u8981\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdjustbillImportValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0]), seq);
                this.addErrorMessage(dataEntity, msg);
            }
            DynamicObjectCollection subEntrys = billEntry.getDynamicObjectCollection("afterentity");
            for (DynamicObject subEntry : subEntrys) {
                DynamicObject subMaterial = subEntry.getDynamicObject("material1");
                if (subMaterial == null || material == null || subMaterial.getPkValue().equals(material.getPkValue())) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u5e8f\u5217\u53f7\u8f6c\u6362\u65f6\uff0c\u8f6c\u6362\u524d\u5206\u5f55\u884c%1$s\u4e0e\u8f6c\u6362\u540e\u5206\u5f55\u4e2d\u7684\u7269\u6599\u5fc5\u987b\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdjustbillImportValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]), seq);
                this.addErrorMessage(dataEntity, msg);
            }
        }
    }

    private void checkLotAdjust(ExtendedDataEntity dataEntity, DynamicObject billObj) {
        DynamicObjectCollection billEntrys = billObj.getDynamicObjectCollection("billentry");
        for (DynamicObject billEntry : billEntrys) {
            DynamicObject material = billEntry.getDynamicObject("material");
            int seq = billEntry.getInt("seq");
            if (material != null && !material.getBoolean("enablelot")) {
                String msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u6279\u6b21\u8f6c\u6362\u65f6\uff0c\u8f6c\u6362\u524d\u5206\u5f55\u884c%1$s\u4e0e\u8f6c\u6362\u540e\u5206\u5f55\u4e2d\u7684\u7269\u6599\u9700\u8981\u542f\u7528\u6279\u53f7\u7ba1\u7406\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdjustbillImportValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), seq);
                this.addErrorMessage(dataEntity, msg);
            }
            DynamicObjectCollection subEntrys = billEntry.getDynamicObjectCollection("afterentity");
            String lotNum = billEntry.getString("lotnumber");
            for (DynamicObject subEntry : subEntrys) {
                String msg;
                DynamicObject subMaterial = subEntry.getDynamicObject("material1");
                String subLotNum = subEntry.getString("lotnumber1");
                if (subMaterial != null && material != null && !subMaterial.getPkValue().equals(material.getPkValue())) {
                    msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u6279\u6b21\u8f6c\u6362\u65f6\uff0c\u8f6c\u6362\u524d\u5206\u5f55\u884c%1$s\u4e0e\u8f6c\u6362\u540e\u5206\u5f55\u4e2d\u7684\u7269\u6599\u5fc5\u987b\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdjustbillImportValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), seq);
                    this.addErrorMessage(dataEntity, msg);
                }
                if (!StringUtils.isNotBlank((CharSequence)lotNum) || !StringUtils.isNotBlank((CharSequence)subLotNum) || !lotNum.trim().equals(subLotNum.trim())) continue;
                msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u6279\u6b21\u8f6c\u6362\u65f6\uff0c\u8f6c\u6362\u524d\u5206\u5f55\u884c%1$s\u4e0e\u8f6c\u6362\u540e\u5206\u5f55\u4e2d\u7684\u6279\u53f7\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdjustbillImportValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), seq);
                this.addErrorMessage(dataEntity, msg);
            }
        }
    }

    private void checkMaterialAdjust(ExtendedDataEntity dataEntity, DynamicObject billObj) {
        DynamicObjectCollection billEntrys = billObj.getDynamicObjectCollection("billentry");
        for (DynamicObject billEntry : billEntrys) {
            DynamicObject material = billEntry.getDynamicObject("material");
            if (material == null) continue;
            Object matId = material.getPkValue();
            int seq = billEntry.getInt("seq");
            DynamicObjectCollection subEntrys = billEntry.getDynamicObjectCollection("afterentity");
            for (DynamicObject subEntry : subEntrys) {
                DynamicObject subMaterial = subEntry.getDynamicObject("material1");
                if (subMaterial == null || !subMaterial.getPkValue().equals(matId)) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7269\u6599\u8f6c\u6362\u65f6\uff0c\u8f6c\u6362\u524d\u5206\u5f55\u884c%1$s\u4e0e\u8f6c\u6362\u540e\u5206\u5f55\u4e2d\u7684\u7269\u6599\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdjustbillImportValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), seq);
                this.addErrorMessage(dataEntity, msg);
            }
        }
    }
}

