/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.importdata.ImptValidateHelper;
import kd.scmc.im.business.helper.linetype.BillTypeMaterialHelper;
import kd.scmc.im.business.helper.linetype.LineTypeParam;
import kd.scmc.im.business.pojo.ValidateResult;
import kd.scmc.im.enums.EnableStatusEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.IMStringUtils;

public class BillTplImprotValidator
extends AbstractValidator {
    private static final String importBillCreType = "1";
    private static final String webApiBillCreType = "3";
    private static final String enableStatus = "1";
    private static final String STATUS = "C";
    private Map<Object, Object> billTypeMap = new HashMap<Object, Object>(16);
    private Map<Object, Object> bizTypeMap = new HashMap<Object, Object>(16);
    private Map<Object, Object> lineTypeMap = new HashMap<Object, Object>(16);
    private Map<Object, Object> materialMap = new HashMap<Object, Object>(16);
    private Map<Object, Object> supplierMap = new HashMap<Object, Object>(16);
    private Map<Object, Object> supplierOrCustomerMap = new HashMap<Object, Object>(16);
    private Map<Object, Object> lineTypeByBillType = new HashMap<Object, Object>(16);
    private static final String FARMPURBILLTYPENUM = "im_PurInBill_FARM_BT_S";
    private static final String FARMPURRECBILLTYPENUM = "im_PurRecBill_FARM_BT_S";
    private String entityName = "";
    private Map<Long, Set<Long>> whIdToLocationIdsMap = new HashMap<Long, Set<Long>>(64);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"BillTplImprotValidator", (String)"validate");){
            String billCreType;
            DynamicObject invBill;
            HashSet<Object> orgIds = new HashSet<Object>(this.dataEntities.length);
            HashSet<Object> outOrgIds = new HashSet<Object>(this.dataEntities.length * 20);
            HashSet<Object> inOrgIds = new HashSet<Object>(this.dataEntities.length * 20);
            HashSet<Object> bizOrgIds = new HashSet<Object>(this.dataEntities.length * 20);
            HashSet<Object> warehIds = new HashSet<Object>(this.dataEntities.length * 20);
            HashSet<Object> inWarehIds = new HashSet<Object>(this.dataEntities.length * 20);
            HashSet<String> allWareHouseSet = new HashSet(this.dataEntities.length * 20);
            HashSet<String> inWareHouseSet = new HashSet(this.dataEntities.length * 20);
            HashSet<String> outWareHouseSet = new HashSet(this.dataEntities.length * 20);
            HashMap<Object, List<Object>> billType2BizTypesMap = new HashMap<Object, List<Object>>(this.dataEntities.length);
            HashSet<Object> billTypeIds = new HashSet<Object>(this.dataEntities.length);
            HashSet<Object> bizTypeIds = new HashSet<Object>(this.dataEntities.length);
            HashSet<Object> lineTypeIds = new HashSet<Object>(this.dataEntities.length * 20);
            HashSet<Object> materialIds = new HashSet<Object>(this.dataEntities.length * 20);
            HashSet<Object> supplierIds = new HashSet<Object>(this.dataEntities.length * 20);
            HashSet<Object> supplierOrCustomerIds = new HashSet<Object>(this.dataEntities.length * 20);
            String formId = "";
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject bizOrg;
                invBill = dataEntity.getDataEntity();
                billCreType = invBill.getString("billcretype");
                formId = invBill.getDataEntityType().getName();
                if (!"1".equals(billCreType) && !webApiBillCreType.equals(billCreType)) continue;
                if (!"im_initbill".equals(formId)) {
                    DynamicObject importBizType;
                    DynamicObject importBillType = invBill.getDynamicObject("billtype");
                    if (importBillType != null) {
                        Object pkValue = importBillType.getPkValue();
                        billTypeIds.add(pkValue);
                        if (billType2BizTypesMap.get(pkValue) == null) {
                            billType2BizTypesMap.put(pkValue, BizTypeHelper.getBizTypeIds((Object)pkValue, (String)invBill.getDataEntityType().getName()));
                        }
                    }
                    if ((importBizType = invBill.getDynamicObject("biztype")) != null) {
                        Object bizTypePkValue = importBizType.getPkValue();
                        bizTypeIds.add(bizTypePkValue);
                    }
                }
                DynamicObjectCollection collect = invBill.getDynamicObjectCollection("billentry");
                DynamicObject org = invBill.getDynamicObject("org");
                if (org != null) {
                    Object orgId = org.getPkValue();
                    orgIds.add(orgId);
                }
                if ("im_materialreqbill".equals(formId) && (bizOrg = invBill.getDynamicObject("bizorg")) != null) {
                    bizOrgIds.add(bizOrg.getPkValue());
                }
                for (DynamicObject entry : collect) {
                    DynamicObject importMaterialInfo;
                    DynamicObject importLineType;
                    if (!"im_initbill".equals(formId) && (importLineType = entry.getDynamicObject("linetype")) != null) {
                        Object lineTypePkValue = importLineType.getPkValue();
                        lineTypeIds.add(lineTypePkValue);
                    }
                    if ((importMaterialInfo = entry.getDynamicObject("material")) != null) {
                        this.updateLotNum(entry, importMaterialInfo);
                        DynamicObject masterMaterial = importMaterialInfo.getDynamicObject("masterid");
                        if (masterMaterial != null) {
                            Object materialPKValue = masterMaterial.getPkValue();
                            materialIds.add(materialPKValue);
                        }
                    }
                    DynamicObject warehouse = entry.getDynamicObject("warehouse");
                    if ("im_transapply".equals(formId)) {
                        DynamicObject inWarehouse;
                        DynamicObject outOrg = entry.getDynamicObject("outorg");
                        DynamicObject inOrg = entry.getDynamicObject("inorg");
                        if (outOrg != null) {
                            outOrgIds.add(outOrg.getPkValue());
                        }
                        if (inOrg != null) {
                            inOrgIds.add(inOrg.getPkValue());
                        }
                        if ((inWarehouse = entry.getDynamicObject("inwarehouse")) != null) {
                            inWarehIds.add(inWarehouse.getLong("id"));
                        }
                        if (inWarehouse == null && warehouse == null) continue;
                    }
                    if ("im_invinspectbill".equals(formId)) {
                        DynamicObject unQualifiedWarehouse;
                        DynamicObject qualifiedWarehouse;
                        DynamicObject outWarehouse = entry.getDynamicObject("outwarehouse");
                        if (outWarehouse != null) {
                            warehIds.add(outWarehouse.getLong("id"));
                        }
                        if ((qualifiedWarehouse = entry.getDynamicObject("qualifiedwarehouse")) != null) {
                            warehIds.add(qualifiedWarehouse.getLong("id"));
                        }
                        if ((unQualifiedWarehouse = entry.getDynamicObject("unqualifiedwarehouse")) != null) {
                            warehIds.add(unQualifiedWarehouse.getLong("id"));
                        }
                    }
                    if (warehouse == null) continue;
                    warehIds.add(warehouse.getLong("id"));
                }
                supplierIds.addAll(this.cacheSupplier(invBill, formId));
                supplierOrCustomerIds.addAll(this.cacheSupplierOrCustomer(invBill, formId));
            }
            if (!billTypeIds.isEmpty()) {
                this.billTypeMap = BillTplImprotValidator.queryDataByIds(billTypeIds, "bos_billtype");
            }
            if (!bizTypeIds.isEmpty()) {
                this.bizTypeMap = BillTplImprotValidator.queryDataByIds(bizTypeIds, "bd_biztype");
                this.lineTypeByBillType = BillTplImprotValidator.queryDataByIds(bizTypeIds, "");
            }
            if (!lineTypeIds.isEmpty()) {
                this.lineTypeMap = BillTplImprotValidator.queryDataByIds(lineTypeIds, "bd_linetype");
            }
            if (!materialIds.isEmpty()) {
                this.materialMap = BillTplImprotValidator.queryDataByIds(materialIds, "bd_material");
            }
            if (!supplierIds.isEmpty()) {
                this.supplierMap = BillTplImprotValidator.queryDataByIds(supplierIds, "bd_supplier");
            }
            if (!supplierOrCustomerIds.isEmpty()) {
                this.supplierOrCustomerMap = BillTplImprotValidator.queryDataByIds(supplierOrCustomerIds, this.entityName);
            }
            if ("im_transapply".equals(formId)) {
                inWareHouseSet = this.getAllWareHouseSet(inOrgIds, inWarehIds);
                outWareHouseSet = this.getAllWareHouseSet(outOrgIds, warehIds);
            } else {
                if ("im_materialreqbill".equals(formId)) {
                    orgIds = bizOrgIds;
                }
                allWareHouseSet = this.getAllWareHouseSet(orgIds, warehIds);
            }
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                invBill = dataEntity.getDataEntity();
                billCreType = invBill.getString("billcretype");
                if (!"1".equals(billCreType) && !webApiBillCreType.equals(billCreType)) continue;
                this.checkMaterial(dataEntity, invBill);
                if (!"im_initbill".equals(formId)) {
                    this.checkBizAndLineType(dataEntity, invBill, billType2BizTypesMap);
                }
                this.checkSupplierAndOwner(dataEntity, invBill, formId);
                if ("im_transapply".equals(formId)) {
                    this.check4TransApplyLocation(dataEntity, invBill, outWareHouseSet, inWareHouseSet);
                } else {
                    this.check4Location(dataEntity, invBill, allWareHouseSet);
                }
                if ("im_purreceivebill".equals(formId) || "im_purinbill".equals(formId) || "im_ospurinbill".equals(formId)) {
                    this.checkSupplier(dataEntity, invBill);
                }
                if ("im_saloutbill".equals(formId)) {
                    this.checkCustomer(dataEntity, invBill);
                }
                this.checkProduceDateAndExpiryDate(dataEntity, invBill);
            }
        }
    }

    private void checkCustomer(ExtendedDataEntity dataEntity, DynamicObject invBill) {
        Object customer = invBill.get("customer");
        if (customer == null) {
            return;
        }
        DynamicObject customerDy = (DynamicObject)(customer = this.supplierOrCustomerMap.get(((DynamicObject)customer).getPkValue()));
        if (customerDy == null) {
            return;
        }
        Object bizFunction = customerDy.get("bizfunction");
        if (bizFunction == null || !bizFunction.toString().contains("4")) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u201c\u6536\u8d27\u5ba2\u6237\u201d\u6ca1\u6709\u6536\u8d27\u4e1a\u52a1\u804c\u80fd\u3002", (String)"BillTplImprotValidator_27", (String)"scmc-im-opplugin", (Object[])new Object[0]), customerDy.getString("number")));
        }
        DynamicObjectCollection entries = invBill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entries) {
            DynamicObject recCustomerDy;
            Object recCustomerFunction;
            Object recCustomer;
            DynamicObject payingCustomerDy;
            Object payingCustomerFunction;
            Object payingCustomer;
            DynamicObject settleCustomerDy;
            Object settleCustomerFunction;
            Object settleCustomer = entry.get("settlecustomer");
            if (!(settleCustomer == null || (settleCustomerFunction = (settleCustomerDy = (DynamicObject)(settleCustomer = this.supplierOrCustomerMap.get(((DynamicObject)settleCustomer).getPkValue()))).get("bizfunction")) != null && settleCustomerFunction.toString().contains("2"))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u201c\u7ed3\u7b97\u5ba2\u6237\u201d\u6ca1\u6709\u53d1\u7968\u4e1a\u52a1\u804c\u80fd\u3002", (String)"BillTplImprotValidator_29", (String)"scmc-im-opplugin", (Object[])new Object[0]), settleCustomerDy.getString("number")));
            }
            if (!((payingCustomer = entry.get("payingcustomer")) == null || (payingCustomerFunction = (payingCustomerDy = (DynamicObject)(payingCustomer = this.supplierOrCustomerMap.get(((DynamicObject)payingCustomer).getPkValue()))).get("bizfunction")) != null && payingCustomerFunction.toString().contains(webApiBillCreType))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u201c\u4ed8\u6b3e\u5ba2\u6237\u201d\u6ca1\u6709\u4ed8\u6b3e\u4e1a\u52a1\u804c\u80fd\u3002", (String)"BillTplImprotValidator_28", (String)"scmc-im-opplugin", (Object[])new Object[0]), payingCustomerDy.getString("number")));
            }
            if ((recCustomer = entry.get("reccustomer")) == null || (recCustomerFunction = (recCustomerDy = (DynamicObject)(recCustomer = this.supplierOrCustomerMap.get(((DynamicObject)recCustomer).getPkValue()))).get("bizfunction")) != null && recCustomerFunction.toString().contains("1")) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u201c\u8ba2\u8d27\u5ba2\u6237\u201d\u6ca1\u6709\u9500\u552e\u4e1a\u52a1\u804c\u80fd\u3002", (String)"BillTplImprotValidator_30", (String)"scmc-im-opplugin", (Object[])new Object[0]), recCustomerDy.getString("number")));
        }
    }

    private Set<Object> cacheSupplierOrCustomer(DynamicObject invBill, String formId) {
        HashSet<Object> result = new HashSet<Object>(16);
        switch (formId) {
            case "im_purinbill": 
            case "im_ospurinbill": 
            case "im_purreceivebill": {
                Object headSupplier = invBill.get("supplier");
                if (headSupplier != null) {
                    result.add(((DynamicObject)headSupplier).getPkValue());
                }
                this.cacheEntry(invBill, result, true);
                this.entityName = "bd_supplier";
                break;
            }
            case "im_saloutbill": {
                Object headCustomer = invBill.get("customer");
                if (headCustomer != null) {
                    result.add(((DynamicObject)headCustomer).getPkValue());
                }
                this.cacheEntry(invBill, result, false);
                this.entityName = "bd_customer";
                break;
            }
        }
        return result;
    }

    private void cacheEntry(DynamicObject invBill, Set<Object> result, boolean inBill) {
        DynamicObjectCollection entries = invBill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entries) {
            if (inBill) {
                Object providerSupplier = entry.get("providersupplier");
                Object invoiceSupplier = entry.get("invoicesupplier");
                Object receiveSupplier = entry.get("receivesupplier");
                if (providerSupplier != null) {
                    result.add(((DynamicObject)providerSupplier).getPkValue());
                }
                if (invoiceSupplier != null) {
                    result.add(((DynamicObject)invoiceSupplier).getPkValue());
                }
                if (receiveSupplier == null) continue;
                result.add(((DynamicObject)receiveSupplier).getPkValue());
                continue;
            }
            Object payingCustomer = entry.get("payingcustomer");
            Object settleCustomer = entry.get("settlecustomer");
            Object recCustomer = entry.get("reccustomer");
            if (payingCustomer != null) {
                result.add(((DynamicObject)payingCustomer).getPkValue());
            }
            if (settleCustomer != null) {
                result.add(((DynamicObject)settleCustomer).getPkValue());
            }
            if (recCustomer == null) continue;
            result.add(((DynamicObject)recCustomer).getPkValue());
        }
    }

    private void checkSupplier(ExtendedDataEntity dataEntity, DynamicObject invBill) {
        Object supplier = invBill.get("supplier");
        if (supplier == null) {
            return;
        }
        if ((supplier = this.supplierOrCustomerMap.get(((DynamicObject)supplier).getPkValue())) == null) {
            return;
        }
        DynamicObject supplierDy = (DynamicObject)supplier;
        Object bizFunction = supplierDy.get("bizfunction");
        if (bizFunction == null || !bizFunction.toString().contains("4")) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u201c\u4f9b\u8d27\u4f9b\u5e94\u5546\u201d\u6ca1\u6709\u4f9b\u8d27\u4e1a\u52a1\u804c\u80fd\u3002", (String)"BillTplImprotValidator_23", (String)"scmc-im-opplugin", (Object[])new Object[0]), supplierDy.getString("number")));
        }
        DynamicObjectCollection entries = invBill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entries) {
            DynamicObject receiveSupplierDy;
            Object receiveSupplierFunction;
            Object receiveSupplier;
            DynamicObject invoiceSupplierDy;
            Object invoiceSupplierFunction;
            Object invoiceSupplier;
            DynamicObject providerSupplierDy;
            Object providerSupplierFunction;
            Object providerSupplier = entry.get("providersupplier");
            if (!(providerSupplier == null || (providerSupplierFunction = (providerSupplierDy = (DynamicObject)(providerSupplier = this.supplierOrCustomerMap.get(((DynamicObject)providerSupplier).getPkValue()))).get("bizfunction")) != null && providerSupplierFunction.toString().contains("1"))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u201c\u8ba2\u8d27\u4f9b\u5e94\u5546\u201d\u6ca1\u6709\u91c7\u8d2d\u4e1a\u52a1\u804c\u80fd\u3002", (String)"BillTplImprotValidator_24", (String)"scmc-im-opplugin", (Object[])new Object[0]), providerSupplierDy.getString("number")));
            }
            if (!((invoiceSupplier = entry.get("invoicesupplier")) == null || (invoiceSupplierFunction = (invoiceSupplierDy = (DynamicObject)(invoiceSupplier = this.supplierOrCustomerMap.get(((DynamicObject)invoiceSupplier).getPkValue()))).get("bizfunction")) != null && invoiceSupplierFunction.toString().contains("2"))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u201c\u7ed3\u7b97\u4f9b\u5e94\u5546\u201d\u6ca1\u6709\u53d1\u7968\u4e1a\u52a1\u804c\u80fd\u3002", (String)"BillTplImprotValidator_25", (String)"scmc-im-opplugin", (Object[])new Object[0]), invoiceSupplierDy.getString("number")));
            }
            if ((receiveSupplier = entry.get("receivesupplier")) == null || (receiveSupplierFunction = (receiveSupplierDy = (DynamicObject)(receiveSupplier = this.supplierOrCustomerMap.get(((DynamicObject)receiveSupplier).getPkValue()))).get("bizfunction")) != null && receiveSupplierFunction.toString().contains(webApiBillCreType)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u201c\u6536\u6b3e\u4f9b\u5e94\u5546\u201d\u6ca1\u6709\u6536\u6b3e\u4e1a\u52a1\u804c\u80fd\u3002", (String)"BillTplImprotValidator_26", (String)"scmc-im-opplugin", (Object[])new Object[0]), receiveSupplierDy.getString("number")));
        }
    }

    private void checkMaterial(ExtendedDataEntity dataEntity, DynamicObject invBill) {
        DynamicObjectCollection entries = invBill.getDynamicObjectCollection("billentry");
        String formId = invBill.getDataEntityType().getName();
        Object billType = invBill.get("billtype");
        for (DynamicObject entry : entries) {
            boolean farmProducts;
            Object number;
            boolean enableOutsource;
            DynamicObject material;
            DynamicObject masterMaterial;
            DynamicObject importMaterialInfo = entry.getDynamicObject("material");
            if (importMaterialInfo == null || (masterMaterial = importMaterialInfo.getDynamicObject("masterid")) == null || (material = (DynamicObject)this.materialMap.get(masterMaterial.getPkValue())) == null) continue;
            if (!"1".equals(material.get("enable"))) {
                this.addErrorMessage(dataEntity, IMStringUtils.append((String)ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5355\u636e\u7269\u6599\u2018", (String)"BillTplImprotValidator_11", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{material.get("number"), ResManager.loadKDString((String)"\u2019\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"BillTplImprotValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0])}));
                continue;
            }
            if (!STATUS.equals(material.get("status"))) {
                this.addErrorMessage(dataEntity, IMStringUtils.append((String)ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5355\u636e\u7269\u6599\u2018", (String)"BillTplImprotValidator_11", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{material.get("number"), ResManager.loadKDString((String)"\u2019\u672a\u5ba1\u6838\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"BillTplImprotValidator_15", (String)"scmc-im-opplugin", (Object[])new Object[0])}));
                continue;
            }
            if ("im_ospurinbill".equals(formId) && !(enableOutsource = material.getBoolean("enableoutsource"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bfc\u5165\u53ef\u59d4\u5916\u7684\u7269\u6599\u3002", (String)"BillTplImprotValidator_22", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
            if (!"im_purinbill".equals(formId) && !"im_purreceivebill".equals(formId) || !FARMPURBILLTYPENUM.equals(number = ((DynamicObject)billType).get("number")) && !FARMPURRECBILLTYPENUM.equals(number) || (farmProducts = material.getBoolean("farmproducts"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u5355\u636e\u7c7b\u578b\u4ec5\u5141\u8bb8\u5f55\u5165\u519c\u4ea7\u54c1\u7269\u6599\u3002\u2018", (String)"BillTplImprotValidator_31", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }

    private Set<Object> cacheSupplier(DynamicObject invBill, String formId) {
        HashSet<Object> supplierIds = new HashSet<Object>(16);
        DynamicObject supplier = this.getSupplier(invBill, formId);
        if (supplier != null) {
            supplierIds.add(supplier.getPkValue());
        }
        DynamicObjectCollection entries = invBill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entries) {
            DynamicObject owner = this.getOwner(entry, formId);
            if (owner == null) continue;
            supplierIds.add(owner.getPkValue());
        }
        return supplierIds;
    }

    private DynamicObject getSupplier(DynamicObject invBill, String formId) {
        DynamicObject supplier = null;
        switch (formId) {
            case "im_purreceivebill": 
            case "im_purinbill": {
                supplier = invBill.getDynamicObject("supplier");
                break;
            }
            case "im_materialreqbill": 
            case "im_materialreqoutbill": {
                String supplyOwnerType = invBill.getString("supplyownertype");
                if (!"bd_supplier".equals(supplyOwnerType)) break;
                supplier = invBill.getDynamicObject("supplyowner");
                break;
            }
        }
        return supplier;
    }

    private DynamicObject getOwner(DynamicObject entry, String formId) {
        DynamicObject owner = null;
        switch (formId) {
            case "im_materialreqoutbill": 
            case "im_saloutbill": 
            case "im_otheroutbill": 
            case "im_transdirbill": {
                String ownerType = entry.getString("outownertype");
                if (!"bd_supplier".equals(ownerType)) break;
                owner = entry.getDynamicObject("outowner");
                break;
            }
            case "im_purreceivebill": 
            case "im_purinbill": 
            case "im_transapply": {
                String ownerType = entry.getString("ownertype");
                if (!"bd_supplier".equals(ownerType)) break;
                owner = entry.getDynamicObject("owner");
                break;
            }
        }
        return owner;
    }

    public static Map<Object, Object> queryDataByIds(Set<Object> idSet, String entityName) {
        HashMap<Object, Object> queryDataMap = new HashMap<Object, Object>(16);
        int size = idSet.size();
        int MaxNum = 512;
        HashSet<Object> newIdSet = new HashSet<Object>(16);
        if (size >= MaxNum) {
            for (Object id : idSet) {
                newIdSet.add(id);
                if (newIdSet.size() != MaxNum) continue;
                if (entityName.equals("")) {
                    List<Long> idList = BillTplImprotValidator.getIdList(newIdSet);
                    queryDataMap.putAll(BillTypeMaterialHelper.getLineTypeByBillType(idList));
                } else {
                    queryDataMap.putAll(BusinessDataServiceHelper.loadFromCache((Object[])newIdSet.toArray(), (String)entityName));
                }
                newIdSet.clear();
            }
            if (!newIdSet.isEmpty()) {
                if (entityName.equals("")) {
                    List<Long> idList = BillTplImprotValidator.getIdList(newIdSet);
                    queryDataMap.putAll(BillTypeMaterialHelper.getLineTypeByBillType(idList));
                } else {
                    queryDataMap.putAll(BusinessDataServiceHelper.loadFromCache((Object[])newIdSet.toArray(), (String)entityName));
                }
            }
        } else if (entityName.equals("")) {
            List<Long> idList = BillTplImprotValidator.getIdList(idSet);
            queryDataMap.putAll(BillTypeMaterialHelper.getLineTypeByBillType(idList));
        } else {
            queryDataMap.putAll(BusinessDataServiceHelper.loadFromCache((Object[])idSet.toArray(), (String)entityName));
        }
        return queryDataMap;
    }

    private static List<Long> getIdList(Set<Object> idSet) {
        ArrayList<Long> idList = new ArrayList<Long>(16);
        for (Object id : idSet) {
            idList.add((Long)id);
        }
        return idList;
    }

    private void checkBizAndLineType(ExtendedDataEntity dataEntity, DynamicObject invBill, Map<Object, List<Object>> billType2BizTypesMap) {
        LineTypeParam lineTypeParam;
        String formId = invBill.getDataEntityType().getName();
        DynamicObject importBillType = invBill.getDynamicObject("billtype");
        if (importBillType == null) {
            return;
        }
        DynamicObject billType = (DynamicObject)this.billTypeMap.get(importBillType.getPkValue());
        if (billType != null && !"1".equals(billType.get("enable"))) {
            this.addErrorMessage(dataEntity, IMStringUtils.append((String)ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5355\u636e\u7c7b\u578b\u2018", (String)"BillTplImprotValidator_14", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{billType.get("number"), billType.get("name"), ResManager.loadKDString((String)"\u2019\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"BillTplImprotValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0])}));
            return;
        }
        if (billType != null && !STATUS.equals(billType.get("status"))) {
            this.addErrorMessage(dataEntity, IMStringUtils.append((String)ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5355\u636e\u7c7b\u578b\u2018", (String)"BillTplImprotValidator_14", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{billType.get("number"), billType.get("name"), ResManager.loadKDString((String)"\u2019\u672a\u5ba1\u6838\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"BillTplImprotValidator_15", (String)"scmc-im-opplugin", (Object[])new Object[0])}));
            return;
        }
        DynamicObject importBizType = invBill.getDynamicObject("biztype");
        if (importBizType == null) {
            return;
        }
        DynamicObject bizType = (DynamicObject)this.bizTypeMap.get(importBizType.getPkValue());
        if (bizType != null && !"1".equals(bizType.get("enable"))) {
            this.addErrorMessage(dataEntity, IMStringUtils.append((String)ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5355\u636e\u4e1a\u52a1\u7c7b\u578b\u2018", (String)"BillTplImprotValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{bizType.get("number"), bizType.get("name"), ResManager.loadKDString((String)"\u2019\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"BillTplImprotValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0])}));
            return;
        }
        if (bizType != null && billType != null && !billType2BizTypesMap.get(billType.getPkValue()).contains(bizType.getPkValue())) {
            this.addErrorMessage(dataEntity, IMStringUtils.append((String)ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5355\u636e\u4e1a\u52a1\u7c7b\u578b\u2018", (String)"BillTplImprotValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{bizType.get("number"), bizType.get("name"), ResManager.loadKDString((String)"\u2019\u4e0d\u662f\u5355\u636e\u7c7b\u578b\u2018", (String)"BillTplImprotValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[0]), billType.get("number"), billType.get("name"), ResManager.loadKDString((String)"\u2019\u7684\u5173\u8054\u4e1a\u52a1\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"BillTplImprotValidator_7", (String)"scmc-im-opplugin", (Object[])new Object[0])}));
            return;
        }
        if (this.lineTypeByBillType.isEmpty()) {
            return;
        }
        LineTypeParam lineTypeParam2 = lineTypeParam = bizType == null ? null : (LineTypeParam)this.lineTypeByBillType.get(bizType.getLong("id"));
        if (lineTypeParam == null) {
            return;
        }
        Set lineTypeIds = lineTypeParam.getLineTypeIds();
        DynamicObjectCollection entries = invBill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entries) {
            DynamicObject importLineType = entry.getDynamicObject("linetype");
            if (importLineType == null) {
                return;
            }
            DynamicObject lineType = (DynamicObject)this.lineTypeMap.get(importLineType.getPkValue());
            if (lineType != null && !"1".equals(lineType.get("enable"))) {
                this.addErrorMessage(dataEntity, IMStringUtils.append((String)ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5355\u636e\u884c\u7c7b\u578b\u2018", (String)"BillTplImprotValidator_32", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{lineType.get("number"), lineType.get("name"), ResManager.loadKDString((String)"\u2019\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"BillTplImprotValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0])}));
                return;
            }
            if (lineType != null && !lineTypeIds.contains(lineType.getLong("id"))) {
                this.addErrorMessage(dataEntity, IMStringUtils.append((String)ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5355\u636e\u884c\u7c7b\u578b\u2018", (String)"BillTplImprotValidator_32", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{lineType.get("number"), lineType.get("name"), ResManager.loadKDString((String)"\u2019\u4e0d\u662f\u4e1a\u52a1\u7c7b\u578b\u2018", (String)"BillTplImprotValidator_9", (String)"scmc-im-opplugin", (Object[])new Object[0]), bizType.get("number"), bizType.get("name"), ResManager.loadKDString((String)"\u2019\u7684\u5173\u8054\u884c\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"BillTplImprotValidator_10", (String)"scmc-im-opplugin", (Object[])new Object[0])}));
                return;
            }
            DynamicObject importMaterialInfo = entry.getDynamicObject("material");
            if (importMaterialInfo == null) {
                return;
            }
            DynamicObject masterMaterial = importMaterialInfo.getDynamicObject("masterid");
            if (masterMaterial == null) {
                return;
            }
            DynamicObject material = (DynamicObject)this.materialMap.get(masterMaterial.getPkValue());
            if (material == null) {
                return;
            }
            if ("im_purreceivebill".equals(formId) || "im_purinbill".equals(formId) || "im_materialreqoutbill".equals(formId) || "im_otheroutbill".equals(formId) || "im_saloutbill".equals(formId) || "im_transdirbill".equals(formId) || "im_materialreqbill".equals(formId) || "im_transapply".equals(formId)) {
                Object domain = bizType.get("domain");
                boolean enablevmi = material.getBoolean("enablevmi");
                if (!enablevmi && "6".equals(domain)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"VMI\u4e1a\u52a1\u7c7b\u578b\u4e0e\u7269\u6599\u4e0d\u5339\u914d\uff0c\u8bf7\u5f00\u542f\u7269\u6599\u53efVMI\u6216\u4f7f\u7528\u6b63\u786e\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"BillTplImprotValidator_16", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
            DynamicObjectCollection serviceAttributes = material.getDynamicObjectCollection("serviceattribute");
            HashSet<Object> serviceAttributeList = new HashSet<Object>(serviceAttributes.size());
            for (DynamicObject serviceAttribute : serviceAttributes) {
                serviceAttributeList.add(serviceAttribute.get("fbasedataid_id"));
            }
            if (lineType == null || serviceAttributeList.contains(lineType.getDynamicObject("serviceattribute").getPkValue())) continue;
            this.addErrorMessage(dataEntity, IMStringUtils.append((String)ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5355\u636e\u7269\u6599\u2018", (String)"BillTplImprotValidator_11", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{material.get("number"), ResManager.loadKDString((String)"\u2019\u7684\u4e1a\u52a1\u5c5e\u6027\u4e0e\u884c\u7c7b\u578b\u2018", (String)"BillTplImprotValidator_12", (String)"scmc-im-opplugin", (Object[])new Object[0]), lineType.get("number"), lineType.get("name"), ResManager.loadKDString((String)"\u2019\u7684\u4e1a\u52a1\u5c5e\u6027\u4e0d\u76f8\u7b49\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"BillTplImprotValidator_13", (String)"scmc-im-opplugin", (Object[])new Object[0])}));
        }
    }

    private void updateLotNum(DynamicObject entry, DynamicObject importMaterialInfo) {
        boolean enablelot = importMaterialInfo.getBoolean("enablelot");
        if (!enablelot) {
            entry.set("lotnumber", (Object)"");
        }
    }

    private void checkSupplierAndOwner(ExtendedDataEntity dataEntity, DynamicObject invBill, String formId) {
        DynamicObject importBizType = invBill.getDynamicObject("biztype");
        if (importBizType == null) {
            return;
        }
        DynamicObject bizType = (DynamicObject)this.bizTypeMap.get(importBizType.getPkValue());
        if (bizType != null && "6".equals(bizType.get("domain"))) {
            DynamicObject importSupplier = this.getSupplier(invBill, formId);
            if (importSupplier != null) {
                DynamicObject supplier = (DynamicObject)this.supplierMap.get(importSupplier.getPkValue());
                if (supplier == null) {
                    return;
                }
                boolean enableVMI = supplier.getBoolean("enablevmi");
                if (!enableVMI) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"VMI\u4e1a\u52a1\u7c7b\u578b\u4e0e\u4f9b\u5e94\u5546\u4e0d\u5339\u914d\uff0c\u8bf7\u5f00\u542f\u4f9b\u5e94\u5546\u53efVMI\u6216\u4f7f\u7528\u6b63\u786e\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"BillTplImprotValidator_17", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
            DynamicObjectCollection entries = invBill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entries) {
                DynamicObject importOwner = this.getOwner(entry, formId);
                if (importOwner == null) continue;
                DynamicObject owner = (DynamicObject)this.supplierMap.get(importOwner.getPkValue());
                if (owner == null) {
                    return;
                }
                boolean enableVMI = owner.getBoolean("enablevmi");
                if (enableVMI) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"VMI\u4e1a\u52a1\u7c7b\u578b\u4e0e\u4f9b\u5e94\u5546\u4e0d\u5339\u914d\uff0c\u8bf7\u5f00\u542f\u4f9b\u5e94\u5546\u53efVMI\u6216\u4f7f\u7528\u6b63\u786e\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"BillTplImprotValidator_17", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void checkProduceDateAndExpiryDate(ExtendedDataEntity dataEntity, DynamicObject invBill) {
        String formId = invBill.getDataEntityType().getName();
        if (!"im_initbill".equals(formId)) {
            return;
        }
        DynamicObjectCollection collect = invBill.getDynamicObjectCollection("billentry");
        for (DynamicObject item : collect) {
            ValidateResult result;
            String errMsg;
            DynamicObject materialInfo = item.getDynamicObject("material");
            if (materialInfo == null || !StringUtils.isNotBlank((CharSequence)(errMsg = (result = ImptValidateHelper.checkProduceDateAndExpiryDate((DynamicObject)item)).getValResult()))) continue;
            this.addErrorMessage(dataEntity, errMsg);
        }
    }

    private void check4TransApplyLocation(ExtendedDataEntity dataEntity, DynamicObject invBill, Set<String> outWareHouseSet, Set<String> inWareHouseSet) {
        DynamicObjectCollection collect = invBill.getDynamicObjectCollection("billentry");
        for (DynamicObject item : collect) {
            DynamicObject outOrg = item.getDynamicObject("outorg");
            this.checkWareHouse(dataEntity, outOrg, item, outWareHouseSet, "warehouse", "location");
            DynamicObject inOrg = item.getDynamicObject("inorg");
            this.checkWareHouse(dataEntity, inOrg, item, inWareHouseSet, "inwarehouse", "inlocation");
        }
    }

    public void check4Location(ExtendedDataEntity dataEntity, DynamicObject invBill, Set<String> allWareHouseSet) {
        DynamicObject org = invBill.getDynamicObject("org");
        DynamicObjectCollection collect = invBill.getDynamicObjectCollection("billentry");
        String formId = invBill.getDataEntityType().getName();
        if ("im_materialreqbill".equals(formId)) {
            org = invBill.getDynamicObject("bizorg");
        }
        for (DynamicObject item : collect) {
            this.checkWareHouse(dataEntity, org, item, allWareHouseSet, "warehouse", "location");
            if (!"im_invinspectbill".equals(formId)) continue;
            this.checkWareHouse(dataEntity, org, item, allWareHouseSet, "outwarehouse", "outlocation");
            this.checkWareHouse(dataEntity, org, item, allWareHouseSet, "qualifiedwarehouse", "qualifiedlocation");
            this.checkWareHouse(dataEntity, org, item, allWareHouseSet, "unqualifiedwarehouse", "unqualifiedlocation");
        }
    }

    private void checkWareHouse(ExtendedDataEntity dataEntity, DynamicObject org, DynamicObject item, Set<String> wareHouseSet, String warehouseKey, String locationKey) {
        String fromId = dataEntity.getDataEntity().getDataEntityType().getName();
        DynamicObject wh = item.getDynamicObject(warehouseKey);
        if (wh == null) {
            return;
        }
        String key = "";
        String orgName = "";
        if (org != null) {
            key = org.getPkValue() + "_" + wh.getPkValue();
            orgName = org.getString("name");
        }
        if (!wareHouseSet.contains(key)) {
            String content = CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_WAREHOUSESET_NOTEXIT(), (Object[])new Object[]{orgName, wh.getString("name")});
            if ("im_transapply".equals(fromId)) {
                content = "warehouse".equals(warehouseKey) ? IMStringUtils.append((String)ResManager.loadKDString((String)"\u8c03\u51fa", (String)"BillTplImprotValidator_18", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{content}) : IMStringUtils.append((String)ResManager.loadKDString((String)"\u8c03\u5165", (String)"BillTplImprotValidator_19", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{content});
            }
            this.addErrorMessage(dataEntity, content);
        } else {
            DynamicObject location = item.getDynamicObject(locationKey);
            if (location != null) {
                if (!wh.getBoolean("isopenlocation")) {
                    String content = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5355\u636e", (String)"BillTplImprotValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                    content = this.addErrorContent(fromId, content, warehouseKey);
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\u4ed3\u5e93\u201c{1}\u201d\u672a\u542f\u7528\u4ed3\u4f4d\u7ba1\u7406,\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"BillTplImprotValidator_21", (String)"scmc-im-opplugin", (Object[])new Object[]{content, wh.getString("name")}));
                } else {
                    boolean contain;
                    Long warehouseId = (Long)wh.getPkValue();
                    Long locationId = (Long)location.getPkValue();
                    boolean bl = contain = this.whIdToLocationIdsMap.get(warehouseId) != null && this.whIdToLocationIdsMap.get(warehouseId).contains(locationId);
                    if (!contain) {
                        String content = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5355\u636e", (String)"BillTplImprotValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                        content = this.addErrorContent(fromId, content, warehouseKey);
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\u4ed3\u5e93\u201c{1}\u201d\u4e0d\u5b58\u5728\u4ed3\u4f4d\u201c{2}\u201d,\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"BillTplImprotValidator_33", (String)"scmc-im-opplugin", (Object[])new Object[]{content, wh.getString("name"), location.getString("name")}));
                    }
                }
            }
        }
    }

    private String addErrorContent(String fromId, String content, String warehouseKey) {
        if ("im_transapply".equals(fromId)) {
            content = "warehouse".equals(warehouseKey) ? IMStringUtils.append((String)content, (Object[])new Object[]{ResManager.loadKDString((String)"\u8c03\u51fa", (String)"BillTplImprotValidator_18", (String)"scmc-im-opplugin", (Object[])new Object[0])}) : IMStringUtils.append((String)content, (Object[])new Object[]{ResManager.loadKDString((String)"\u8c03\u5165", (String)"BillTplImprotValidator_19", (String)"scmc-im-opplugin", (Object[])new Object[0])});
        }
        return content;
    }

    private Set<String> getAllWareHouseSet(Set<Object> orgIds, Set<Object> warehIds) {
        HashSet<String> result = new HashSet<String>(orgIds.size() * warehIds.size());
        QFilter orgf = new QFilter("org", "in", orgIds);
        QFilter qFilter1 = new QFilter("warehouse", "in", warehIds);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_warehousesetup", (String)"org,warehouse", (QFilter[])new QFilter[]{orgf, qFilter1, qFilter2}, (String)"");
        while (ds.hasNext()) {
            Row row = ds.next();
            result.add(row.getString("org") + "_" + row.getString("warehouse"));
        }
        DataSet whDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_warehouse", (String)"id,entryentity.location", (QFilter[])new QFilter("id", "in", warehIds).toArray(), (String)"");
        while (whDs.hasNext()) {
            Row wh = whDs.next();
            Long whId = wh.getLong("id");
            Long locationId = wh.getLong("entryentity.location");
            if (locationId == 0L) continue;
            Set locationIds = this.whIdToLocationIdsMap.computeIfAbsent(whId, key -> new HashSet());
            locationIds.add(locationId);
        }
        return result;
    }
}

