/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.enums.CalDirectionEnum;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.helper.impt.ImptDataSourceHelper;
import kd.scmc.im.business.helper.impt.ImptValidateHelper;
import kd.scmc.im.business.pojo.GeneralValResultInfo;
import kd.scmc.im.helper.ShelfLifeDateUtil;

public class InvBillImptDetailsValidator
extends AbstractValidator {
    private static final String BILLCRETYPE_IMPORT = "1";
    private Map<Long, Set<Long>> whIdToLocationIdsMap = new HashMap<Long, Set<Long>>(64);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"InvBillImptDetailsValidator", (String)"validate");){
            this.cacheData(this.dataEntities);
            String billType = this.getDataEntities()[0].getDataEntity().getDataEntityType().getName();
            ArrayList<ExtendedDataEntity> imptDataEntities = new ArrayList<ExtendedDataEntity>();
            HashSet<Long> orgIds = new HashSet<Long>(1);
            HashSet<String> billBizTypeKeys = new HashSet<String>();
            HashMap<Long, Long> materialToBaseUnit = new HashMap<Long, Long>(16);
            HashSet<Long> useAuxtyMaterials = new HashSet<Long>();
            HashMap invschemeToBills = new HashMap();
            Boolean isCkSuccess = Boolean.TRUE;
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject org;
                DynamicObject billObj = dataEntity.getDataEntity();
                DynamicObject billtype = billObj.getDynamicObject("billtype");
                String billCreType = billObj.getString("billcretype");
                if (!BILLCRETYPE_IMPORT.equals(billCreType)) continue;
                DynamicObject bizType = billObj.getDynamicObject("biztype");
                Map commentData = (Map)billObj.get("comment");
                GeneralValResultInfo checkCommRes = ImptValidateHelper.checkComment((Map)commentData);
                isCkSuccess = checkCommRes.getIsVaild();
                if (!isCkSuccess.booleanValue()) {
                    String errMsg = checkCommRes.getValResult();
                    this.addErrorMessage(dataEntity, errMsg);
                    continue;
                }
                DynamicObjectCollection billEntrys = billObj.getDynamicObjectCollection("billentry");
                Map<String, Object> checkEntryResult = this.checkBillEntryBasic(dataEntity, billEntrys);
                boolean isSuccess = (Boolean)checkEntryResult.get("isSuccess");
                if (!isSuccess) continue;
                Map materialToBUnit = (Map)checkEntryResult.get("materialToBaseUnit");
                Set useAuxtMaterials = (Set)checkEntryResult.get("useAuxptyMaterials");
                materialToBaseUnit.putAll(materialToBUnit);
                useAuxtyMaterials.addAll(useAuxtMaterials);
                DynamicObject invscheme = billObj.getDynamicObject("invscheme");
                Long billId = billObj.getLong("id");
                if (invscheme != null) {
                    Long invschemeId = invscheme.getLong("id");
                    if (!invschemeToBills.containsKey(invschemeId)) {
                        invschemeToBills.put(invschemeId, new ArrayList());
                    }
                    ((List)invschemeToBills.get(invschemeId)).add(billId);
                }
                if (bizType != null) {
                    Long bizTypeId = bizType.getLong("id");
                    String billBizTypeKey = billType + '.' + bizTypeId;
                    billBizTypeKeys.add(billBizTypeKey);
                }
                Long orgId = (org = billObj.getDynamicObject("org")) == null ? 0L : org.getLong("id");
                orgIds.add(orgId);
                imptDataEntities.add(dataEntity);
            }
            if (imptDataEntities.isEmpty()) {
                return;
            }
            Map billToTransceiver = ImptDataSourceHelper.getBillToTransceiver(invschemeToBills);
            this.checkImptDataDetails(orgIds, imptDataEntities, materialToBaseUnit, useAuxtyMaterials, billBizTypeKeys, billToTransceiver);
        }
    }

    protected void cacheData(ExtendedDataEntity[] dataEntities) {
        this.cacheWhIdToLocationIds(dataEntities);
    }

    private void cacheWhIdToLocationIds(ExtendedDataEntity[] dataEntities) {
        HashSet<Long> whIds = new HashSet<Long>(16);
        String billType = this.getDataEntities()[0].getDataEntity().getDataEntityType().getName();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject billObj = dataEntity.getDataEntity();
            DynamicObjectCollection entries = billObj.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entries) {
                DynamicObject wh = entry.getDynamicObject("warehouse");
                if (wh != null) {
                    whIds.add(wh.getLong("id"));
                }
                if ("im_saloutbill".equals(billType) && (wh = entry.getDynamicObject("inwarehouse")) != null) {
                    whIds.add(wh.getLong("id"));
                }
                if ("im_transoutbill".equals(billType) && (wh = entry.getDynamicObject("inwarehouse")) != null) {
                    whIds.add(wh.getLong("id"));
                }
                if (!"im_invinspectbill".equals(billType)) continue;
                wh = entry.getDynamicObject("outwarehouse");
                if (wh != null) {
                    whIds.add(wh.getLong("id"));
                }
                if ((wh = entry.getDynamicObject("qualifiedwarehouse")) != null) {
                    whIds.add(wh.getLong("id"));
                }
                if ((wh = entry.getDynamicObject("unqualifiedwarehouse")) == null) continue;
                whIds.add(wh.getLong("id"));
            }
        }
        DataSet whDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_warehouse", (String)"id,entryentity.location", (QFilter[])new QFilter("id", "in", whIds).toArray(), (String)"");
        while (whDs.hasNext()) {
            Row wh = whDs.next();
            Long whId = wh.getLong("id");
            Long locationId = wh.getLong("entryentity.location");
            if (locationId == 0L) continue;
            Set locationIds = this.whIdToLocationIdsMap.computeIfAbsent(whId, key -> new HashSet());
            locationIds.add(locationId);
        }
    }

    protected Map<String, Object> checkBillEntryBasic(ExtendedDataEntity dataEntity, DynamicObjectCollection billEntrys) {
        HashMap<String, Object> checkEntryResult = new HashMap<String, Object>(16);
        HashMap<Long, Long> materialToBaseUnit = new HashMap<Long, Long>(16);
        HashSet<Long> useAuxptyMaterials = new HashSet<Long>(16);
        for (DynamicObject entryObj : billEntrys) {
            DynamicObject materialStategy = entryObj.getDynamicObject("material");
            if (materialStategy == null) continue;
            DynamicObject materialObj = materialStategy.getDynamicObject("masterid");
            String materialNum = materialObj.getString("number");
            Long materialId = materialObj.getLong("id");
            boolean isuseauxpty = materialObj.getBoolean("isuseauxpty");
            if (isuseauxpty) {
                DynamicObject auxpty = entryObj.getDynamicObject("auxpty");
                if (auxpty == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u542f\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u586b\u5199\u8f85\u52a9\u5c5e\u6027\u503c\u3002", (String)"InvBillImptDetailsValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), materialNum));
                    checkEntryResult.put("isSuccess", Boolean.FALSE);
                    checkEntryResult.put("materialToBaseUnit", new HashMap(16));
                    checkEntryResult.put("useAuxptyMaterials", new HashSet(16));
                    return checkEntryResult;
                }
                useAuxptyMaterials.add(materialId);
            }
            if (ImptValidateHelper.isEnableLot((DynamicObject)materialStategy)) {
                String lotnmuber = (String)entryObj.get("lotnumber");
                if (!StringUtils.isEmpty((String)lotnmuber) && lotnmuber.length() > 50) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6279\u53f7\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"InvBillImptDetailsValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), new Object[0]));
                    checkEntryResult.put("isSuccess", Boolean.FALSE);
                    checkEntryResult.put("materialToBaseUnit", new HashMap(16));
                    checkEntryResult.put("useAuxptyMaterials", new HashSet(16));
                    return checkEntryResult;
                }
            } else {
                entryObj.set("lotnumber", (Object)"");
            }
            if (ImptValidateHelper.isEnableShelflifeMgr((DynamicObject)materialStategy)) {
                checkEntryResult.putAll(this.shelflifeHandle(dataEntity, entryObj, materialStategy));
                if (!checkEntryResult.isEmpty()) {
                    return checkEntryResult;
                }
            } else {
                entryObj.set("producedate", (Object)"");
                entryObj.set("expirydate", (Object)"");
            }
            Long baseUnitId = materialObj.getLong("baseunit.id");
            materialToBaseUnit.put(materialId, baseUnitId);
        }
        checkEntryResult.put("isSuccess", Boolean.TRUE);
        checkEntryResult.put("materialToBaseUnit", materialToBaseUnit);
        checkEntryResult.put("useAuxptyMaterials", useAuxptyMaterials);
        return checkEntryResult;
    }

    protected boolean checkWarehouse(ExtendedDataEntity dataEntity, DynamicObject entryObj, Set<Long> warehouseIds, DynamicObject warehouse, DynamicObject org) {
        boolean checkWarehouse;
        boolean isInitBill;
        if (warehouse == null) {
            return true;
        }
        Long warehouseId = warehouse.getLong("id");
        String warehouseNum = warehouse.getString("number");
        if (!warehouse.getBoolean("enable") || !"C".equals(warehouse.getString("status"))) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%s\u201d\u4e0d\u53ef\u7528\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u5ba1\u6838\u3002", (String)"InvBillImptDetailsValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), warehouseNum));
            return false;
        }
        String billKey = dataEntity.getDataEntity().getDataEntityType().getName();
        boolean bl = isInitBill = "im_purinbill".equals(billKey) || "im_saloutbill".equals(billKey);
        if (isInitBill) {
            isInitBill = dataEntity.getDataEntity().getBoolean("isinitbill");
        }
        boolean bl2 = checkWarehouse = warehouseIds == null || warehouseIds.isEmpty() || !warehouseIds.contains(warehouseId);
        if (checkWarehouse && !isInitBill) {
            String orgNum = org == null ? null : org.getString("number");
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%1s\u201d\u4e0d\u662f\u5e93\u5b58\u7ec4\u7ec7\u201c%2s\u201d\u4e0b\u5df2\u521d\u59cb\u5316\u7684\u4ed3\u5e93\u3002", (String)"InvBillImptDetailsValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), warehouseNum, orgNum));
            return false;
        }
        return true;
    }

    protected boolean checkByTransceiver(ExtendedDataEntity dataEntity, DynamicObject entryObj, List<Object> accountOwners, String transceiver, String billType) {
        DynamicObject billObj = dataEntity.getDataEntity();
        DynamicObject invType = entryObj.getDynamicObject("invtype");
        DynamicObject invStatus = entryObj.getDynamicObject("invstatus");
        String ownerType = entryObj.getString("ownertype");
        DynamicObject owner = entryObj.getDynamicObject("owner");
        DynamicObject outInvType = entryObj.getDynamicObject("outinvtype");
        DynamicObject outInvStatus = entryObj.getDynamicObject("outinvstatus");
        String outOwnerType = entryObj.getString("outownertype");
        DynamicObject outOwner = entryObj.getDynamicObject("outowner");
        DynamicObject org = billObj.getDynamicObject("org");
        DynamicObject reqOrg = null;
        if ("im_purinbill".equals(billType)) {
            reqOrg = entryObj.getDynamicObject("entryreqorg");
        }
        Boolean isCkSuccess = Boolean.TRUE;
        if ("0".equals(transceiver)) {
            GeneralValResultInfo ckInvTypeRes = ImptValidateHelper.checkInvType((DynamicObject)invType);
            isCkSuccess = ckInvTypeRes.getIsVaild();
            if (!isCkSuccess.booleanValue()) {
                String errMsg = ckInvTypeRes.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                return false;
            }
            GeneralValResultInfo ckInvStatusRes = ImptValidateHelper.checkInvStatus((DynamicObject)invStatus);
            isCkSuccess = ckInvStatusRes.getIsVaild();
            if (!isCkSuccess.booleanValue()) {
                String errMsg = ckInvStatusRes.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                return false;
            }
            GeneralValResultInfo ckOwnerResult = ImptValidateHelper.checkOwner((DynamicObject)billObj, (String)ownerType, (DynamicObject)owner, (DynamicObject)reqOrg, (DynamicObject)org, accountOwners, (String)billType);
            isCkSuccess = ckOwnerResult.getIsVaild();
            if (!isCkSuccess.booleanValue()) {
                String errMsg = ckOwnerResult.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                return false;
            }
        } else if (BILLCRETYPE_IMPORT.equals(transceiver)) {
            GeneralValResultInfo ckOutInvTypeRes = ImptValidateHelper.checkInvType((DynamicObject)outInvType);
            isCkSuccess = ckOutInvTypeRes.getIsVaild();
            if (!isCkSuccess.booleanValue()) {
                String errMsg = ckOutInvTypeRes.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                return false;
            }
            GeneralValResultInfo ckOutInvStatusRes = ImptValidateHelper.checkInvStatus((DynamicObject)outInvStatus);
            isCkSuccess = ckOutInvStatusRes.getIsVaild();
            if (!isCkSuccess.booleanValue()) {
                String errMsg = ckOutInvStatusRes.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                return false;
            }
            GeneralValResultInfo ckOutOwnerRes = ImptValidateHelper.checkOwner((DynamicObject)billObj, (String)outOwnerType, (DynamicObject)outOwner, (DynamicObject)reqOrg, (DynamicObject)org, accountOwners, (String)billType);
            isCkSuccess = ckOutOwnerRes.getIsVaild();
            if (!isCkSuccess.booleanValue()) {
                String errMsg = ckOutOwnerRes.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                return false;
            }
        } else {
            GeneralValResultInfo ckInvTypeRes = ImptValidateHelper.checkInvType((DynamicObject)invType);
            isCkSuccess = ckInvTypeRes.getIsVaild();
            if (!isCkSuccess.booleanValue()) {
                String errMsg = ckInvTypeRes.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                return false;
            }
            GeneralValResultInfo ckInvStatusRes = ImptValidateHelper.checkInvStatus((DynamicObject)invStatus);
            isCkSuccess = ckInvStatusRes.getIsVaild();
            if (!isCkSuccess.booleanValue()) {
                String errMsg = ckInvStatusRes.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                return false;
            }
            GeneralValResultInfo ckOwnerResult = ImptValidateHelper.checkOwner((DynamicObject)billObj, (String)ownerType, (DynamicObject)owner, (DynamicObject)reqOrg, (DynamicObject)org, accountOwners, (String)billType);
            isCkSuccess = ckOwnerResult.getIsVaild();
            if (!isCkSuccess.booleanValue()) {
                String errMsg = ckOwnerResult.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                return false;
            }
            GeneralValResultInfo ckOutInvTypeRes = ImptValidateHelper.checkInvType((DynamicObject)outInvType);
            isCkSuccess = ckOutInvTypeRes.getIsVaild();
            if (!isCkSuccess.booleanValue()) {
                String errMsg = ckOutInvTypeRes.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                return false;
            }
            GeneralValResultInfo ckOutInvStatusRes = ImptValidateHelper.checkInvStatus((DynamicObject)outInvStatus);
            isCkSuccess = ckOutInvStatusRes.getIsVaild();
            if (!isCkSuccess.booleanValue()) {
                String errMsg = ckOutInvStatusRes.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                return false;
            }
            if ("im_transdirbill".equals(billType)) {
                return true;
            }
            GeneralValResultInfo ckOutOwnerRes = ImptValidateHelper.checkOwner((DynamicObject)billObj, (String)outOwnerType, (DynamicObject)outOwner, (DynamicObject)reqOrg, (DynamicObject)org, accountOwners, (String)billType);
            isCkSuccess = ckOutOwnerRes.getIsVaild();
            if (!isCkSuccess.booleanValue()) {
                String errMsg = ckOutOwnerRes.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                return false;
            }
        }
        return true;
    }

    @Deprecated
    protected boolean checkLocationOfWh(ExtendedDataEntity dataEntity, DynamicObject entryObj, DynamicObject warehouse, String outLocation) {
        GeneralValResultInfo checkLocatResult = ImptValidateHelper.checkLocation((DynamicObject)entryObj, (DynamicObject)warehouse, (String)outLocation);
        Boolean isCkSuccess = checkLocatResult.getIsVaild();
        if (!isCkSuccess.booleanValue()) {
            String errMsg = checkLocatResult.getValResult();
            this.addErrorMessage(dataEntity, errMsg);
            return false;
        }
        return true;
    }

    protected boolean checkLocationOfWh(ExtendedDataEntity dataEntity, DynamicObject entryObj, DynamicObject warehouse, String outLocation, Map<Long, Set<Long>> whIdToLocationIdsMap) {
        GeneralValResultInfo checkLocatResult = ImptValidateHelper.checkLocation((DynamicObject)entryObj, (DynamicObject)warehouse, (String)outLocation, whIdToLocationIdsMap);
        Boolean isCkSuccess = checkLocatResult.getIsVaild();
        if (!isCkSuccess.booleanValue()) {
            String errMsg = checkLocatResult.getValResult();
            this.addErrorMessage(dataEntity, errMsg);
            return false;
        }
        return true;
    }

    private void checkImptDataDetails(Set<Long> orgIds, List<ExtendedDataEntity> imptDataEntities, Map<Long, Long> materialToBaseUnit, Set<Long> useAuxtyMaterials, Set<String> billBizTypeKeys, Map<Long, String> billToTransceiver) {
        Map billBizTypeToInvschemes = ImptDataSourceHelper.getBillBizTypeToInvschemes(billBizTypeKeys);
        Map warehouseData = ImptDataSourceHelper.getOrgToWarehouses(orgIds);
        Map materialToUnits = ImptDataSourceHelper.getFixedConvertTypeUnits(materialToBaseUnit);
        Map orgToAccountOwners = ImptDataSourceHelper.getOrgToAccountOwners(orgIds);
        Map proKeyToAuxInfo = ImptDataSourceHelper.getMaterialToAuxptys(useAuxtyMaterials);
        Map materialToAuxptySize = (Map)proKeyToAuxInfo.get("materialToAuxptySize");
        Map materialToAuxSetup = (Map)proKeyToAuxInfo.get("materialToAuxSetup");
        String billType = this.getDataEntities()[0].getDataEntity().getDataEntityType().getName();
        String location = "location.id";
        for (ExtendedDataEntity dataEntity : imptDataEntities) {
            String errMsg;
            GeneralValResultInfo ckInvschemeRes;
            boolean isCkSuccess;
            DynamicObject billObj = dataEntity.getDataEntity();
            Long billId = billObj.getLong("id");
            String transceiver = billToTransceiver.get(billId);
            DynamicObject org = billObj.getDynamicObject("org");
            Long orgId = org == null ? 0L : org.getLong("id");
            Long bizTypeId = billObj.get("biztype") == null ? 0L : billObj.getLong("biztype.id");
            String billBizTypeKey = billType + '.' + bizTypeId;
            List invschemes = (List)billBizTypeToInvschemes.get(billBizTypeKey);
            DynamicObject invscheme = billObj.getDynamicObject("invscheme");
            if (!"im_initbill".equals(billType) && !(isCkSuccess = (ckInvschemeRes = ImptValidateHelper.checkInvschemes((DynamicObject)invscheme, (List)invschemes)).getIsVaild().booleanValue())) {
                errMsg = ckInvschemeRes.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                continue;
            }
            GeneralValResultInfo ckDeptResult = ImptValidateHelper.checkDept((DynamicObject)billObj, null);
            isCkSuccess = ckDeptResult.getIsVaild();
            if (!isCkSuccess) {
                errMsg = ckDeptResult.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                continue;
            }
            Set warehouseIds = (Set)warehouseData.get(orgId);
            Map<String, Object> transParams = this.getTransWarehouseIds(warehouseData, billType, billObj, warehouseIds);
            Set transWarehouseIds = (Set)transParams.get("transWarehouseIds");
            DynamicObject transOrg = (DynamicObject)transParams.get("transOrg");
            List accountOwners = (List)orgToAccountOwners.get(orgId);
            boolean isNext = false;
            DynamicObjectCollection billEntrys = billObj.getDynamicObjectCollection("billentry");
            for (DynamicObject entryObj : billEntrys) {
                DynamicObject inWarehouse;
                DynamicObject materialStategy = entryObj.getDynamicObject("material");
                if (materialStategy == null) continue;
                DynamicObject materialObj = materialStategy.getDynamicObject("masterid");
                Long materialId = materialObj.getLong("id");
                Long unitId = entryObj.get("unit") == null ? 0L : entryObj.getLong("unit.id");
                Set fixedConvUnits = (Set)materialToUnits.get(materialId);
                BigDecimal qty = entryObj.getBigDecimal("qty");
                BigDecimal qtyunit2nd = entryObj.getBigDecimal("qtyunit2nd");
                boolean isBreak = false;
                Map checkAuxResult = ImptValidateHelper.checkAuxpty((DynamicObject)entryObj, (Map)proKeyToAuxInfo, (Map)materialToAuxptySize, (Map)materialToAuxSetup);
                if (!((Boolean)checkAuxResult.get("isSuccess")).booleanValue()) {
                    isBreak = (Boolean)checkAuxResult.get("isPBreak");
                    isNext = (Boolean)checkAuxResult.get("isNext");
                    String errMsg2 = String.valueOf(checkAuxResult.get("errMsg"));
                    this.addErrorMessage(dataEntity, errMsg2);
                }
                if (isBreak) break;
                GeneralValResultInfo checkUnitResult = ImptValidateHelper.checkUnit((Set)fixedConvUnits, (Long)unitId);
                isCkSuccess = checkUnitResult.getIsVaild();
                if (!isCkSuccess) {
                    String errMsg3 = checkUnitResult.getValResult();
                    this.addErrorMessage(dataEntity, errMsg3);
                    isNext = true;
                    break;
                }
                GeneralValResultInfo checkQtyResult = ImptValidateHelper.checkQty((BigDecimal)qty, (BigDecimal)qtyunit2nd);
                isCkSuccess = checkQtyResult.getIsVaild();
                if (!isCkSuccess) {
                    String errMsg4 = checkQtyResult.getValResult();
                    this.addErrorMessage(dataEntity, errMsg4);
                    isNext = true;
                    break;
                }
                isCkSuccess = this.checkByTransceiver(dataEntity, entryObj, accountOwners, transceiver, billType);
                if (!isCkSuccess) {
                    isNext = true;
                    break;
                }
                DynamicObject warehouse = entryObj.getDynamicObject("warehouse");
                isCkSuccess = this.checkWarehouse(dataEntity, entryObj, warehouseIds, warehouse, org);
                if (!isCkSuccess) {
                    isNext = true;
                    break;
                }
                isCkSuccess = this.checkLocationOfWh(dataEntity, entryObj, warehouse, location, this.whIdToLocationIdsMap);
                if (!isCkSuccess) {
                    isNext = true;
                    break;
                }
                if ("im_saloutbill".equals(billType)) {
                    inWarehouse = entryObj.getDynamicObject("inwarehouse");
                    isCkSuccess = this.checkWarehouse(dataEntity, entryObj, warehouseIds, inWarehouse, org);
                    if (!isCkSuccess) {
                        isNext = true;
                        break;
                    }
                    isCkSuccess = this.checkLocationOfWh(dataEntity, entryObj, inWarehouse, "inlocation.id", this.whIdToLocationIdsMap);
                    if (!isCkSuccess) {
                        isNext = true;
                        break;
                    }
                }
                if ("im_transoutbill".equals(billType)) {
                    inWarehouse = entryObj.getDynamicObject("inwarehouse");
                    isCkSuccess = this.checkWarehouse(dataEntity, entryObj, transWarehouseIds, inWarehouse, transOrg);
                    if (!isCkSuccess) {
                        isNext = true;
                        break;
                    }
                    isCkSuccess = this.checkLocationOfWh(dataEntity, entryObj, inWarehouse, "inlocation.id", this.whIdToLocationIdsMap);
                    if (!isCkSuccess) {
                        isNext = true;
                        break;
                    }
                }
                if (!"im_invinspectbill".equals(billType)) continue;
                DynamicObject outWarehouse = entryObj.getDynamicObject("outwarehouse");
                isCkSuccess = this.checkWarehouse(dataEntity, entryObj, warehouseIds, outWarehouse, org);
                if (!isCkSuccess) {
                    isNext = true;
                    break;
                }
                isCkSuccess = this.checkLocationOfWh(dataEntity, entryObj, outWarehouse, "outlocation.id", this.whIdToLocationIdsMap);
                if (!isCkSuccess) {
                    isNext = true;
                    break;
                }
                DynamicObject qualifiedWarehouse = entryObj.getDynamicObject("qualifiedwarehouse");
                isCkSuccess = this.checkWarehouse(dataEntity, entryObj, warehouseIds, qualifiedWarehouse, org);
                if (!isCkSuccess) {
                    isNext = true;
                    break;
                }
                isCkSuccess = this.checkLocationOfWh(dataEntity, entryObj, qualifiedWarehouse, "qualifiedlocation.id", this.whIdToLocationIdsMap);
                if (!isCkSuccess) {
                    isNext = true;
                    break;
                }
                DynamicObject unqQualifiedWarehouse = entryObj.getDynamicObject("unqualifiedwarehouse");
                isCkSuccess = this.checkWarehouse(dataEntity, entryObj, warehouseIds, unqQualifiedWarehouse, org);
                if (!isCkSuccess) {
                    isNext = true;
                    break;
                }
                isCkSuccess = this.checkLocationOfWh(dataEntity, entryObj, unqQualifiedWarehouse, "unqualifiedlocation.id", this.whIdToLocationIdsMap);
                if (isCkSuccess) continue;
                isNext = true;
                break;
            }
            if (!isNext) continue;
        }
    }

    private Map<String, Object> getTransWarehouseIds(Map<Long, Set<Long>> warehouseData, String billType, DynamicObject billObj, Set<Long> warehouseIds) {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        Set<Object> transWarehouseIds = new HashSet(16);
        DynamicObject org = billObj.getDynamicObject("org");
        if ("im_transoutbill".equals(billType)) {
            String transit = billObj.getString("transit");
            if ("B".equals(transit)) {
                DynamicObject inOrg;
                org = inOrg = billObj.getDynamicObject("inorg");
                Long inOrgId = inOrg == null ? 0L : inOrg.getLong("id");
                transWarehouseIds = warehouseData.get(inOrgId);
            } else if ("A".equals(transit)) {
                transWarehouseIds = warehouseIds;
            }
        }
        param.put("transWarehouseIds", transWarehouseIds);
        param.put("transOrg", org);
        return param;
    }

    private Map<String, Object> shelflifeHandle(ExtendedDataEntity dataEntity, DynamicObject entryObj, DynamicObject materialStategy) {
        HashMap<String, Object> checkEntryResult = new HashMap<String, Object>(16);
        DynamicObject materialObj = materialStategy.getDynamicObject("masterid");
        String materialNum = materialObj.getString("number");
        Date producedate = (Date)entryObj.get("producedate");
        Date expirydate = (Date)entryObj.get("expirydate");
        String shelflifeUnit = materialStategy.getString("shelflifeunit");
        String caldirec = materialStategy.getString("caldirection");
        caldirec = StringUtils.isBlank((String)caldirec) ? CalDirectionEnum.CALBOTH.getValue() : caldirec;
        int shelflife = materialStategy.getInt("shelflife");
        String calculationForEndDate = materialStategy.getString("calculationforenddate");
        if (!caldirec.equals(CalDirectionEnum.CALNONE.getValue())) {
            if (caldirec.equals(CalDirectionEnum.CALBOTH.getValue())) {
                if (producedate != null) {
                    Date expiryDate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)shelflife, (Date)producedate, (String)calculationForEndDate);
                    entryObj.set("expirydate", (Object)expiryDate);
                } else if (expirydate != null) {
                    Date produceDate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(-shelflife), (Date)expirydate, (String)calculationForEndDate);
                    entryObj.set("producedate", (Object)produceDate);
                }
            } else if (caldirec.equals(CalDirectionEnum.CALENDDATE.getValue())) {
                if (producedate != null && expirydate == null) {
                    expirydate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)shelflife, (Date)producedate, (String)calculationForEndDate);
                    entryObj.set("expirydate", (Object)expirydate);
                }
            } else if (caldirec.equals(CalDirectionEnum.CALSTARTDATE.getValue()) && expirydate != null && producedate == null) {
                producedate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(-shelflife), (Date)expirydate, (String)calculationForEndDate);
                entryObj.set("producedate", (Object)producedate);
            }
        }
        producedate = (Date)entryObj.get("producedate");
        expirydate = (Date)entryObj.get("expirydate");
        if (producedate != null && expirydate != null && producedate.after(expirydate)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5230\u671f\u65e5\u671f\u3002", (String)"InvBillImptDetailsValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]), new Object[0]));
            checkEntryResult.put("isSuccess", Boolean.FALSE);
            checkEntryResult.put("materialToBaseUnit", new HashMap(16));
            checkEntryResult.put("useAuxptyMaterials", new HashSet(16));
        }
        return checkEntryResult;
    }
}

