/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.im.business.helper.impt.ImptDataSourceHelper;
import kd.scmc.im.business.helper.impt.ImptValidateHelper;
import kd.scmc.im.business.pojo.GeneralValResultInfo;

public class MaterialReqOutImptValidator
extends AbstractValidator {
    private static final String BILLCRETYPE_IMPORT = "1";

    public void validate() {
        HashSet<Long> orgIds = new HashSet<Long>();
        ArrayList<ExtendedDataEntity> imptDataEntities = new ArrayList<ExtendedDataEntity>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject billObj = dataEntity.getDataEntity();
            String billCreType = billObj.getString("billcretype");
            if (!BILLCRETYPE_IMPORT.equals(billCreType)) continue;
            DynamicObject org = billObj.getDynamicObject("org");
            if (org != null) {
                Long orgId = org.getLong("id");
                orgIds.add(orgId);
            }
            imptDataEntities.add(dataEntity);
        }
        if (imptDataEntities.isEmpty()) {
            return;
        }
        Map orgToBizDepts = ImptDataSourceHelper.getOrgToBizDepts(orgIds);
        for (ExtendedDataEntity dataEntity : imptDataEntities) {
            DynamicObject billObj = dataEntity.getDataEntity();
            DynamicObject org = billObj.getDynamicObject("org");
            DynamicObject reqOrg = billObj.getDynamicObject("bizorg");
            Long orgId = org == null ? 0L : org.getLong("id");
            Set bosOrgs = ImptDataSourceHelper.getBosOrgs();
            List bizDeptsOfOrg = (List)orgToBizDepts.get(orgId);
            GeneralValResultInfo ckReqOrgRes = ImptValidateHelper.checkReqOrg((DynamicObject)billObj, (DynamicObject)reqOrg, (Set)bosOrgs);
            Boolean isSuccess = ckReqOrgRes.getIsVaild();
            if (!isSuccess.booleanValue()) {
                String errMsg = ckReqOrgRes.getValResult();
                this.addErrorMessage(dataEntity, errMsg);
                continue;
            }
            GeneralValResultInfo ckBizDeptRes = ImptValidateHelper.checkBizDept((DynamicObject)billObj, (List)bizDeptsOfOrg);
            isSuccess = ckBizDeptRes.getIsVaild();
            if (isSuccess.booleanValue()) continue;
            String errMsg = ckBizDeptRes.getValResult();
            this.addErrorMessage(dataEntity, errMsg);
        }
    }
}

