/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.AuxQtyAndUnitHelper;
import kd.scmc.im.enums.PrecisionAccountEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class TransFormImportHandle {
    private List<String> errorMsg = new ArrayList<String>();
    private Map<Long, List<String>> materialAux = new HashMap<Long, List<String>>();
    private List<String> flexFieldlist = new ArrayList<String>();
    private Map<Long, List<Long>> unitlist = null;
    private Map<Object, DynamicObject> unitsMap = null;
    private Map<String, Map<Integer, Integer>> unitRateConv = new HashMap<String, Map<Integer, Integer>>();

    public TransFormImportHandle(List<DynamicObject> datas) {
        this.initData(datas);
    }

    private void initData(List<DynamicObject> datas) {
        this.beforeHandleBills(datas);
        String formId = null;
        for (DynamicObject data : datas) {
            if (StringUtils.isBlank(formId)) {
                formId = data.getDataEntityType().getName();
            }
            DynamicObject currency = null;
            if ("im_disassemblebill".equals(formId) || "im_assembbill".equals(formId)) {
                currency = data.getDynamicObject("currency");
            }
            DynamicObjectCollection enrtyList = data.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : enrtyList) {
                BigDecimal qty = entry.getBigDecimal("qty");
                if ("im_assembbill".equals(formId) && currency != null) {
                    BigDecimal processingFee = entry.getBigDecimal("processingfee");
                    processingFee = processingFee == null ? BigDecimal.ZERO : processingFee;
                    processingFee = processingFee.setScale(currency.getInt("amtprecision"), 4);
                    entry.set("processingfee", (Object)processingFee);
                }
                this.handleEntry(entry);
                DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("afterentity");
                for (DynamicObject subEntry : subEntrys) {
                    if ("im_disassemblebill".equals(formId) && currency != null) {
                        BigDecimal processingFee = subEntry.getBigDecimal("processingfee");
                        processingFee = processingFee == null ? BigDecimal.ZERO : processingFee;
                        processingFee = processingFee.setScale(currency.getInt("amtprecision"), 4);
                        subEntry.set("processingfee", (Object)processingFee);
                    }
                    if ("im_disassemblebill".equals(formId) || "im_assembbill".equals(formId)) {
                        BigDecimal subQty = subEntry.getBigDecimal("qty1");
                        BigDecimal bigDecimal = subQty = subQty == null ? BigDecimal.ZERO : subQty;
                        if (qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                            subEntry.set("usagerate", (Object)subQty.divide(qty, 10, 4));
                        }
                    }
                    this.handleSubEntry(subEntry);
                }
            }
        }
        this.afterHandleBills(datas);
    }

    private void handleSubEntry(DynamicObject subEntry) {
        this.check2UnitAndQty(subEntry, true);
        this.checkByUnit2nd(subEntry, true);
        this.check4auxpty(subEntry, true);
        this.check4Lot(subEntry, true);
    }

    protected void beforeHandleBills(List<DynamicObject> datas) {
        this.cache2Auxpty(datas);
    }

    protected void handleEntry(DynamicObject entry) {
        this.check2UnitAndQty(entry, false);
        this.checkByUnit2nd(entry, false);
        this.check4auxpty(entry, false);
        this.check4Lot(entry, false);
    }

    protected void afterHandleBills(List<DynamicObject> datas) {
    }

    private void cache2Auxpty(List<DynamicObject> datas) {
        ArrayList<String> auxList = null;
        HashSet<Long> masterIdSet = new HashSet<Long>();
        HashSet<String> keySet = new HashSet<String>();
        ArrayList<Long> materialIds = new ArrayList<Long>();
        HashSet<Long> invUnitIds = new HashSet<Long>(16);
        for (DynamicObject data : datas) {
            DynamicObjectCollection enrtyList = data.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : enrtyList) {
                DynamicObject material;
                DynamicObject materialDym = entry.getDynamicObject("material");
                if (materialDym == null || (material = materialDym.getDynamicObject("masterid")) == null) continue;
                invUnitIds.add(materialDym.getLong("inventoryunit_id"));
                invUnitIds.add(material.getLong("auxptyunit_id"));
                DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("afterentity");
                for (DynamicObject subEntry : subEntrys) {
                    DynamicObject material1;
                    DynamicObject materialDym1 = subEntry.getDynamicObject("material1");
                    if (materialDym1 == null || (material1 = materialDym1.getDynamicObject("masterid")) == null) continue;
                    invUnitIds.add(materialDym1.getLong("inventoryunit_id"));
                    invUnitIds.add(material1.getLong("auxptyunit_id"));
                }
                this.addMaterialIds(masterIdSet, keySet, materialIds, subEntrys, true);
            }
            this.addMaterialIds(masterIdSet, keySet, materialIds, enrtyList, false);
        }
        this.unitlist = AuxQtyAndUnitHelper.getAssistMUListResult(materialIds, (String)"1");
        this.unitsMap = this.cacheUnit(invUnitIds);
        DynamicObjectCollection auxp = QueryServiceHelper.query((String)"bd_auxproperty", (String)"number", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", keySet)});
        auxp.forEach(v -> this.flexFieldlist.add(v.getString("number")));
        if (masterIdSet.size() > 0) {
            DynamicObject[] auxptyV;
            for (DynamicObject aux : auxptyV = BusinessDataServiceHelper.load((String)"bd_auxptyvalue", (String)"entryentity.auxptyvalueid,material", (QFilter[])new QFilter[]{new QFilter("material", "in", masterIdSet), new QFilter("entryentity.isenable", "=", (Object)Boolean.TRUE)})) {
                DynamicObjectCollection col = aux.getDynamicObjectCollection("entryentity");
                Long materialId = aux.getLong("material.id");
                ArrayList<String> auxListValue = this.materialAux.get(materialId);
                auxList = auxListValue != null ? auxListValue : new ArrayList<String>();
                for (DynamicObject colEntry : col) {
                    auxList.add(colEntry.getString("auxptyvalueid"));
                }
                this.materialAux.put(materialId, auxList);
            }
        }
    }

    private Map<Object, DynamicObject> cacheUnit(Set<Long> unitIdSet) {
        if (this.unitlist == null || this.unitlist.isEmpty()) {
            return new HashMap<Object, DynamicObject>(16);
        }
        for (List<Long> unitIds : this.unitlist.values()) {
            unitIdSet.addAll(unitIds);
        }
        if (unitIdSet.isEmpty()) {
            return new HashMap<Object, DynamicObject>(16);
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])unitIdSet.toArray(), (String)"bd_measureunits");
    }

    private void addMaterialIds(Set<Long> masterIdSet, Set<String> keySet, List<Long> materialIds, DynamicObjectCollection enrtyList, boolean isSubEntry) {
        if (enrtyList == null) {
            return;
        }
        String materialKey = isSubEntry ? "material1" : "material";
        String auxptyKey = isSubEntry ? "auxpty1" : "auxpty";
        for (DynamicObject entry : enrtyList) {
            DynamicObject auxpty;
            DynamicObject materialDym = entry.getDynamicObject(materialKey);
            if (materialDym == null) continue;
            long materialId = (Long)materialDym.getDynamicObject("masterid").getPkValue();
            if (!materialIds.contains(materialId)) {
                materialIds.add(materialId);
            }
            if ((auxpty = entry.getDynamicObject(auxptyKey)) == null) continue;
            Map jsonMap = (Map)SerializationUtils.fromJsonString((String)auxpty.getString("value"), Map.class);
            keySet.addAll(jsonMap.keySet());
            if (this.materialAux.containsKey(materialId)) continue;
            masterIdSet.add(materialDym.getLong("masterid.id"));
        }
    }

    public final void check2UnitAndQty(DynamicObject entry, boolean isSubEntry) {
        Map<Integer, Integer> rateMap;
        DynamicObject muConv;
        Long masterMaterialId = 0L;
        String materialKey = isSubEntry ? "material1" : "material";
        String unitKey = isSubEntry ? "unit1" : "unit";
        String masteridKey = isSubEntry ? "materialmasterid1" : "materialmasterid";
        String baseUnitKey = isSubEntry ? "baseunit1" : "baseunit";
        String qtyKey = isSubEntry ? "qty1" : "qty";
        String baseQtyKey = isSubEntry ? "baseqty1" : "baseqty";
        String entryName = entry.getDataEntityType().getDisplayName().getLocaleValue();
        DynamicObject materialDym = entry.getDynamicObject(materialKey);
        if (materialDym == null) {
            return;
        }
        DynamicObject unit = entry.getDynamicObject(unitKey);
        if (unit == null) {
            Long unitId = materialDym.getLong("inventoryunit_id");
            unit = this.unitsMap.get(unitId);
            entry.set(unitKey, (Object)unit);
        }
        DynamicObject masterMaterial = materialDym.getDynamicObject("masterid");
        DynamicObject baseUnit = null;
        if (masterMaterial != null) {
            masterMaterialId = (Long)masterMaterial.getPkValue();
            baseUnit = this.unitsMap.get(masterMaterial.getLong("baseunit_id"));
        }
        entry.set(masteridKey, (Object)masterMaterial);
        if (baseUnit == null) {
            this.errorMsg.add(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL_BASEUNIT(), (Object[])new Object[0]));
            return;
        }
        entry.set(baseUnitKey, baseUnit);
        List<Long> unitIds = this.unitlist.get(masterMaterialId);
        if (unitIds == null || !unitIds.contains(unit.getLong("id"))) {
            String msg = ResManager.loadKDString((String)"{0}\uff1a\u7269\u6599{1}\u5bf9\u5e94\u7684\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5b58\u5728\u3002", (String)"TransFormImportHandle_1", (String)"scmc-im-opplugin", (Object[])new Object[]{entryName, materialDym.getString("masterid.name")});
            this.errorMsg.add(msg);
            return;
        }
        int precision = unit.getInt("precision");
        int basePrecision = baseUnit.getInt("precision");
        String precisionaccountStr = unit.getString("precisionaccount");
        String basePrecisionaccountStr = baseUnit.getString("precisionaccount");
        int precisionaccount = 4;
        int basePrecisionaccount = 4;
        if (!StringUtils.isEmpty((CharSequence)precisionaccountStr)) {
            precisionaccount = Integer.parseInt(precisionaccountStr);
        }
        if (!StringUtils.isEmpty((CharSequence)basePrecisionaccountStr)) {
            basePrecisionaccount = Integer.parseInt(basePrecisionaccountStr);
        }
        BigDecimal qty = entry.getBigDecimal(qtyKey);
        qty = qty.setScale(precision, precisionaccount);
        entry.set(qtyKey, (Object)qty);
        String key = masterMaterial.getPkValue() + "_" + unit.getPkValue() + "_" + baseUnit.getPkValue();
        if (!this.unitRateConv.containsKey(key) && (muConv = BaseDataServiceHelper.getMUConv((Long)((Long)masterMaterial.getPkValue()), (Long)((Long)unit.getPkValue()), (Long)((Long)baseUnit.getPkValue()))) != null && muConv.getInt("numerator") != 0) {
            this.unitRateConv.put(key, Collections.singletonMap(muConv.getInt("numerator"), muConv.getInt("denominator")));
        }
        if ((rateMap = this.unitRateConv.get(key)) == null) {
            this.errorMsg.add(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6216\u7ef4\u62a4\u8ba1\u91cf\u5355\u4f4d\u7684\u6362\u7b97\u7387\u3002", (String)"BillTplImportHandle_2", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            return;
        }
        Map.Entry<Integer, Integer> rateEntry = rateMap.entrySet().iterator().next();
        BigDecimal baseQty = qty.multiply(new BigDecimal(rateEntry.getKey())).divide(new BigDecimal(rateEntry.getValue()), basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePrecisionaccount));
        entry.set(baseQtyKey, (Object)baseQty);
    }

    public List<String> getErrorMsg() {
        return new ArrayList<String>(this.errorMsg);
    }

    public final void checkByUnit2nd(DynamicObject entry, boolean isSubEntry) {
        String materialKey = isSubEntry ? "material1" : "material";
        String unit2ndKey = isSubEntry ? "unit2nd1" : "unit2nd";
        String qtyunit2nd = isSubEntry ? "qtyunit2nd1" : "qtyunit2nd";
        DynamicObject materialInvInfo = entry.getDynamicObject(materialKey);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        DynamicObject auxptyUnit = this.unitsMap.get(material.getLong("auxptyunit_id"));
        Boolean isUseUnit2nd = auxptyUnit != null;
        if (isUseUnit2nd.booleanValue()) {
            entry.set(unit2ndKey, (Object)auxptyUnit);
        } else {
            entry.set(qtyunit2nd, (Object)BigDecimal.ZERO);
            entry.set(unit2ndKey, null);
        }
    }

    public final void check4auxpty(DynamicObject entry, boolean isSubEntry) {
        String materialKey = isSubEntry ? "material1" : "material";
        String auxptyKey = isSubEntry ? "auxpty1" : "auxpty";
        DynamicObject materialDym = entry.getDynamicObject(materialKey);
        DynamicObject auxpty = entry.getDynamicObject(auxptyKey);
        if (materialDym == null || auxpty == null) {
            return;
        }
        Map jsonMap = (Map)SerializationUtils.fromJsonString((String)auxpty.getString("value"), Map.class);
        HashMap auxResult = new HashMap();
        Long masterId = materialDym.getLong("masterid.id");
        ArrayList auxList = this.materialAux.get(masterId);
        ArrayList arrayList = auxList = auxList == null ? new ArrayList() : auxList;
        if (!materialDym.getBoolean("masterid.isuseauxpty")) {
            entry.set(auxptyKey, null);
            return;
        }
        for (Map.Entry next : jsonMap.entrySet()) {
            String auxId = next.getValue().toString();
            for (String aux : auxList) {
                if (!aux.equals(auxId)) continue;
                auxResult.put(next.getKey(), next.getValue());
            }
        }
        Set josnEntrys = jsonMap.entrySet();
        for (Map.Entry josnEntry : josnEntrys) {
            String flexField = (String)josnEntry.getKey();
            if (!this.flexFieldlist.contains(flexField)) continue;
            auxResult.put(flexField, josnEntry.getValue());
            String result = SerializationUtils.toJsonString(auxResult);
            auxpty.set("value", (Object)result);
            break;
        }
    }

    public void check4Lot(DynamicObject entry, boolean isSubEntry) {
        String materialKey = isSubEntry ? "material1" : "material";
        String lotNumKey = isSubEntry ? "lotnumber1" : "lotnumber";
        DynamicObject materialInvInfo = entry.getDynamicObject(materialKey);
        if (materialInvInfo == null) {
            return;
        }
        if (!materialInvInfo.getBoolean("enablelot")) {
            entry.set(lotNumKey, (Object)"");
        }
    }
}

