/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.im.business.helper.NewInvOrgHelper;

public class TransOutImptValidator
extends AbstractValidator {
    private static final String BILLCRETYPE_IMPORT = "1";
    private List<Long> hasPermissionOrgs = new ArrayList<Long>();

    public void validate() {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject inOrg;
            ExtendedDataEntity dataEntity = this.dataEntities[i];
            DynamicObject billObj = dataEntity.getDataEntity();
            String billCreType = billObj.getString("billcretype");
            if (!BILLCRETYPE_IMPORT.equals(billCreType)) continue;
            if (i == 0) {
                RequestContext requestContext = RequestContext.get();
                String currUserId = requestContext.getUserId();
                this.hasPermissionOrgs = TransOutImptValidator.getHasPermissionOrgs("im_transoutbill", this.getValidateContext().getBillEntityType().getAppId()).get(currUserId);
            }
            if (this.hasPermissionOrgs.isEmpty()) continue;
            String transType = billObj.getString("transtype");
            DynamicObject org = billObj.getDynamicObject("org");
            Map<String, Object> checkOrgResult = this.checkOrg(org, inOrg = billObj.getDynamicObject("inorg"), transType);
            boolean isSuccess = (Boolean)checkOrgResult.get("isSuccess");
            if (isSuccess) continue;
            String errMsg = String.valueOf(checkOrgResult.get("errMsg"));
            this.addErrorMessage(dataEntity, errMsg);
        }
    }

    private Map<String, Object> checkOrg(DynamicObject org, DynamicObject inOrg, String transType) {
        HashMap<String, Object> checkResult = new HashMap<String, Object>();
        Long orgId = org.getLong("id");
        Long orgNum = org.getLong("number");
        Long inOrgId = inOrg.getLong("id");
        Long inOrgNum = inOrg.getLong("number");
        if ("A".equals(transType)) {
            if (!orgId.equals(inOrgId)) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5185\u8c03\u62e8\u7684\u51fa\u5e93\u7ec4\u7ec7\u201c%1s\u201d\u5fc5\u987b\u4e0e\u5165\u5e93\u7ec4\u7ec7\u201c%2s\u201d\u4fdd\u6301\u4e00\u81f4\u3002", (String)"TransOutImptValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), orgNum, inOrgNum);
                checkResult.put("isSuccess", Boolean.FALSE);
                checkResult.put("errMsg", errMsg);
                return checkResult;
            }
        } else {
            if (orgId.equals(inOrgId)) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5185\u8c03\u62e8\u7684\u51fa\u5e93\u7ec4\u7ec7\u201c%1s\u201d\u4e0e\u5165\u5e93\u7ec4\u7ec7\u201c%2s\u201d\u4e0d\u80fd\u76f8\u540c\u3002", (String)"TransOutImptValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), orgNum, inOrgNum);
                checkResult.put("isSuccess", Boolean.FALSE);
                checkResult.put("errMsg", errMsg);
                return checkResult;
            }
            ArrayList<Long> inCrossOrgs = new ArrayList<Long>();
            for (Long pOrgId : this.hasPermissionOrgs) {
                if (pOrgId.equals(orgId)) continue;
                inCrossOrgs.add(pOrgId);
            }
            if (!inCrossOrgs.contains(inOrgId)) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u8de8\u7ec4\u7ec7\u8c03\u62e8\u65f6\u5165\u5e93\u7ec4\u7ec7%s\u8f93\u5165\u6709\u8bef\uff0c\u8bf7\u8f93\u5165\u4e0e\u51fa\u5e93\u7ec4\u7ec7\u4e0d\u540c\u4e14\u6709\u6743\u9650\u7684\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"TransOutImptValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), orgNum, inOrgNum);
                checkResult.put("isSuccess", Boolean.FALSE);
                checkResult.put("errMsg", errMsg);
                return checkResult;
            }
        }
        checkResult.put("isSuccess", Boolean.TRUE);
        return checkResult;
    }

    public static Map<String, List<Long>> getHasPermissionOrgs(String formId, String appId) {
        RequestContext requestContext = RequestContext.get();
        String currUserId = requestContext.getUserId();
        HashMap<String, List<Long>> userToPermissOrgs = new HashMap<String, List<Long>>();
        List hasPermissionOrgs = NewInvOrgHelper.getHasPermissionAndStartedInvOrg((String)formId, (String)appId);
        if (hasPermissionOrgs == null || hasPermissionOrgs.isEmpty()) {
            return new HashMap<String, List<Long>>();
        }
        for (Map orgData : hasPermissionOrgs) {
            if (!userToPermissOrgs.containsKey(currUserId)) {
                userToPermissOrgs.put(currUserId, new ArrayList(10));
            }
            Long pOrgId = Long.valueOf((String)orgData.get("id"));
            ((List)userToPermissOrgs.get(currUserId)).add(pOrgId);
        }
        return userToPermissOrgs;
    }
}

