/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt.count;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.enums.UnitConvertDirEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.im.business.helper.importdata.ImptDataSourceHelper;
import kd.scmc.im.business.helper.importdata.ImptValidateHelper;
import kd.scmc.im.business.pojo.ValidateResult;
import kd.scmc.im.business.pojo.ValidateResultCollection;
import kd.scmc.im.enums.PrecisionAccountEnum;
import kd.scmc.im.utils.IMStringUtils;

public class InvCountImptValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(InvCountImptValidator.class);
    private Map<String, Map<Integer, Integer>> unitRateConv = new HashMap<String, Map<Integer, Integer>>(16);
    private Map<String, Map<Long, Set<Long>>> orgOperatorGroupMapping = new HashMap<String, Map<Long, Set<Long>>>(16);
    private Map<Long, List<Long>> orgDeptMapping;
    private Set<Long> orgIds = new HashSet<Long>(16);
    private static final String BILLCRETYPE_IMPORT = "1";
    private static final String operatorGrpType = "KCZ";
    protected static final List<String> removeList = Arrays.asList("qtyunit2nd", "checkqtyunit2nd", "qty2ndacc", "adjustqtyunit2nd", "gainqty2nd", "lossqty2nd");
    protected static final List<String> removeCheckQtyList = Arrays.asList("checkqty", "checkbaseqty", "checkqtyunit2nd");

    public void validate() {
        ValidateResultCollection validateResults = new ValidateResultCollection();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject billObj = dataEntity.getDataEntity();
            String billCreType = billObj.getString("billcretype");
            if (!BILLCRETYPE_IMPORT.equals(billCreType)) continue;
            this.cacheOrgIds(billObj);
            this.checkHeader(billObj, validateResults);
            this.reloadBill(billObj, validateResults);
            ValidateResult validateResult = validateResults.getValidateResult(billObj.getPkValue().toString());
            if (validateResult.getIsVaild().booleanValue()) continue;
            this.addErrorMessage(dataEntity, validateResult.getValResults().toString());
            return;
        }
    }

    private void reloadBill(DynamicObject billObj, ValidateResultCollection validateResults) {
        Object id = billObj.getPkValue();
        DynamicObject invcountBill = BusinessDataServiceHelper.loadSingle((Object)id, (String)"im_invcountbill");
        Boolean enableCheck = (Boolean)invcountBill.get("enablecheck");
        DynamicObjectCollection loadEntrys = invcountBill.getDynamicObjectCollection("billentry");
        DynamicObjectCollection modelEntrys = billObj.getDynamicObjectCollection("billentry");
        int resetEntrySize = loadEntrys.size() > modelEntrys.size() ? modelEntrys.size() : loadEntrys.size();
        for (int i = 0; i < resetEntrySize; ++i) {
            DynamicObject modelEntry = (DynamicObject)modelEntrys.get(i);
            DynamicObject loadEntry = (DynamicObject)loadEntrys.get(i);
            this.checkEntry(billObj, modelEntry, validateResults);
            this.checkEntryDate(billObj, modelEntry, validateResults);
            this.checkLoadConfigCodeAndTrackNum(billObj, loadEntry, modelEntry, validateResults);
            this.handleGainAndLoseQty(loadEntry, modelEntry, enableCheck);
            this.removeQty2nd(modelEntry, enableCheck);
        }
    }

    private void removeQty2nd(DynamicObject loadEntry, boolean enableCheck) {
        DynamicObject materialInvInfo = loadEntry.getDynamicObject("material");
        DynamicObject material = MaterialHelper.getMaterialByMatBiz((DynamicObject)materialInvInfo);
        if (material == null) {
            return;
        }
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        if (auxptyUnit == null) {
            for (String field : removeList) {
                loadEntry.set(field, null);
            }
        }
        if (!enableCheck) {
            for (String field : removeCheckQtyList) {
                loadEntry.set(field, null);
            }
        }
    }

    private void handleGainAndLoseQty(DynamicObject loadEntry, DynamicObject entryObj, Boolean enableCheck) {
        DynamicObject materialInvInfo = loadEntry.getDynamicObject("material");
        DynamicObject material = MaterialHelper.getMaterialByMatBiz((DynamicObject)materialInvInfo);
        if (material == null) {
            return;
        }
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        DynamicObject unit = loadEntry.getDynamicObject("unit");
        String unitConvertDir = material.getString("unitconvertdir");
        DynamicObject baseunit = loadEntry.getDynamicObject("baseunit");
        if (baseunit == null) {
            baseunit = material.getDynamicObject("baseunit");
        }
        int basePrecision = baseunit.getInt("precision");
        int basePreAccount = baseunit.getInt("precisionaccount");
        Long materialId = (Long)material.getPkValue();
        Long unitId = unit == null ? null : (Long)unit.getPkValue();
        Long baseUnitId = (Long)baseunit.getPkValue();
        Map<Integer, Integer> unitRate = this.getUnitRate(materialId, unitId, baseUnitId);
        if (unit == null) {
            unit = materialInvInfo.getDynamicObject("inventoryunit");
            entryObj.set("unit", (Object)unit);
        }
        BigDecimal qty = (BigDecimal)entryObj.get("qty");
        BigDecimal qtyunit2nd = (BigDecimal)entryObj.get("qtyunit2nd");
        BigDecimal checkqty = (BigDecimal)entryObj.get("checkqty");
        BigDecimal checkqtyunit2nd = (BigDecimal)entryObj.get("checkqtyunit2nd");
        if (this.qtyIsNull(qty) && this.qtyIsNull(qtyunit2nd) && this.qtyIsNull(checkqty) && this.qtyIsNull(checkqtyunit2nd)) {
            this.changeGainAndLossQtly(qty, entryObj, "qtyacc", "gainqty", "lossqty", "adjustqty", "checkqty", enableCheck, loadEntry);
            this.changeGainAndLossQtly(BigDecimal.ZERO, entryObj, "baseqtyacc", "basegainqty", "baselossqty", "adjustbaseqty", "checkbaseqty", enableCheck, loadEntry);
            if (auxptyUnit != null) {
                this.changeGainAndLossQtly(qtyunit2nd, entryObj, "qty2ndacc", "gainqty2nd", "lossqty2nd", "adjustqtyunit2nd", "checkqtyunit2nd", enableCheck, loadEntry);
            }
            return;
        }
        if (!(this.qtyIsNull(qty) || this.qtyIsNull(qtyunit2nd) || this.qtyIsNull(checkqty) || this.qtyIsNull(checkqtyunit2nd))) {
            if (unitRate != null) {
                Map.Entry<Integer, Integer> rateEntry = unitRate.entrySet().iterator().next();
                BigDecimal rateKey = new BigDecimal(rateEntry.getKey());
                BigDecimal rateVal = new BigDecimal(rateEntry.getValue());
                BigDecimal baseQty = qty.multiply(rateKey).divide(rateVal, basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePreAccount));
                entryObj.set("baseqty", (Object)baseQty);
                BigDecimal checkBaseqty = checkqty.multiply(new BigDecimal(rateEntry.getKey())).divide(new BigDecimal(rateEntry.getValue()), basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePreAccount));
                entryObj.set("checkbaseqty", (Object)checkBaseqty);
            }
            this.changeGainAndLossQtly(qty, entryObj, "qtyacc", "gainqty", "lossqty", "adjustqty", "checkqty", enableCheck, loadEntry);
            this.changeGainAndLossQtly(entryObj.getBigDecimal("baseqty"), entryObj, "baseqtyacc", "basegainqty", "baselossqty", "adjustbaseqty", "checkbaseqty", enableCheck, loadEntry);
            if (auxptyUnit != null) {
                this.changeGainAndLossQtly(qtyunit2nd, entryObj, "qty2ndacc", "gainqty2nd", "lossqty2nd", "adjustqtyunit2nd", "checkqtyunit2nd", enableCheck, loadEntry);
            }
            return;
        }
        if (!this.qtyIsNull(qty) || !this.qtyIsNull(qtyunit2nd)) {
            if (!this.qtyIsNull(qty)) {
                this.qtyChanged(entryObj, unitConvertDir, enableCheck, loadEntry, false);
                this.handleCheckQty(checkqty, checkqtyunit2nd, entryObj, unitConvertDir, enableCheck, loadEntry);
            } else {
                this.qty2ndChanged(entryObj, unitConvertDir, enableCheck, loadEntry);
                this.handleCheckQty(checkqty, checkqtyunit2nd, entryObj, unitConvertDir, enableCheck, loadEntry);
            }
        } else {
            if (!enableCheck.booleanValue()) {
                return;
            }
            if (!this.qtyIsNull(checkqty) && !this.qtyIsNull(checkqtyunit2nd)) {
                this.changeGainAndLossQtly(qty, entryObj, "qtyacc", "gainqty", "lossqty", "adjustqty", "checkqty", enableCheck, loadEntry);
                if (unitRate != null) {
                    Map.Entry<Integer, Integer> rateEntry = unitRate.entrySet().iterator().next();
                    BigDecimal rateKey = new BigDecimal(rateEntry.getKey());
                    BigDecimal rateVal = new BigDecimal(rateEntry.getValue());
                    BigDecimal baseQty = qty.multiply(rateKey).divide(rateVal, basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePreAccount));
                    entryObj.set("baseqty", (Object)baseQty);
                    BigDecimal checkBaseqty = checkqty.multiply(rateKey).divide(rateVal, basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePreAccount));
                    entryObj.set("checkbaseqty", (Object)checkBaseqty);
                }
                this.changeGainAndLossQtly(entryObj.getBigDecimal("baseqty"), entryObj, "baseqtyacc", "basegainqty", "baselossqty", "adjustbaseqty", "checkbaseqty", enableCheck, loadEntry);
                if (auxptyUnit != null) {
                    this.changeGainAndLossQtly(qtyunit2nd, entryObj, "qty2ndacc", "gainqty2nd", "lossqty2nd", "adjustqtyunit2nd", "checkqtyunit2nd", enableCheck, loadEntry);
                }
            } else if (!this.qtyIsNull(checkqty)) {
                this.calCheck2ndQty(entryObj, unitConvertDir, enableCheck, loadEntry);
            } else {
                this.calCheckQty(entryObj, unitConvertDir, enableCheck, loadEntry);
            }
        }
    }

    private void handleCheckQty(BigDecimal checkqty, BigDecimal checkqtyunit2nd, DynamicObject entryObj, String unitConvertDir, Boolean enableCheck, DynamicObject loadEntry) {
        if (enableCheck.booleanValue()) {
            if (!this.qtyIsNull(checkqty) && !this.qtyIsNull(checkqtyunit2nd)) {
                return;
            }
            if (!this.qtyIsNull(checkqty)) {
                this.calCheck2ndQty(entryObj, unitConvertDir, enableCheck, loadEntry);
            } else {
                this.calCheckQty(entryObj, unitConvertDir, enableCheck, loadEntry);
            }
        }
    }

    private boolean qtyIsNull(BigDecimal qty) {
        return qty.compareTo(BigDecimal.ZERO) == 0;
    }

    private void calCheckQty(DynamicObject entryObj, String unitConvertDir, boolean enableCheck, DynamicObject loadEntry) {
        boolean isConvert2nd;
        DynamicObject material = loadEntry.getDynamicObject("material.masterid");
        DynamicObject unit = loadEntry.getDynamicObject("unit");
        DynamicObject unit2nd = loadEntry.getDynamicObject("unit2nd");
        DynamicObject baseunit = material.getDynamicObject("baseunit");
        int basePrecision = baseunit.getInt("precision");
        int basePreAccount = baseunit.getInt("precisionaccount");
        Long materialId = (Long)material.getPkValue();
        Long unitId = unit == null ? null : (Long)unit.getPkValue();
        Long baseUnitId = (Long)baseunit.getPkValue();
        Long unit2ndId = unit2nd == null ? null : (Long)unit2nd.getPkValue();
        Map<Integer, Integer> unitRate = this.getUnitRate(materialId, unitId, baseUnitId);
        Map<Integer, Integer> baseUnit2ndRate = this.getUnitRate(materialId, unit2ndId, baseUnitId);
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        BigDecimal checkqtyunit2nd = entryObj.getBigDecimal("checkqtyunit2nd");
        BigDecimal qtyunit2nd = entryObj.getBigDecimal("qtyunit2nd");
        if (auxptyUnit != null) {
            this.changeGainAndLossQtly(qtyunit2nd, entryObj, "qty2ndacc", "gainqty2nd", "lossqty2nd", "adjustqtyunit2nd", "checkqtyunit2nd", enableCheck, loadEntry);
        }
        boolean bl = isConvert2nd = UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
        if (isConvert2nd) {
            if (baseUnit2ndRate != null) {
                Map.Entry<Integer, Integer> rateEntry = baseUnit2ndRate.entrySet().iterator().next();
                entryObj.set("checkbaseqty", (Object)checkqtyunit2nd.multiply(new BigDecimal(rateEntry.getKey())).divide(new BigDecimal(rateEntry.getValue()), basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePreAccount)));
            }
            BigDecimal checkbaseqty = entryObj.getBigDecimal("checkbaseqty");
            entryObj.set("checkbaseqty", (Object)checkbaseqty);
            BigDecimal baseqty = entryObj.getBigDecimal("baseqty");
            this.changeGainAndLossQtly(baseqty, entryObj, "baseqtyacc", "basegainqty", "baselossqty", "adjustbaseqty", "checkbaseqty", enableCheck, loadEntry);
            if (unitRate == null || checkbaseqty.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            Map.Entry<Integer, Integer> rateEntry = unitRate.entrySet().iterator().next();
            BigDecimal checkqty = checkbaseqty.multiply(new BigDecimal(rateEntry.getValue())).divide(new BigDecimal(rateEntry.getKey()), unit.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)unit.getInt("precisionaccount")));
            entryObj.set("checkqty", (Object)checkqty);
            BigDecimal qty = (BigDecimal)entryObj.get("qty");
            this.changeGainAndLossQtly(qty, entryObj, "qtyacc", "gainqty", "lossqty", "adjustqty", "checkqty", enableCheck, loadEntry);
        }
    }

    private void calCheck2ndQty(DynamicObject entryObj, String unitConvertDir, boolean enableCheck, DynamicObject loadEntry) {
        boolean isConvert;
        DynamicObject material = loadEntry.getDynamicObject("material.masterid");
        DynamicObject unit = loadEntry.getDynamicObject("unit");
        DynamicObject unit2nd = loadEntry.getDynamicObject("unit2nd");
        DynamicObject baseunit = material.getDynamicObject("baseunit");
        int basePrecision = baseunit.getInt("precision");
        int basePreAccount = baseunit.getInt("precisionaccount");
        Long materialId = (Long)material.getPkValue();
        Long unitId = unit == null ? null : (Long)unit.getPkValue();
        Long baseUnitId = (Long)baseunit.getPkValue();
        Long unit2ndId = unit2nd == null ? null : (Long)unit2nd.getPkValue();
        Map<Integer, Integer> unitRate = this.getUnitRate(materialId, unitId, baseUnitId);
        Map<Integer, Integer> unitUnit2ndRate = this.getUnitRate(materialId, unitId, unit2ndId);
        BigDecimal checkqty = (BigDecimal)entryObj.get("checkqty");
        if (!this.qtyIsNull(checkqty) && enableCheck && unitRate != null) {
            Map.Entry<Integer, Integer> rateEntry = unitRate.entrySet().iterator().next();
            entryObj.set("checkbaseqty", (Object)checkqty.multiply(new BigDecimal(rateEntry.getKey())).divide(new BigDecimal(rateEntry.getValue()), basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePreAccount)));
        }
        BigDecimal qty = (BigDecimal)entryObj.get("qty");
        this.changeGainAndLossQtly(qty, entryObj, "qtyacc", "gainqty", "lossqty", "adjustqty", "checkqty", enableCheck, loadEntry);
        if (unitRate != null) {
            Map.Entry<Integer, Integer> rateEntry = unitRate.entrySet().iterator().next();
            entryObj.set("baseqty", (Object)qty.multiply(new BigDecimal(rateEntry.getKey())).divide(new BigDecimal(rateEntry.getValue()), basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePreAccount)));
        }
        this.changeGainAndLossQtly(entryObj.getBigDecimal("baseqty"), entryObj, "baseqtyacc", "basegainqty", "baselossqty", "adjustbaseqty", "checkbaseqty", enableCheck, loadEntry);
        boolean bl = isConvert = UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
        if (isConvert) {
            BigDecimal checkqtyunit2nd = (BigDecimal)entryObj.get("checkqtyunit2nd");
            if (!this.qtyIsNull(checkqty) && this.qtyIsNull(checkqtyunit2nd) && enableCheck && unitUnit2ndRate != null) {
                Map.Entry<Integer, Integer> rateEntry = unitUnit2ndRate.entrySet().iterator().next();
                entryObj.set("checkqtyunit2nd", (Object)checkqty.multiply(new BigDecimal(rateEntry.getKey())).divide(new BigDecimal(rateEntry.getValue()), unit2nd.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)unit2nd.getInt("precisionaccount"))));
            }
            BigDecimal qtyunit2nd = (BigDecimal)entryObj.get("qtyunit2nd");
            this.changeGainAndLossQtly(qtyunit2nd, entryObj, "qty2ndacc", "gainqty2nd", "lossqty2nd", "adjustqtyunit2nd", "checkqtyunit2nd", enableCheck, loadEntry);
        }
    }

    private void qty2ndChanged(DynamicObject entryObj, String unitConvertDir, boolean enableCheck, DynamicObject loadEntry) {
        boolean isConvert2nd;
        DynamicObject material = loadEntry.getDynamicObject("material.masterid");
        DynamicObject unit = loadEntry.getDynamicObject("unit");
        DynamicObject unit2nd = loadEntry.getDynamicObject("unit2nd");
        DynamicObject baseunit = material.getDynamicObject("baseunit");
        int basePrecision = baseunit.getInt("precision");
        int basePreAccount = baseunit.getInt("precisionaccount");
        Long materialId = (Long)material.getPkValue();
        Long unitId = unit == null ? null : (Long)unit.getPkValue();
        Long baseUnitId = (Long)baseunit.getPkValue();
        Long unit2ndId = unit2nd == null ? null : (Long)unit2nd.getPkValue();
        Map<Integer, Integer> unitRate = this.getUnitRate(materialId, unitId, baseUnitId);
        Map<Integer, Integer> baseUnit2ndRate = this.getUnitRate(materialId, unit2ndId, baseUnitId);
        BigDecimal qtyunit2nd = entryObj.getBigDecimal("qtyunit2nd");
        this.changeGainAndLossQtly(qtyunit2nd, entryObj, "qty2ndacc", "gainqty2nd", "lossqty2nd", "adjustqtyunit2nd", "checkqtyunit2nd", enableCheck, loadEntry);
        boolean bl = isConvert2nd = UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
        if (isConvert2nd) {
            BigDecimal baseQty = loadEntry.getBigDecimal("baseqty");
            if (baseUnit2ndRate != null) {
                Map.Entry<Integer, Integer> rateEntry = baseUnit2ndRate.entrySet().iterator().next();
                baseQty = qtyunit2nd.multiply(new BigDecimal(rateEntry.getKey())).divide(new BigDecimal(rateEntry.getValue()), basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePreAccount));
                entryObj.set("baseqty", (Object)baseQty);
            }
            if (unitRate == null || baseQty.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            Map.Entry<Integer, Integer> unitRateEntry = unitRate.entrySet().iterator().next();
            BigDecimal qty = baseQty.multiply(new BigDecimal(unitRateEntry.getValue())).divide(new BigDecimal(unitRateEntry.getKey()), unit.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)unit.getInt("precisionaccount")));
            entryObj.set("qty", (Object)qty);
            this.qtyChanged(entryObj, unitConvertDir, enableCheck, loadEntry, true);
        } else {
            this.changeGainAndLossQtly(BigDecimal.ZERO, entryObj, "qtyacc", "gainqty", "lossqty", "adjustqty", "checkqty", enableCheck, loadEntry);
            this.changeGainAndLossQtly(BigDecimal.ZERO, entryObj, "baseqtyacc", "basegainqty", "baselossqty", "adjustbaseqty", "checkbaseqty", enableCheck, loadEntry);
        }
    }

    private void qtyChanged(DynamicObject entryObj, String unitConvertDir, boolean enableCheck, DynamicObject loadEntry, Boolean fromQty2ndChanged) {
        Map.Entry<Integer, Integer> rateEntry;
        boolean isConvert;
        DynamicObject material = loadEntry.getDynamicObject("material.masterid");
        DynamicObject unit = loadEntry.getDynamicObject("unit");
        DynamicObject unit2nd = material.getDynamicObject("auxptyunit");
        DynamicObject baseunit = material.getDynamicObject("baseunit");
        int basePrecision = baseunit.getInt("precision");
        int basePreAccount = baseunit.getInt("precisionaccount");
        Long materialId = (Long)material.getPkValue();
        Long unitId = unit == null ? null : (Long)unit.getPkValue();
        Long baseUnitId = (Long)baseunit.getPkValue();
        Long unit2ndId = unit2nd == null ? null : (Long)unit2nd.getPkValue();
        Map<Integer, Integer> unitRate = this.getUnitRate(materialId, unitId, baseUnitId);
        Map<Integer, Integer> unitUnit2ndRate = this.getUnitRate(materialId, unitId, unit2ndId);
        BigDecimal qty = entryObj.getBigDecimal("qty");
        BigDecimal baseQty = entryObj.getBigDecimal("baseqty");
        BigDecimal checkqty = entryObj.getBigDecimal("checkqty");
        BigDecimal qtyunit2nd = entryObj.getBigDecimal("qtyunit2nd");
        BigDecimal checkqtyunit2nd = entryObj.getBigDecimal("checkqtyunit2nd");
        boolean bl = isConvert = UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
        if (unitRate != null) {
            rateEntry = unitRate.entrySet().iterator().next();
            BigDecimal rateKey = new BigDecimal(rateEntry.getKey());
            BigDecimal rateVal = new BigDecimal(rateEntry.getValue());
            baseQty = qty.multiply(rateKey).divide(rateVal, basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePreAccount));
            entryObj.set("baseqty", (Object)baseQty);
            if (enableCheck) {
                BigDecimal checkBaseqty = checkqty.multiply(new BigDecimal(rateEntry.getKey())).divide(new BigDecimal(rateEntry.getValue()), basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePreAccount));
                entryObj.set("checkbaseqty", (Object)checkBaseqty);
            }
        }
        this.changeGainAndLossQtly(qty, entryObj, "qtyacc", "gainqty", "lossqty", "adjustqty", "checkqty", enableCheck, loadEntry);
        if (isConvert && !fromQty2ndChanged.booleanValue()) {
            if (this.qtyIsNull(qtyunit2nd)) {
                if (unitUnit2ndRate != null) {
                    rateEntry = unitUnit2ndRate.entrySet().iterator().next();
                    qtyunit2nd = qty.multiply(new BigDecimal(rateEntry.getKey())).divide(new BigDecimal(rateEntry.getValue()), basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePreAccount));
                }
                entryObj.set("qtyunit2nd", (Object)qtyunit2nd);
            }
            if (this.qtyIsNull(checkqtyunit2nd) && enableCheck) {
                if (unitUnit2ndRate != null) {
                    rateEntry = unitUnit2ndRate.entrySet().iterator().next();
                    checkqtyunit2nd = checkqty.multiply(new BigDecimal(rateEntry.getKey())).divide(new BigDecimal(rateEntry.getValue()), basePrecision, PrecisionAccountEnum.getEnumByVal((int)basePreAccount));
                }
                entryObj.set("checkqtyunit2nd", (Object)checkqtyunit2nd);
            }
            this.changeGainAndLossQtly(qtyunit2nd, entryObj, "qty2ndacc", "gainqty2nd", "lossqty2nd", "adjustqtyunit2nd", "checkqtyunit2nd", enableCheck, loadEntry);
        }
        this.changeGainAndLossQtly(baseQty, entryObj, "baseqtyacc", "basegainqty", "baselossqty", "adjustbaseqty", "checkbaseqty", enableCheck, loadEntry);
    }

    private void changeGainAndLossQtly(BigDecimal newValue, DynamicObject entryObj, String accField, String gainField, String lossField, String adjustField, String checkField, Boolean enablecheck, DynamicObject loadEntry) {
        BigDecimal gainQty = BigDecimal.ZERO;
        BigDecimal lossQty = BigDecimal.ZERO;
        BigDecimal checkqty = (BigDecimal)entryObj.get(checkField);
        BigDecimal adjustqty = (BigDecimal)loadEntry.get(adjustField);
        BigDecimal acc = (BigDecimal)loadEntry.get(accField);
        BigDecimal countAcc = acc.add(adjustqty);
        if (enablecheck.booleanValue()) {
            newValue = checkqty;
        }
        gainQty = lossQty = newValue.subtract(acc).subtract(adjustqty);
        if (newValue.compareTo(BigDecimal.ZERO) >= 0 && countAcc.compareTo(BigDecimal.ZERO) < 0) {
            entryObj.set(gainField, (Object)gainQty);
            entryObj.set(lossField, (Object)BigDecimal.ZERO);
        }
        if (newValue.compareTo(countAcc) >= 0 && countAcc.compareTo(BigDecimal.ZERO) >= 0) {
            entryObj.set(gainField, (Object)gainQty);
            entryObj.set(lossField, (Object)BigDecimal.ZERO);
        }
        if (newValue.compareTo(countAcc) < 0 && countAcc.compareTo(BigDecimal.ZERO) >= 0) {
            entryObj.set(gainField, (Object)BigDecimal.ZERO);
            entryObj.set(lossField, (Object)lossQty.abs());
        }
    }

    private void checkHeader(DynamicObject billObj, ValidateResultCollection validateResults) {
        this.checkOperator(billObj, validateResults);
        this.checkChecker(billObj, validateResults, "checker");
        this.checkChecker(billObj, validateResults, "checker2nd");
        this.checkDept(billObj, validateResults);
        this.checkComment(billObj, validateResults);
    }

    private void checkEntry(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
        this.checkEntryNumeric(billObj, entryObj, validateResults);
    }

    private void checkEntryNumeric(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
        String billId = String.valueOf(billObj.getPkValue());
        this.checkQty(entryObj, billId, validateResults);
        this.checkQty2nd(entryObj, billId, validateResults);
    }

    private void checkLoadConfigCodeAndTrackNum(DynamicObject billObj, DynamicObject loadEntry, DynamicObject modelEntry, ValidateResultCollection validateResults) {
        String billId = String.valueOf(billObj.getPkValue());
        DynamicObject loadConfiguredCode = loadEntry.getDynamicObject("configuredcode");
        DynamicObject loadTrackNumber = loadEntry.getDynamicObject("tracknumber");
        DynamicObject modelConfiguredCode = modelEntry.getDynamicObject("configuredcode");
        DynamicObject modelTrackNumber = modelEntry.getDynamicObject("tracknumber");
        if (loadConfiguredCode != modelConfiguredCode || loadTrackNumber != modelTrackNumber) {
            ValidateResult validateResult = new ValidateResult();
            String errMsg = ResManager.loadKDString((String)"\u4ec5\u624b\u5de5\u65b0\u589e\u884c\u5141\u8bb8\u201c\u8ddf\u8e2a\u53f7\u201d\u3001\u201c\u914d\u7f6e\u53f7\u201d\u5b57\u6bb5\u5bfc\u5165\u3002", (String)"InvCountImptValidator_8", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            validateResult.setErrValResult(errMsg);
            validateResults.addValidateResult(billId, validateResult);
        }
    }

    protected void checkQty(DynamicObject entryObj, String billId, ValidateResultCollection validateResults) {
        BigDecimal qty = (BigDecimal)entryObj.get("qty");
        BigDecimal qtyunit2nd = (BigDecimal)entryObj.get("qtyunit2nd");
        ValidateResult validateResult = ImptValidateHelper.checkQty((BigDecimal)qty, (BigDecimal)qtyunit2nd);
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkQty2nd(DynamicObject entryObj, String billId, ValidateResultCollection validateResults) {
        BigDecimal checkqty = (BigDecimal)entryObj.get("checkqty");
        BigDecimal checkqtyunit2nd = (BigDecimal)entryObj.get("checkqtyunit2nd");
        ValidateResult validateResult = InvCountImptValidator.checkQty2nd(checkqty, checkqtyunit2nd);
        validateResults.addValidateResult(billId, validateResult);
    }

    public static ValidateResult checkQty2nd(BigDecimal checkqty, BigDecimal checkqtyunit2nd) {
        ValidateResult valResultInfo = new ValidateResult();
        BigDecimal maxValue = new BigDecimal("9999999999999");
        if (maxValue.compareTo(checkqty) < 0 || BigDecimal.ZERO.compareTo(checkqty) > 0) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u590d\u76d8\u6570\u91cf\uff1a0\u2264\u590d\u76d8\u6570\u91cf\u22649999999999999\u3002", (String)"InvCountImptValidator_17", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
            return valResultInfo;
        }
        if (maxValue.compareTo(checkqtyunit2nd) < 0 || BigDecimal.ZERO.compareTo(checkqtyunit2nd) > 0) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u590d\u76d8\u8f85\u52a9\u6570\u91cf\uff1a0\u2264\u590d\u76d8\u8f85\u52a9\u6570\u91cf\u22649999999999999\u3002", (String)"InvCountImptValidator_18", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    protected void checkOperator(DynamicObject billObj, ValidateResultCollection validateResults) {
        DynamicObject org = billObj.getDynamicObject("org");
        if (org == null) {
            return;
        }
        long orgId = org.getLong("id");
        Map<Long, Set<Long>> operatorGroupMapping = this.getOrgOperatorGroupMapping(orgId, operatorGrpType);
        ValidateResult validateResult = ImptValidateHelper.checkOperator((String)operatorGrpType, (DynamicObject)billObj, operatorGroupMapping);
        String billId = String.valueOf(billObj.getLong("id"));
        validateResults.addValidateResult(billId, validateResult);
    }

    protected void checkChecker(DynamicObject billObj, ValidateResultCollection validateResults, String checkerString) {
        boolean checkOperator;
        String billId = String.valueOf(billObj.getLong("id"));
        Boolean enableCheck = (Boolean)billObj.get("enablecheck");
        DynamicObject operator = billObj.getDynamicObject(checkerString);
        boolean bl = checkOperator = enableCheck == false && checkerString.equals("checker2nd");
        if (operator == null || checkOperator) {
            return;
        }
        boolean valid = (Boolean)operator.get("invalid");
        String opergrptype = (String)operator.get("opergrptype");
        if (valid || !opergrptype.equals(operatorGrpType)) {
            ValidateResult validateResult = new ValidateResult();
            String msg = ResManager.loadKDString((String)"\u76d8\u70b9\u4eba\u5931\u6548\u6216\u8005\u6240\u5c5e\u4e1a\u52a1\u7ec4\u7c7b\u578b\u4e0d\u662f\u5e93\u7ba1\u7ec4\u3002", (String)"InvCountImptValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            if (checkerString.equals("checker2nd")) {
                msg = ResManager.loadKDString((String)"\u590d\u76d8\u4eba\u5931\u6548\u6216\u6240\u5c5e\u4e1a\u52a1\u7ec4\u7c7b\u578b\u4e0d\u662f\u5e93\u7ba1\u7ec4\u3002", (String)"InvCountImptValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            }
            validateResult.setErrValResult(msg);
            validateResults.addValidateResult(billId, validateResult);
        }
    }

    public Map<Long, Set<Long>> getOrgOperatorGroupMapping(Long orgId, String operatorGrpType) {
        String key = orgId + "_" + operatorGrpType;
        if (this.orgOperatorGroupMapping.get(key) == null) {
            Map orgToOperatorGroup = ImptDataSourceHelper.getOrgToOperatorGroup((Long)orgId, (String)operatorGrpType);
            this.orgOperatorGroupMapping.put(key, orgToOperatorGroup);
            this.orgOperatorGroupMapping.putIfAbsent(key, orgToOperatorGroup);
        }
        return this.orgOperatorGroupMapping.get(key);
    }

    protected void checkDept(DynamicObject billObj, ValidateResultCollection validateResults) {
        DynamicObject org = billObj.getDynamicObject("org");
        if (org == null) {
            return;
        }
        List<Long> invDepts = this.getOrgDeptMapping().get((Long)org.getPkValue());
        ValidateResult validateResult = ImptValidateHelper.checkDept((DynamicObject)billObj, invDepts);
        String billId = String.valueOf(billObj.getPkValue());
        validateResults.addValidateResult(billId, validateResult);
    }

    public Map<Long, List<Long>> getOrgDeptMapping() {
        if (this.orgDeptMapping == null) {
            this.orgDeptMapping = ImptDataSourceHelper.getOrgToDepts1(this.orgIds);
        }
        return this.orgDeptMapping;
    }

    protected void cacheOrgIds(DynamicObject billObj) {
        DynamicObject org = billObj.getDynamicObject("org");
        if (org != null) {
            this.orgIds.add((Long)org.getPkValue());
        }
    }

    protected void checkComment(DynamicObject billObj, ValidateResultCollection validateResults) {
        String billId = String.valueOf(billObj.getPkValue());
        Map commentData = (Map)billObj.get("comment");
        this.checkCommentData(billId, validateResults, commentData);
    }

    private void checkCommentData(String billId, ValidateResultCollection validateResults, Map<String, String> commentData) {
        if (commentData == null || commentData.isEmpty()) {
            return;
        }
        ValidateResult valCommRes = ImptValidateHelper.checkComment(commentData);
        if (!valCommRes.getIsVaild().booleanValue()) {
            validateResults.addValidateResult(billId, valCommRes);
        }
    }

    protected void checkEntryDate(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
        String billId = String.valueOf(billObj.getLong("id"));
        this.checkProduceDateAndExpiryDate(entryObj, billId, validateResults);
    }

    protected void checkProduceDateAndExpiryDate(DynamicObject entryObj, String billId, ValidateResultCollection validateResults) {
        DynamicObject materialInfo = entryObj.getDynamicObject("material");
        if (materialInfo == null) {
            return;
        }
        ValidateResult validateResult = ImptValidateHelper.checkProduceDateAndExpiryDate((DynamicObject)entryObj);
        validateResults.addValidateResult(billId, validateResult);
    }

    private Map<Integer, Integer> getUnitRate(Long materialId, Long unitId, Long baseUnitId) {
        DynamicObject muConv;
        if (materialId == null || unitId == null || baseUnitId == null) {
            return null;
        }
        String key = IMStringUtils.append((String)"", (Object[])new Object[]{materialId, "_", unitId, "_", baseUnitId});
        if (!this.unitRateConv.containsKey(key) && (muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)unitId, (Long)baseUnitId)) != null && muConv.getInt("numerator") != 0) {
            this.unitRateConv.put(key, Collections.singletonMap(muConv.getInt("numerator"), muConv.getInt("denominator")));
        }
        return this.unitRateConv.get(key);
    }
}

