/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt.invbiz.ininv;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.im.business.helper.importdata.ImptValidateHelper;
import kd.scmc.im.business.pojo.ValidateResult;
import kd.scmc.im.business.pojo.ValidateResultCollection;
import kd.scmc.im.validator.improt.invbiz.ininv.InvInTplImptValidator;

public class OtherInImptValidator
extends InvInTplImptValidator {
    @Override
    protected void checkF7(DynamicObject billObj, ValidateResultCollection validateResults) {
        super.checkF7(billObj, validateResults);
        this.checkbizDeptByOrg(billObj, validateResults, "org", "bizdept");
    }

    @Override
    protected void cacheHeadData(DynamicObject billObj) {
        super.cacheHeadData(billObj);
        this.getPurOrgIds().add(billObj.getLong("org_id"));
    }

    private void checkbizDeptByOrg(DynamicObject billObj, ValidateResultCollection validateResults, String purOrgKey, String purDeptKey) {
        DynamicObject org = billObj.getDynamicObject(purOrgKey);
        if (org == null) {
            return;
        }
        List<Long> invDepts = this.getPurOrgBizDeptMapping().get((Long)org.getPkValue());
        ValidateResult validateResult = ImptValidateHelper.checkbizDept(invDepts, (DynamicObject)billObj.getDynamicObject(purOrgKey), (DynamicObject)billObj.getDynamicObject(purDeptKey));
        String billId = String.valueOf(billObj.getPkValue());
        validateResults.addValidateResult(billId, validateResult);
    }

    @Override
    protected void checkEntryNumeric(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
        String billId = String.valueOf(billObj.getLong("id"));
        this.checkQty(entryObj, billId, validateResults);
    }
}

