/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.improt.invbiz.ininv;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.importdata.ImptDataSourceHelper;
import kd.scmc.im.business.helper.importdata.ImptValidateHelper;
import kd.scmc.im.business.pojo.ValidateResult;
import kd.scmc.im.business.pojo.ValidateResultCollection;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.enums.EnableStatusEnum;
import kd.scmc.im.validator.improt.invbiz.ininv.InvInTplImptValidator;

public class PurInImptValidator
extends InvInTplImptValidator {
    private Set<Long> providerSupplierIds = new HashSet<Long>(16);
    private Map<Object, Object> purOrgToReqOrgMapping = new HashMap<Object, Object>(16);
    private Map<Long, Long> purOrgToSettleOrgMapping = new HashMap<Long, Long>(16);
    private Map<Object, DynamicObject> cacheProviderLinkMan = new HashMap<Object, DynamicObject>(16);
    private Map<Long, DynamicObject> bosOrgMap = new HashMap<Long, DynamicObject>(16);
    private Map<Object, Set<Long>> orgToSettleOrgMap;
    private Map<Long, Set<Long>> whIdToLocationIdsMap = new HashMap<Long, Set<Long>>(64);

    public void cacheOrgToSettleOrgMap() {
        this.orgToSettleOrgMap = ImptDataSourceHelper.getOrgToSettleOrgs(this.getOrgIds());
    }

    public Set<Long> getOrgToSettleOrgMap(Long orgId) {
        Set<Long> result = new HashSet<Long>(16);
        if (this.orgToSettleOrgMap != null) {
            result = this.orgToSettleOrgMap.get(orgId);
        }
        return result;
    }

    public DynamicObject getBosOrgMap(Long id) {
        DynamicObject bosOrg;
        if (this.bosOrgMap.containsKey(id)) {
            bosOrg = this.bosOrgMap.get(id);
        } else {
            bosOrg = ImptDataSourceHelper.getBosOrgs((Long)id);
            this.bosOrgMap.put(id, bosOrg);
        }
        return bosOrg;
    }

    protected void cacheProviderSupplierIds(DynamicObject entryObj) {
        DynamicObject providerSupplier = entryObj.getDynamicObject("providersupplier");
        if (providerSupplier != null) {
            this.providerSupplierIds.add((Long)providerSupplier.getPkValue());
        }
    }

    protected Map<Object, Object> getPurOrgToReqOrgMapping() {
        if (this.purOrgToReqOrgMapping.isEmpty()) {
            this.purOrgToReqOrgMapping = ImptDataSourceHelper.getPurToReqOrgs1(this.getPurOrgIds());
        }
        return this.purOrgToReqOrgMapping;
    }

    protected Long getPurOrgToSettleOrgMapping(Long id) {
        Long orgId;
        if (this.purOrgToSettleOrgMapping.containsKey(id)) {
            orgId = this.purOrgToSettleOrgMapping.get(id);
        } else {
            orgId = ImptDataSourceHelper.getCompanyByOrg((Long)id);
            this.purOrgToSettleOrgMapping.put(id, orgId);
        }
        return orgId;
    }

    protected Map<Object, DynamicObject> getCacheProviderLinkMan() {
        if (this.cacheProviderLinkMan.isEmpty()) {
            this.cacheProviderLinkMan = ImptDataSourceHelper.cacheProviderLinkMan(this.providerSupplierIds);
        }
        return this.cacheProviderLinkMan;
    }

    @Override
    protected void cacheData(ExtendedDataEntity[] dataEntities) {
        super.cacheData(dataEntities);
        this.cacheOrgToSettleOrgMap();
        this.cacheSettleCurrency();
        this.cacheExratetable();
        this.cacheOrgAndSupIds(dataEntities);
        List<DynamicObject> bills = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity()).collect(Collectors.toList());
        this.cacheOrgWarehouseMap(bills, "warehouse", "outwarehouse");
        this.cacheWhIdToLocationIds(dataEntities);
    }

    @Override
    protected void cacheHeadData(DynamicObject billObj) {
        this.cacheOrgIds(billObj);
        this.cacheBillBizTypeKeys(billObj);
        this.cachePurOrgIds(billObj, "bizorg");
    }

    @Override
    protected void cacheEntryData(DynamicObject billObj, DynamicObject entryObj) {
        super.cacheEntryData(billObj, entryObj);
        this.cacheAuxtyMaterials(entryObj);
        this.cacheMlToBaseUnit(entryObj);
        this.cacheProviderSupplierIds(entryObj);
    }

    private void cacheWhIdToLocationIds(ExtendedDataEntity[] dataEntities) {
        HashSet<Long> whIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject billObj = dataEntity.getDataEntity();
            DynamicObjectCollection entries = billObj.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entries) {
                DynamicObject wh = entry.getDynamicObject("warehouse");
                if (wh != null) {
                    whIds.add(wh.getLong("id"));
                }
                if ((wh = entry.getDynamicObject("outwarehouse")) == null) continue;
                whIds.add(wh.getLong("id"));
            }
        }
        DataSet whDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_warehouse", (String)"id,entryentity.location", (QFilter[])new QFilter("id", "in", whIds).toArray(), (String)"");
        while (whDs.hasNext()) {
            Row wh = whDs.next();
            Long whId = wh.getLong("id");
            Long locationId = wh.getLong("entryentity.location");
            if (locationId == 0L) continue;
            Set locationIds = this.whIdToLocationIdsMap.computeIfAbsent(whId, key -> new HashSet());
            locationIds.add(locationId);
        }
    }

    @Override
    protected void checkF7(DynamicObject billObj, ValidateResultCollection validateResults) {
        super.checkF7(billObj, validateResults);
        this.checkInvschemes(billObj, validateResults);
        this.checkBizOrg(billObj, validateResults);
        this.checkPurDept(billObj, validateResults, "bizorg", "bizdept");
        this.checkOperator("CGZ", billObj, validateResults);
        this.checkDept(billObj, validateResults);
        this.checkOperator("KCZ", billObj, validateResults);
        this.checkSupplier(billObj, validateResults);
        this.checkSettleType(billObj, validateResults);
        this.checkPayCondition(billObj, validateResults);
        this.checkTransactePath(billObj, validateResults);
    }

    private void checkTransactePath(DynamicObject billObj, ValidateResultCollection validateResults) {
        DynamicObject transactePath = billObj.getDynamicObject("transactepath");
        if (transactePath == null) {
            return;
        }
        String status = transactePath.getString("status");
        String enable = transactePath.getString("enable");
        if (!"C".equals(status) || EnableStatusEnum.DISABLE.getValue().equals(enable)) {
            ValidateResult valResultInfo = new ValidateResult();
            String errMsg = ResManager.loadKDString((String)"\u4ea4\u6613\u8def\u5f84\u5df2\u7981\u7528\u3002", (String)"PurInImptValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
            String billId = String.valueOf(billObj.getPkValue());
            validateResults.addValidateResult(billId, valResultInfo);
        }
    }

    @Override
    public void checkText(DynamicObject billObj, ValidateResultCollection validateResults) {
        String billId = String.valueOf(billObj.getPkValue());
        this.checkComment(billObj, billId, validateResults);
    }

    @Override
    protected void checkEntryF7(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
        super.checkEntryF7(billObj, entryObj, validateResults);
        String billId = String.valueOf(billObj.getLong("id"));
        this.checkMaterialInfo(entryObj, billId, validateResults);
        this.checkMaterialBusinessControl(billObj, entryObj, billId, validateResults, "material", "biztype");
        this.checkAuxpty(entryObj, billId, validateResults);
        this.checkUnit(entryObj, billId, validateResults);
        this.checkWarehouse(billObj, entryObj, validateResults, "warehouse");
        this.checkLocation(entryObj, billId, validateResults, "warehouse", "location", this.whIdToLocationIdsMap);
        this.checkWarehouse(billObj, entryObj, validateResults, "outwarehouse");
        this.checkLocation(entryObj, billId, validateResults, "outwarehouse", "outlocation", this.whIdToLocationIdsMap);
        this.checkEntryReqOrg(billObj, entryObj, validateResults, "bizorg", "entryreqorg");
        this.checkInvTypeOwner(billObj, entryObj, validateResults);
        this.checkEntrySettleOrg(billObj, entryObj, validateResults, "bizorg", "entrysettleorg");
        this.checkProject(entryObj, billId, validateResults);
        this.checkTaxRateId(billObj, entryObj, billId, validateResults);
        this.checkPrice(entryObj, billId, validateResults);
        this.checkPriceAndTax(entryObj, billId, validateResults);
        this.checkEnableSupplier(billObj, entryObj, "providersupplier", validateResults);
        this.checkEnableSupplier(billObj, entryObj, "invoicesupplier", validateResults);
        this.checkEnableSupplier(billObj, entryObj, "receivesupplier", validateResults);
        this.checkProviderLinkMan(billObj, entryObj, validateResults);
    }

    private void checkEnableSupplier(DynamicObject billObj, DynamicObject entryObj, String key, ValidateResultCollection validateResults) {
        DynamicObject entrySupplier = entryObj.getDynamicObject(key);
        if (entrySupplier == null) {
            String bizFunction;
            DynamicObject dyObject = billObj.getDynamicObject("supplier");
            if (dyObject == null) {
                return;
            }
            String string = bizFunction = dyObject.get("bizfunction") == null ? "" : dyObject.get("bizfunction").toString();
            if ("providersupplier".equals(key)) {
                Object object = entrySupplier = bizFunction.contains("1") ? dyObject : null;
            }
            if ("invoicesupplier".equals(key)) {
                entrySupplier = dyObject.getDynamicObject("invoicesupplierid");
                Object object = entrySupplier == null ? (bizFunction.contains("2") ? dyObject : null) : (entrySupplier = entrySupplier);
            }
            if ("receivesupplier".equals(key)) {
                entrySupplier = dyObject.getDynamicObject("receivingsupplierid");
                Object object = entrySupplier == null ? (bizFunction.contains("3") ? dyObject : null) : (entrySupplier = entrySupplier);
            }
        }
        if (entrySupplier == null) {
            return;
        }
        DynamicObject org = billObj.getDynamicObject("org");
        Long orgId = (Long)org.getPkValue();
        Long supplierId = (Long)entrySupplier.getPkValue();
        List<Object> supplierIds = this.getSupplierMaps(orgId, supplierId);
        String billId = String.valueOf(billObj.getPkValue());
        ValidateResult validateResult = ImptValidateHelper.checkEnableSupplier((DynamicObject)entrySupplier, (String)key, supplierIds);
        validateResults.addValidateResult(billId, validateResult);
    }

    private void checkProviderLinkMan(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
        DynamicObject providerLinkMan = entryObj.getDynamicObject("providerlinkman");
        if (providerLinkMan == null) {
            return;
        }
        Object linkManPk = providerLinkMan.getPkValue();
        Map<Object, DynamicObject> linkManMap = this.getCacheProviderLinkMan();
        DynamicObject linkMan = linkManMap.get(linkManPk);
        if (linkMan == null) {
            return;
        }
        Object supplierId = linkMan.get("supplierid");
        DynamicObject providerSupplier = entryObj.getDynamicObject("providersupplier");
        if (providerSupplier == null) {
            return;
        }
        Object providersupplierId = providerSupplier.getPkValue();
        if (!supplierId.equals(providersupplierId)) {
            ValidateResult valResultInfo = new ValidateResult();
            String errMsg = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4e0d\u662f\u4f9b\u8d27\u4f9b\u5e94\u5546\u4e2d\u53ef\u7528\u7684\u8054\u7cfb\u4eba\u3002", (String)"PurInImptValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
            String billId = String.valueOf(billObj.getPkValue());
            validateResults.addValidateResult(billId, valResultInfo);
        }
    }

    @Override
    protected void checkEntryText(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
        String billId = String.valueOf(billObj.getLong("id"));
        this.checkProviderAddress(entryObj, billId, validateResults);
    }

    @Override
    protected void checkEntryNumeric(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
        String billId = String.valueOf(billObj.getLong("id"));
        this.checkQty(entryObj, billId, validateResults);
        this.checkDiscountRate(billObj, entryObj, billId, validateResults);
        this.checkDeductibleRate(billObj, entryObj, billId, validateResults);
    }

    private void checkDeductibleRate(DynamicObject billObj, DynamicObject entryObj, String billId, ValidateResultCollection validateResults) {
        BigDecimal deductibleRate = entryObj.getBigDecimal("deductiblerate");
        if (deductibleRate == null) {
            return;
        }
        if (deductibleRate.compareTo(BigDecimalConstants.ONEHUNDRED) > 0) {
            ValidateResult validateResult = new ValidateResult();
            String errMsg = ResManager.loadKDString((String)"\u53ef\u62b5\u6263\u7387(%)\u4e0d\u80fd\u8d85\u8fc7100%\u3002", (String)"PurInImptValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            validateResult.setErrValResult(errMsg);
            validateResults.addValidateResult(billId, validateResult);
        }
    }

    @Override
    protected void checkEntryDate(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults) {
        String billId = String.valueOf(billObj.getLong("id"));
        this.checkProduceDateAndExpiryDate(entryObj, billId, validateResults);
    }

    @Override
    protected ValidateResult checkAccOwner(boolean isInUpdate, DynamicObject org, DynamicObject entryObj, DynamicObject owner, String ownerType) {
        ValidateResult valResultInfo = new ValidateResult();
        if (owner == null) {
            return valResultInfo;
        }
        String ownerNum = owner.getString("number");
        Long ownerPk = (Long)owner.getPkValue();
        DynamicObject reqOrg = entryObj.getDynamicObject("entryreqorg");
        String reqOrgNum = reqOrg.getString("number");
        String orgNum = org.getString("number");
        Long accOrg = this.getPurOrgToSettleOrgMapping((Long)reqOrg.getPkValue());
        Long orgPk = (Long)org.getPkValue();
        Set<Long> orgIds = this.getOrgToSettleOrgMap(orgPk);
        orgIds.add(accOrg);
        if (!orgIds.contains(ownerPk)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1s\u201d\u548c\u9700\u6c42\u7ec4\u7ec7\u201c%2s\u201d\u4e0b\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%3s\u201d\u7684\u6838\u7b97\u7ec4\u7ec7\u7c7b\u578b\u8d27\u4e3b\uff0c\u8bf7\u68c0\u67e5\u8be5\u8d27\u4e3b\u6570\u636e\u3002", (String)"PurInImptValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), orgNum, reqOrgNum, ownerNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    private void checkEntryReqOrg(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults, String purOrgKey, String reqOrgKey) {
        DynamicObject reqOrg = entryObj.getDynamicObject(reqOrgKey);
        DynamicObject purOrg = billObj.getDynamicObject(purOrgKey);
        String billId = String.valueOf(billObj.getPkValue());
        if (purOrg == null) {
            String srcSystem = entryObj.getString("srcsystem");
            if ("EAS".equals(srcSystem)) {
                return;
            }
            ValidateResult valResultInfo = new ValidateResult();
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u91c7\u8d2d\u7ec4\u7ec7", (String)"PurInImptValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
            validateResults.addValidateResult(billId, valResultInfo);
            return;
        }
        Object purOrgPk = purOrg.getPkValue();
        Map<Object, Object> purOrgToReqOrgs = this.getPurOrgToReqOrgMapping();
        if (reqOrg == null) {
            boolean tag = (Boolean)purOrgToReqOrgs.get(purOrgPk + "_tag");
            if (tag) {
                List orgids = (List)purOrgToReqOrgs.get(purOrgPk);
                DynamicObject org = this.getBosOrgMap((Long)orgids.get(0));
                entryObj.set(reqOrgKey, (Object)org);
            } else {
                entryObj.set(reqOrgKey, (Object)purOrg);
            }
            return;
        }
        ValidateResult validateResult = ImptValidateHelper.checkEntryReqOrg((DynamicObject)billObj, (DynamicObject)entryObj, purOrgToReqOrgs, (String)purOrgKey, (String)reqOrgKey);
        validateResults.addValidateResult(billId, validateResult);
    }

    private void checkProviderAddress(DynamicObject entryObj, String billId, ValidateResultCollection validateResults) {
        String address = entryObj.getString("provideraddress");
        if (address != null && address.length() > 300) {
            ValidateResult valResultInfo = new ValidateResult();
            String errMsg = ResManager.loadKDString((String)"\u4f9b\u8d27\u5730\u5740\u4e0d\u80fd\u8d85\u8fc7300\u4e2a\u5b57\u7b26\u3002", (String)"PurInImptValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
            validateResults.addValidateResult(billId, valResultInfo);
        }
    }

    private void checkEntrySettleOrg(DynamicObject billObj, DynamicObject entryObj, ValidateResultCollection validateResults, String purOrgKey, String settleOrgKey) {
        DynamicObject settleOrg = entryObj.getDynamicObject(settleOrgKey);
        DynamicObject purOrg = billObj.getDynamicObject(purOrgKey);
        if (purOrg == null) {
            String srcSystem = entryObj.getString("srcsystem");
            if ("EAS".equals(srcSystem)) {
                return;
            }
            String billId = String.valueOf(billObj.getPkValue());
            ValidateResult valResultInfo = new ValidateResult();
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u91c7\u8d2d\u7ec4\u7ec7", (String)"PurInImptValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
            validateResults.addValidateResult(billId, valResultInfo);
            return;
        }
        Object purOrgPk = purOrg.getPkValue();
        if (settleOrg == null) {
            Long settleOrgPk = this.getPurOrgToSettleOrgMapping((Long)purOrgPk);
            if (settleOrgPk == null) {
                ValidateResult valResultInfo = new ValidateResult();
                String orgNum = purOrg.getString("number");
                String errMsg = String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u201c%s\u201d\u4e0b\u65e0\u6838\u7b97\u4e3b\u4f53\u3002", (String)"PurInImptValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0]), orgNum);
                valResultInfo.setErrValResult(errMsg);
                String billId = String.valueOf(billObj.getPkValue());
                validateResults.addValidateResult(billId, valResultInfo);
                return;
            }
            entryObj.set(settleOrgKey, (Object)this.getBosOrgMap(settleOrgPk));
        }
    }
}

