/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.inbill;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OsPurInBillUnAuditValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("billentry.seq");
        return preparePropertys;
    }

    public void validate() {
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject billObj = dataEntity.getDataEntity();
            DynamicObjectCollection entires = billObj.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entires) {
                Long entryId = entry.getLong("id");
                entryIds.add(entryId);
            }
        }
        HashSet<Long> hasRecordEntryIds = new HashSet<Long>(16);
        QFilter recordFilter = new QFilter("entry.billentryid", "in", entryIds);
        recordFilter.and("writeofftypeid", "=", (Object)1450063878372197376L);
        DynamicObjectCollection records = QueryServiceHelper.query((String)"im_oswfrecord", (String)"entry.billid, entry.billentryid", (QFilter[])recordFilter.toArray());
        for (DynamicObject record : records) {
            hasRecordEntryIds.add(record.getLong("entry.billentryid"));
        }
        if (hasRecordEntryIds.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject billObj = dataEntity.getDataEntity();
            DynamicObjectCollection entires = billObj.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entires) {
                Long entryId = entry.getLong("id");
                if (!hasRecordEntryIds.contains(entryId)) continue;
                String tipMsg = ResManager.loadKDString((String)"\u5355\u53f7%1$s\uff0c\u7b2c%2$s\u884c\u5206\u5f55\uff0c\u5df2\u59d4\u5916\u6838\u9500\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002\u8bf7\u5148\u53cd\u5ba1\u6838\u59d4\u5916\u91c7\u8d2d\u5165\u5e93\u5355\u540e\u91cd\u8bd5\u3002", (String)"IM-E-205863", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, String.format(tipMsg, dataEntity.getBillNo(), entry.getInt("seq")));
            }
        }
    }
}

