/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.inbill;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.utils.IMStringUtils;

public class PurInBillSaveValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(PurInBillSaveValidator.class);

    public void validate() {
        HashMap<Long, Map<String, Object>> bizOrgMapChace = new HashMap<Long, Map<String, Object>>(512);
        boolean hasBizOrg = false;
        boolean hasCheckBizOrg = false;
        boolean hasEntryReqOrg = false;
        boolean hasCheckEntryReqOrg = false;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bizOrg;
            DynamicObject entity = dataEntity.getDataEntity();
            if (!hasCheckBizOrg) {
                hasBizOrg = MetaDataHelper.isExistField((IDataEntityType)((MainEntityType)entity.getDataEntityType()), (String)"bizorg");
                hasCheckBizOrg = true;
            }
            if (hasBizOrg && (bizOrg = dataEntity.getDataEntity().getDynamicObject("bizorg")) != null) {
                Map bizOrgMap;
                Long pkValue = (Long)bizOrg.getPkValue();
                if (!bizOrgMapChace.containsKey(pkValue)) {
                    bizOrgMapChace.put(pkValue, this.getCompanyByOrg(pkValue));
                }
                if ((bizOrgMap = (Map)bizOrgMapChace.get(pkValue)) == null || bizOrgMap.isEmpty()) {
                    this.addMessage(dataEntity, IMStringUtils.append((String)ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7 ", (String)"PurInBillSaveValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{bizOrg.getString("name"), ResManager.loadKDString((String)"\u672a\u627e\u5230\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"PurInBillSaveValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0])}), ErrorLevel.FatalError);
                }
            }
            DynamicObjectCollection entrys = entity.getDynamicObjectCollection("billentry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entryReqOrg;
                Map orgMap = null;
                if (!hasCheckEntryReqOrg) {
                    hasEntryReqOrg = MetaDataHelper.isExistField((MainEntityType)((MainEntityType)entity.getDataEntityType()), (String)"billentry", (String)"entryreqorg");
                    hasCheckEntryReqOrg = true;
                }
                if (!hasEntryReqOrg || (entryReqOrg = ((DynamicObject)entrys.get(i)).getDynamicObject("entryreqorg")) == null) continue;
                Long pkValue = (Long)entryReqOrg.getPkValue();
                if (!bizOrgMapChace.containsKey(pkValue)) {
                    bizOrgMapChace.put(pkValue, this.getCompanyByOrg(pkValue));
                }
                if ((orgMap = (Map)bizOrgMapChace.get(pkValue)) != null && !orgMap.isEmpty()) continue;
                this.addMessage(dataEntity, IMStringUtils.append((String)ResManager.loadKDString((String)"\u7b2c", (String)"PurInBillSaveValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{i + 1, ResManager.loadKDString((String)"\u884c\u5206\u5f55\u4e2d\u7684\u9700\u6c42\u7ec4\u7ec7 ", (String)"PurInBillSaveValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), entryReqOrg.getString("name"), ResManager.loadKDString((String)"\u672a\u627e\u5230\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"PurInBillSaveValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0])}), ErrorLevel.FatalError);
            }
        }
    }

    protected Map<String, Object> getCompanyByOrg(Long bizOrgId) {
        Map bizOrgMap = OrgUnitServiceHelper.getCompanyByOrg((Long)bizOrgId, (Boolean)false, (Boolean)true);
        return bizOrgMap;
    }
}

