/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.inspect;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.im.consts.InvInspectBillConst;

public class InvInspectBillPushValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set fields = super.preparePropertys();
        fields.add("biztype");
        fields.add("invscheme");
        fields.add("billstatus");
        fields.add("billentry.qualifiedinvbaseqty");
        fields.add("billentry.qualifiedbaseqty");
        fields.add("billentry.unqualifiedbaseqty");
        fields.add("billentry.qualremaininvbaseqty");
        fields.add("billentry.unqualremaininvbaseqty");
        return fields;
    }

    public void validate() {
        String operateKey = this.getOperateKey();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if ("inspectionrelease".equals(operateKey)) {
                this.checkReleaseBaseQty(dataEntity);
                continue;
            }
            if ("waitauditadjustbill".equals(operateKey)) {
                this.checkWaitAuditAdjustBill(dataEntity);
                continue;
            }
            if (!"customer_return".equals(operateKey)) continue;
            this.checkReturnBaseQty(dataEntity);
        }
    }

    private void checkReturnBaseQty(ExtendedDataEntity dataEntity) {
        BigDecimal qualifiedInvBaseQty;
        DynamicObject inspectObj = dataEntity.getDataEntity();
        DynamicObject bizTypeObj = inspectObj.getDynamicObject("biztype");
        String billStatus = inspectObj.getString("billstatus");
        if (!InvInspectBillConst.BIZ_TYPE_MAT_SALE_RETURN_SET.contains(bizTypeObj.getString("number")) || !"C".equals(billStatus)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5df2\u5ba1\u6838\u4e14\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7269\u6599\u7c7b\u9500\u552e\u9000\u8d27\u624d\u53ef\u64cd\u4f5c\u3002", (String)"InvInspectBillPushValidator_8", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
        if ((qualifiedInvBaseQty = this.sumParamForEntry(inspectObj, "unqualifiedbaseqty")).compareTo(BigDecimal.ZERO) == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u68c0\u9a8c\u7ed3\u679c\uff0c\u8bf7\u68c0\u67e5\u201c\u4e0d\u5408\u683c\u57fa\u672c\u6570\u91cf\u201d\u3002", (String)"InvInspectBillPushValidator_9", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkReleaseBaseQty(ExtendedDataEntity dataEntity) {
        BigDecimal qualifiedInvBaseQty;
        DynamicObject inspectObj = dataEntity.getDataEntity();
        DynamicObject bizTypeObj = inspectObj.getDynamicObject("biztype");
        String billStatus = inspectObj.getString("billstatus");
        String bizTypeNumber = bizTypeObj.getString("number");
        if ("430".equals(bizTypeNumber) || !"C".equals(billStatus)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5fc5\u987b\u662f\u4e0b\u63a8\u751f\u6210\u4e14\u5355\u636e\u72b6\u6001\u5df2\u5ba1\u6838\u624d\u53ef\u64cd\u4f5c\u3002", (String)"InvInspectBillPushValidator_10", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
        if (InvInspectBillConst.BIZ_TYPE_MAT_SALE_SET.contains(bizTypeNumber)) {
            BigDecimal qualifiedInvBaseQty2 = this.sumParamForEntry(inspectObj, "qualifiedinvbaseqty");
            if (qualifiedInvBaseQty2.compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u68c0\u9a8c\u7ed3\u679c\uff0c\u8bf7\u68c0\u67e5\u201c\u5408\u683c\u5df2\u5165\u5e93\u57fa\u672c\u6570\u91cf\u201d\u3002", (String)"InvInspectBillPushValidator_11", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
        } else if (InvInspectBillConst.BIZ_TYPE_MAT_SALE_RETURN_SET.contains(bizTypeNumber)) {
            BigDecimal unQualifiedInvBaseQty;
            BigDecimal qualifiedInvBaseQty3 = this.sumParamForEntry(inspectObj, "qualifiedbaseqty");
            if (qualifiedInvBaseQty3.add(unQualifiedInvBaseQty = this.sumParamForEntry(inspectObj, "unqualifiedbaseqty")).compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u68c0\u9a8c\u7ed3\u679c\uff0c\u8bf7\u68c0\u67e5\u201c\u5408\u683c\u57fa\u672c\u6570\u91cf\u201d\u548c\u201c\u4e0d\u5408\u683c\u57fa\u672c\u6570\u91cf\u201d\u3002", (String)"InvInspectBillPushValidator_12", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
        } else if (InvInspectBillConst.BIZ_TYPE_MAT_PUR_SET.contains(bizTypeNumber) && (qualifiedInvBaseQty = this.sumParamForEntry(inspectObj, "qualifiedbaseqty")).compareTo(BigDecimal.ZERO) == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u68c0\u9a8c\u7ed3\u679c\uff0c\u8bf7\u68c0\u67e5\u201c\u5408\u683c\u57fa\u672c\u6570\u91cf\u201d\u3002", (String)"InvInspectBillPushValidator_13", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkWaitAuditAdjustBill(ExtendedDataEntity dataEntity) {
        boolean is210Or430;
        DynamicObject inspectObj = dataEntity.getDataEntity();
        DynamicObject bizTypeObj = inspectObj.getDynamicObject("biztype");
        String billStatus = inspectObj.getString("billstatus");
        String bizTypeNumber = bizTypeObj.getString("number");
        boolean bl = is210Or430 = InvInspectBillConst.BIZ_TYPE_MAT_SALE_SET.contains(bizTypeNumber) || "430".equals(bizTypeNumber);
        if (!is210Or430 || !"C".equals(billStatus)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5df2\u5ba1\u6838\u4e14\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7269\u6599\u7c7b\u9500\u552e\u6216\u5e93\u5b58\u68c0\u9a8c\u624d\u53ef\u64cd\u4f5c\u3002", (String)"InvInspectBillPushValidator_14", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
        BigDecimal qualRemainInvBaseQty = this.sumParamForEntry(inspectObj, "qualremaininvbaseqty");
        BigDecimal unQualRemainInvBaseQty = this.sumParamForEntry(inspectObj, "unqualremaininvbaseqty");
        if (is210Or430 && qualRemainInvBaseQty.add(unQualRemainInvBaseQty).compareTo(BigDecimal.ZERO) == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u672a\u5165\u5e93\u6570\u91cf\uff0c\u8bf7\u68c0\u67e5\u201c\u5408\u683c\u672a\u5165\u5e93\u57fa\u672c\u6570\u91cf\u201d\u548c\u201c\u4e0d\u5408\u683c\u672a\u5165\u5e93\u57fa\u672c\u6570\u91cf\u201d\u3002", (String)"InvInspectBillPushValidator_15", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }

    private BigDecimal sumParamForEntry(DynamicObject inspect, String property) {
        BigDecimal total = BigDecimal.ZERO;
        DynamicObjectCollection billEntry = inspect.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : billEntry) {
            total = total.add(entry.getBigDecimal(property));
        }
        return total;
    }
}

