/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.inspect;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class InvInspectBillSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkBaseQty(dataEntity);
        }
    }

    private void checkBaseQty(ExtendedDataEntity dataEntity) {
        DynamicObject targetObj = dataEntity.getDataEntity();
        Long id = targetObj.getLong("id");
        String billType = targetObj.getDynamicObjectType().getName();
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)billType, (Long[])new Long[]{id});
        if (sourceBills.isEmpty()) {
            return;
        }
        String sourceBillType = (String)sourceBills.keySet().stream().findFirst().get();
        if (!"sm_returnapply".equals(sourceBillType)) {
            return;
        }
        HashSet sourceIdSet = (HashSet)sourceBills.get(sourceBillType);
        DynamicObjectCollection sourceBillEntry = QueryServiceHelper.query((String)sourceBillType, (String)"billentry.id entryid,billentry.materialmasterid materialmasterid,billentry.baseqty baseqty,billentry.qty qty,billentry.isinspect isinspect", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sourceIdSet)});
        MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)sourceBillType);
        HashMap<Long, BigDecimal> entryQtyMap = new HashMap<Long, BigDecimal>(8);
        for (Object sourceObj : sourceBillEntry) {
            if (!sourceObj.getBoolean("isinspect")) continue;
            Object material = sourceObj.get("materialmasterid");
            Object materialId = material instanceof DynamicObject ? ((DynamicObject)material).get("id") : material;
            BigDecimal mapBaseQty = (BigDecimal)entryQtyMap.get(materialId);
            BigDecimal bigDecimal = sourceObj.getBigDecimal("baseqty");
            mapBaseQty = mapBaseQty != null ? mapBaseQty.add(bigDecimal) : (bigDecimal == null ? BigDecimal.ZERO : bigDecimal);
            entryQtyMap.put((Long)materialId, mapBaseQty);
        }
        DynamicObjectCollection invInspectBillEntry = targetObj.getDynamicObjectCollection("billentry");
        for (DynamicObject obj : invInspectBillEntry) {
            long masterId = obj.getDynamicObject("material").getLong("masterid.id");
            BigDecimal bigDecimal = (BigDecimal)entryQtyMap.get(masterId);
            if (bigDecimal == null) continue;
            BigDecimal baseQty = obj.getBigDecimal("baseqty");
            entryQtyMap.put(masterId, bigDecimal.subtract(baseQty));
        }
        QFilter q = new QFilter("id", "in", entryQtyMap.keySet());
        DynamicObject[] materials = BusinessDataServiceHelper.load((String)"bd_material", (String)"number, name", (QFilter[])new QFilter[]{q});
        HashMap<Long, DynamicObject> matMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject mat : materials) {
            matMap.put(mat.getLong("id"), mat);
        }
        for (Map.Entry entry : entryQtyMap.entrySet()) {
            BigDecimal baseQty = (BigDecimal)entry.getValue();
            if (BigDecimal.ZERO.compareTo(baseQty) == 0) continue;
            String name = ((DynamicObject)matMap.get(entry.getKey())).getString("name");
            String number = ((DynamicObject)matMap.get(entry.getKey())).getString("number");
            String msg = ResManager.loadKDString((String)"{0} {1} \uff08{2}\uff09\u57fa\u672c\u6570\u91cf\u9700\u4e0e{3} {4} \uff08{5}\uff09\u57fa\u672c\u6570\u91cf\u76f8\u7b49\u3002", (String)"InvInspectBillSaveValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[]{targetObj.getString("billno"), name, number, sourceEntityType.getDisplayName().getLocaleValue(), name, number});
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

