/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.inspect;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class LocationWithTransValidator
extends AbstractValidator {
    private String warehouse;
    private String location;
    private DynamicObject invScheme;

    public LocationWithTransValidator(String warehouse, String location) {
        this.warehouse = warehouse;
        this.location = location;
    }

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"LocationWithTransValidator", (String)"validate");){
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                this.checkLocation(dataEntity);
            }
        }
    }

    private void checkLocation(ExtendedDataEntity entity) {
        if (!this.isInvSchemeOpen(entity)) {
            return;
        }
        DynamicObject invBill = entity.getDataEntity();
        DynamicObjectCollection col = invBill.getDynamicObjectCollection("billentry");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.entityKey);
        IDataEntityProperty property = dataEntityType.findProperty(this.warehouse);
        IDataEntityProperty fieldProperty = dataEntityType.findProperty(this.location);
        ArrayList<Integer> set = new ArrayList<Integer>();
        int seq = 0;
        for (DynamicObject dym : col) {
            DynamicObject loc;
            boolean isOpenLocation;
            ++seq;
            DynamicObject Wh = dym.getDynamicObject(this.warehouse);
            if (CommonUtils.isNull((Object)Wh) || !(isOpenLocation = Wh.getBoolean("isopenlocation")) || !CommonUtils.isNull((Object)(loc = dym.getDynamicObject(this.location)))) continue;
            set.add(seq);
        }
        if (set.size() > 0) {
            String warehouseName = property == null ? null : property.getDisplayName().getLocaleValue();
            String locationName = fieldProperty == null ? null : fieldProperty.getDisplayName().getLocaleValue();
            String tip = CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getCONFIRM_ENTRY_LOACTION(), (Object[])new Object[]{set, warehouseName, locationName});
            this.addErrorMessage(entity, tip);
        }
    }

    private boolean isInvSchemeOpen(ExtendedDataEntity entity) {
        DynamicObject invBill = entity.getDataEntity();
        DynamicObject invScheme = this.getInvScheme(invBill);
        if (invScheme == null) {
            return true;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        return (!"warehouse".equals(this.warehouse) || isInUpdate) && (!"outwarehouse".equals(this.warehouse) || isOutUpdate);
    }

    private DynamicObject getInvScheme(DynamicObject invBill) {
        DynamicObject bill;
        DynamicObject scheme;
        if (this.invScheme == null && (scheme = (bill = this.dataEntities[0].getDataEntity()).getDynamicObject("invscheme")) != null && scheme.getPkValue() != null) {
            this.invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getPkValue(), (String)"im_invscheme");
        }
        return this.invScheme;
    }
}

