/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.integration;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.ExchangeRateHelper;
import kd.scmc.im.business.helper.InvSchemeHelper;
import kd.scmc.im.business.helper.LineTypeHelper;

public class EASIntegrationHandle {
    private static final Log log = LogFactory.getLog(EASIntegrationHandle.class);
    private List<String> errorMsg = new ArrayList<String>();
    private Map<Long, DynamicObject> orgCurrencyInfo = new HashMap<Long, DynamicObject>();
    private Map<Long, DynamicObject> orgRateTableInfo = new HashMap<Long, DynamicObject>();
    private Map<Long, DynamicObject> bizTypeToLineTypeInfo = new HashMap<Long, DynamicObject>();
    private Map<Long, Map<String, DynamicObject>> invSchemeToStatusInfo = new HashMap<Long, Map<String, DynamicObject>>();
    private Map<Object, DynamicObject> supplierInfo = new HashMap<Object, DynamicObject>();
    private Map<Object, DynamicObject> customerInfo = new HashMap<Object, DynamicObject>();

    public List<String> handleIntegrationData(List<DynamicObject> datas, Map<String, String> handleParam) {
        this.initData(datas, handleParam);
        for (DynamicObject data : datas) {
            String exRateTable;
            String settleCurrency;
            String currency;
            DynamicObject org = data.getDynamicObject("org");
            DynamicObject bizType = data.getDynamicObject("biztype");
            DynamicObject invScheme = data.getDynamicObject("invscheme");
            if (org == null) {
                this.errorMsg.add(String.format(ResManager.loadKDString((String)"[%1$s]\u7c7b\u578b\u7f16\u53f7\u4e3a[%2$s]\u7684\u5355\u636e\u6ca1\u6709\u5e93\u5b58\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"EASIntegrationHandle_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), data.getDataEntityType().getName(), data.getString("billno")));
                return this.errorMsg;
            }
            Long orgId = (Long)data.getDynamicObject("org").getPkValue();
            if (bizType == null) {
                this.errorMsg.add(String.format(ResManager.loadKDString((String)"[%1$s]\u7c7b\u578b\u7f16\u53f7\u4e3a[%2$s]\u7684\u5355\u636e\u6ca1\u6709\u4e1a\u52a1\u7c7b\u578b\u4fe1\u606f\u3002", (String)"EASIntegrationHandle_8", (String)"scmc-im-opplugin", (Object[])new Object[0]), data.getDataEntityType().getName(), data.getString("billno")));
                return this.errorMsg;
            }
            Long bizTypeId = (Long)bizType.getPkValue();
            if (invScheme == null) {
                this.errorMsg.add(String.format(ResManager.loadKDString((String)"[%1$s]\u7c7b\u578b\u7f16\u53f7\u4e3a[%2$s]\u7684\u5355\u636e\u6ca1\u6709\u5e93\u5b58\u4e8b\u52a1\u4fe1\u606f\u3002", (String)"EASIntegrationHandle_9", (String)"scmc-im-opplugin", (Object[])new Object[0]), data.getDataEntityType().getName(), data.getString("billno")));
                return this.errorMsg;
            }
            Long invSchemeId = (Long)invScheme.getPkValue();
            if (!this.orgCurrencyInfo.containsKey(org)) {
                Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId);
                if (map == null) {
                    this.errorMsg.add(String.format(ResManager.loadKDString((String)"[%1$s]\u7c7b\u578b\u7f16\u53f7\u4e3a[%2$s]\u7684\u5355\u636e\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7684\u5e01\u79cd\u4fe1\u606f\u3002", (String)"EASIntegrationHandle_6", (String)"scmc-im-opplugin", (Object[])new Object[0]), data.getDataEntityType().getName(), data.getString("billno")));
                    continue;
                }
                DynamicObject currency2 = CurrencyHelper.getCurrency((Long)orgId);
                if (currency2 == null) {
                    this.errorMsg.add(String.format(ResManager.loadKDString((String)"[%1$s]\u7c7b\u578b\u7f16\u53f7\u4e3a[%2$s]\u7684\u5355\u636e\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7684\u5e01\u79cd\u4fe1\u606f\u3002", (String)"EASIntegrationHandle_6", (String)"scmc-im-opplugin", (Object[])new Object[0]), data.getDataEntityType().getName(), data.getString("billno")));
                    continue;
                }
                this.orgCurrencyInfo.put(orgId, currency2);
                Long exchangeRateTableID = (Long)map.get("exchangeRateTableID");
                DynamicObject rateTable = BusinessDataServiceHelper.loadSingleFromCache((Object)exchangeRateTableID, (String)"bd_exratetable", (String)"id,number");
                if (rateTable == null) {
                    this.errorMsg.add(String.format(ResManager.loadKDString((String)"[%1$s]\u7c7b\u578b\u7f16\u53f7\u4e3a[%2$s]\u7684\u5355\u636e\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7684\u6c47\u7387\u8868\u4fe1\u606f\u3002", (String)"EASIntegrationHandle_7", (String)"scmc-im-opplugin", (Object[])new Object[0]), data.getDataEntityType().getName(), data.getString("billno")));
                    continue;
                }
                this.orgRateTableInfo.put(orgId, rateTable);
            }
            if (!this.bizTypeToLineTypeInfo.containsKey(bizTypeId)) {
                Long lineTypeId = LineTypeHelper.getDefaultLineType((Long)bizTypeId);
                DynamicObject bdLineType = BusinessDataServiceHelper.loadSingleFromCache((Object)lineTypeId, (String)"bd_linetype", (String)"id,name");
                if (bdLineType == null) {
                    this.errorMsg.add(String.format(ResManager.loadKDString((String)"[%1$s]\u7c7b\u578b\u7f16\u53f7\u4e3a[%2$s]\u7684\u5355\u636e\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u7c7b\u578b[%3$s]\u5bf9\u5e94\u7684\u884c\u7c7b\u578b\u4fe1\u606f\u3002", (String)"EASIntegrationHandle_10", (String)"scmc-im-opplugin", (Object[])new Object[0]), data.getDataEntityType().getName(), data.getString("billno"), bizType.get("name")));
                    continue;
                }
                this.bizTypeToLineTypeInfo.put(bizTypeId, bdLineType);
            }
            if (!this.invSchemeToStatusInfo.containsKey(invSchemeId)) {
                DynamicObject defaultInvStatus = InvSchemeHelper.getDefaultInvStatus((DynamicObject)invScheme);
                DynamicObject defaultInvType = InvSchemeHelper.getDefaltInvtype((DynamicObject)invScheme);
                DynamicObject defaultOutInvStatus = InvSchemeHelper.getDefaultOutInvStatus((DynamicObject)invScheme);
                DynamicObject defaultOutInvType = InvSchemeHelper.getDefaltOutInvtype((DynamicObject)invScheme);
                HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(4);
                if (defaultInvStatus != null) {
                    result.put("invStatus", defaultInvStatus);
                }
                if (defaultInvType != null) {
                    result.put("invType", defaultInvType);
                }
                if (defaultOutInvType != null) {
                    result.put("outInvType", defaultOutInvType);
                }
                if (defaultOutInvStatus != null) {
                    result.put("outInvStatus", defaultOutInvStatus);
                }
                this.invSchemeToStatusInfo.put(invSchemeId, result);
            }
            if ((currency = handleParam.get("currency")) != null) {
                this.currencyHandle(data, orgId, currency);
            }
            if ((settleCurrency = handleParam.get("settleCurrency")) != null) {
                this.settlecurrencyHandle(data, orgId, settleCurrency);
            }
            if ((exRateTable = handleParam.get("exRateTable")) != null) {
                this.exRateTableHandle(data, orgId, exRateTable);
            }
            if (handleParam.containsKey("exChangeRate")) {
                this.exChangeRateHandle(data);
            }
            if (handleParam.containsKey("inVoiceBizType")) {
                this.inVoiceBizTypeHandle(data);
            }
            DynamicObjectCollection billentry = data.getDynamicObjectCollection("billentry");
            String billNo = data.getString("billno");
            for (DynamicObject entry : billentry) {
                String lineType = handleParam.get("lineType");
                if (lineType != null) {
                    this.lineTypeHandle(entry, bizTypeId, lineType, billNo);
                }
                if (handleParam.containsKey("inv")) {
                    this.invStatuAndTypeHandle(entry, invSchemeId, billNo);
                }
                if (!handleParam.containsKey("outInv")) continue;
                this.outInvStatuAndTypeHandle(entry, invSchemeId, billNo);
            }
        }
        return this.errorMsg;
    }

    public void inVoiceBizTypeHandle(DynamicObject data) {
    }

    private void exChangeRateHandle(DynamicObject data) {
        Map exchangeRateMap = ExchangeRateHelper.getExRateMap((Object)data.get("currency"), (Object)data.get("settlecurrency"), (Object)data.get("exratetable"), (Date)data.getDate("exratedate"));
        if (exchangeRateMap != null) {
            Object exchangeRate = exchangeRateMap.get("exchangeRate");
            data.set("exchangerate", exchangeRate);
        }
    }

    private void initData(List<DynamicObject> datas, Map<String, String> handleParam) {
        Map bdSupplierInfo;
        if (datas.isEmpty()) {
            return;
        }
        ArrayList<Long> suppliers = new ArrayList<Long>();
        ArrayList<Long> customers = new ArrayList<Long>();
        String formId = datas.get(0).getDataEntityType().getName();
        block10: for (DynamicObject data : datas) {
            switch (formId) {
                case "im_purreceivebill": 
                case "im_purinbill": 
                case "im_ospurinbill": {
                    if (data.getDynamicObject("supplier") == null) break;
                    Long supplierId = (Long)data.getDynamicObject("supplier").getPkValue();
                    if (supplierId == null) continue block10;
                    suppliers.add(supplierId);
                    break;
                }
                case "im_saloutbill": {
                    if (data.getDynamicObject("customer") == null) break;
                    Long customerId = (Long)data.getDynamicObject("customer").getPkValue();
                    if (customerId == null) continue block10;
                    customers.add(customerId);
                    break;
                }
            }
        }
        if (!suppliers.isEmpty() && !(bdSupplierInfo = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id, settlementcyid", (QFilter[])new QFilter[]{new QFilter("id", "in", suppliers)})).isEmpty()) {
            this.supplierInfo = bdSupplierInfo;
        }
        if (!customers.isEmpty() && !(bdSupplierInfo = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)"id, settlementcyid", (QFilter[])new QFilter[]{new QFilter("id", "in", customers)})).isEmpty()) {
            this.customerInfo = bdSupplierInfo;
        }
    }

    private void outInvStatuAndTypeHandle(DynamicObject data, Long invSchemeId, String billNo) {
        DynamicObject outInvStatus;
        if (!this.invSchemeToStatusInfo.containsKey(invSchemeId)) {
            this.setErrorMsg(String.format(ResManager.loadKDString((String)"[%1$s]\u7c7b\u578b\u7f16\u53f7\u4e3a[%2$s]\u7684\u5355\u636e\u672a\u67e5\u8be2\u5230\u51fa/\u5165\u5e93\u5e93\u5b58\u7c7b\u578b\u548c\u72b6\u6001\u4fe1\u606f\u3002", (String)"EASIntegrationHandle_12", (String)"scmc-im-opplugin", (Object[])new Object[0]), data.getDataEntityType().getName(), billNo));
            return;
        }
        Map<String, DynamicObject> result = this.invSchemeToStatusInfo.get(invSchemeId);
        DynamicObject outInvType = result.get("outInvType");
        if (outInvType != null) {
            data.set("outInvType", (Object)outInvType);
        }
        if ((outInvStatus = result.get("outInvStatus")) != null) {
            data.set("outInvStatus", (Object)outInvStatus);
        }
    }

    public void invStatuAndTypeHandle(DynamicObject data, Long invSchemeId, String billNo) {
        DynamicObject invStatus;
        if (!this.invSchemeToStatusInfo.containsKey(invSchemeId)) {
            this.setErrorMsg(String.format(ResManager.loadKDString((String)"[%1$s]\u7c7b\u578b\u7f16\u53f7\u4e3a[%2$s]\u7684\u5355\u636e\u672a\u67e5\u8be2\u5230\u51fa/\u5165\u5e93\u5e93\u5b58\u7c7b\u578b\u548c\u72b6\u6001\u4fe1\u606f\u3002", (String)"EASIntegrationHandle_12", (String)"scmc-im-opplugin", (Object[])new Object[0]), data.getDataEntityType().getName(), billNo));
            return;
        }
        Map<String, DynamicObject> result = this.invSchemeToStatusInfo.get(invSchemeId);
        DynamicObject invType = result.get("invType");
        if (invType != null) {
            data.set("invType", (Object)invType);
        }
        if ((invStatus = result.get("invStatus")) != null) {
            data.set("invStatus", (Object)invStatus);
        }
    }

    private void lineTypeHandle(DynamicObject data, Long bizTypeId, String lineType, String billNo) {
        if (!this.bizTypeToLineTypeInfo.containsKey(bizTypeId)) {
            this.setErrorMsg(String.format(ResManager.loadKDString((String)"[%1$s]\u7c7b\u578b\u7f16\u53f7\u4e3a[%2$s]\u7684\u5355\u636e\u672a\u67e5\u8be2\u5230\u884c\u7c7b\u578b\u4fe1\u606f\u3002", (String)"EASIntegrationHandle_11", (String)"scmc-im-opplugin", (Object[])new Object[0]), data.getDataEntityType().getName(), billNo));
            return;
        }
        data.set(lineType, (Object)this.bizTypeToLineTypeInfo.get(bizTypeId));
    }

    private void exRateTableHandle(DynamicObject data, Long orgId, String exRateTable) {
        if (!this.orgRateTableInfo.containsKey(orgId)) {
            this.setErrorMsg(String.format(ResManager.loadKDString((String)"[%1$s]\u7c7b\u578b\u7f16\u53f7\u4e3a[%2$s]\u7684\u5355\u636e\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7684\u6c47\u7387\u8868\u4fe1\u606f\u3002", (String)"EASIntegrationHandle_7", (String)"scmc-im-opplugin", (Object[])new Object[0]), data.getDataEntityType().getName(), data.getString("billno")));
            return;
        }
        data.set(exRateTable, (Object)this.orgRateTableInfo.get(orgId));
    }

    public void currencyHandle(DynamicObject data, Long orgId, String currency) {
        if (!this.orgCurrencyInfo.containsKey(orgId)) {
            this.setErrorMsg(String.format(ResManager.loadKDString((String)"[%1$s]\u7c7b\u578b\u7f16\u53f7\u4e3a[%2$s]\u7684\u5355\u636e\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7684\u5e01\u79cd\u4fe1\u606f\u3002", (String)"EASIntegrationHandle_6", (String)"scmc-im-opplugin", (Object[])new Object[0]), data.getDataEntityType().getName(), data.getString("billno")));
            return;
        }
        DynamicObject currencyInfo = this.orgCurrencyInfo.get(orgId);
        data.set(currency, (Object)currencyInfo);
    }

    public void settlecurrencyHandle(DynamicObject data, Long orgId, String settleCurrency) {
    }

    public List<String> getErrorMsg() {
        return new ArrayList<String>(this.errorMsg);
    }

    public void setErrorMsg(String msg) {
        this.errorMsg.add(msg);
    }

    public Map<Long, DynamicObject> getOrgCurrencyInfo() {
        return this.orgCurrencyInfo;
    }

    public Map<Long, Map<String, DynamicObject>> getInvSchemeToStatusInfo() {
        return this.invSchemeToStatusInfo;
    }

    public void setInvSchemeToStatusInfo(Map<Long, Map<String, DynamicObject>> invSchemeToStatusInfo) {
        this.invSchemeToStatusInfo = invSchemeToStatusInfo;
    }

    public Map<Object, DynamicObject> getSupplierInfo() {
        return this.supplierInfo;
    }

    public void setSupplierInfo(Map<Object, DynamicObject> supplierInfo) {
        this.supplierInfo = supplierInfo;
    }

    public Map<Object, DynamicObject> getCustomerInfo() {
        return this.customerInfo;
    }

    public void setCustomerInfo(Map<Object, DynamicObject> customerInfo) {
        this.customerInfo = customerInfo;
    }
}

