/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.integration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.im.validator.integration.EASIntegrationHandle;
import kd.scmc.im.validator.integration.MaterialReqOutIntegrationHandle;
import kd.scmc.im.validator.integration.PurInBillIntegrationHandle;
import kd.scmc.im.validator.integration.PurReceiveBillIntegrationHandle;
import kd.scmc.im.validator.integration.SaleOutIntegrationHandle;
import kd.scmc.im.validator.integration.TransferInBillIntegrationHandle;

public class EASIntegrationUnit {
    public static List<String> handle(List<DynamicObject> datas) {
        String formId = datas.get(0).getDataEntityType().getName();
        List<String> result = new ArrayList<String>();
        EASIntegrationHandle easIntegrationHandle = null;
        HashMap<String, String> param = new HashMap<String, String>(10);
        switch (formId) {
            case "im_transoutbill": {
                param.put("currency", "settlescurrency");
                param.put("lineType", "linetype");
                easIntegrationHandle = new EASIntegrationHandle();
                result = easIntegrationHandle.handleIntegrationData(datas, param);
                break;
            }
            case "im_otheroutbill": 
            case "im_otherinbill": 
            case "im_productinbill": {
                param.put("currency", "settlecurrency");
                param.put("lineType", "linetype");
                easIntegrationHandle = new EASIntegrationHandle();
                result = easIntegrationHandle.handleIntegrationData(datas, param);
                break;
            }
            case "im_purreceivebill": {
                param.put("currency", "currency");
                param.put("settleCurrency", "settlecurrency");
                param.put("exRateTable", "exratetable");
                param.put("exChangeRate", "exchangerate");
                param.put("lineType", "linetype");
                param.put("inVoiceBizType", "invoicebiztype");
                easIntegrationHandle = new PurReceiveBillIntegrationHandle();
                result = easIntegrationHandle.handleIntegrationData(datas, param);
                break;
            }
            case "im_initbill": {
                break;
            }
            case "im_transapply": {
                param.put("lineType", "linetype");
                easIntegrationHandle = new EASIntegrationHandle();
                result = easIntegrationHandle.handleIntegrationData(datas, param);
                break;
            }
            case "im_purinbill": 
            case "im_ospurinbill": {
                param.put("currency", "currency");
                param.put("exRateTable", "exratetable");
                param.put("lineType", "linetype");
                param.put("inv", "inv");
                param.put("outInv", "outInv");
                easIntegrationHandle = new PurInBillIntegrationHandle();
                result = easIntegrationHandle.handleIntegrationData(datas, param);
                break;
            }
            case "im_saloutbill": {
                param.put("currency", "currency");
                param.put("exRateTable", "exratetable");
                param.put("lineType", "linetype");
                param.put("inv", "inv");
                param.put("outInv", "outInv");
                easIntegrationHandle = new SaleOutIntegrationHandle();
                result = easIntegrationHandle.handleIntegrationData(datas, param);
                break;
            }
            case "im_materialreqoutbill": 
            case "im_osmaterialreqoutbill": {
                param.put("currency", "settlecurrency");
                param.put("lineType", "linetype");
                param.put("outInv", "outInv");
                easIntegrationHandle = new MaterialReqOutIntegrationHandle();
                result = easIntegrationHandle.handleIntegrationData(datas, param);
                break;
            }
            case "im_transinbill": {
                param.put("currency", "settlescurrency");
                param.put("lineType", "linetype");
                easIntegrationHandle = new TransferInBillIntegrationHandle();
                result = easIntegrationHandle.handleIntegrationData(datas, param);
                break;
            }
            default: {
                param.put("lineType", "linetype");
                easIntegrationHandle = new EASIntegrationHandle();
                result = easIntegrationHandle.handleIntegrationData(datas, param);
            }
        }
        return result;
    }
}

