/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.integration;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.im.validator.integration.EASIntegrationHandle;

public class PurReceiveBillIntegrationHandle
extends EASIntegrationHandle {
    private static final Long DEFAULT_INVOICE_BIZ = 1533341968170710016L;

    @Override
    public void settlecurrencyHandle(DynamicObject data, Long orgId, String settlecurrency) {
        super.settlecurrencyHandle(data, orgId, settlecurrency);
        DynamicObject supplier = (DynamicObject)data.get("supplier");
        if (supplier == null) {
            this.setErrorMsg(String.format(ResManager.loadKDString((String)"[%1$s]\u7c7b\u578b\u7f16\u53f7\u4e3a[%2$s]\u7684\u5355\u636e\u6ca1\u6709\u4f9b\u5e94\u5546\u4fe1\u606f\u3002", (String)"EASIntegrationHandle_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), data.getDataEntityType().getName(), data.getString("billno")));
            return;
        }
        Long supplierId = (Long)supplier.getPkValue();
        if (this.getSupplierInfo().containsKey(supplierId)) {
            DynamicObject supplierCache = this.getSupplierInfo().get(supplierId);
            DynamicObject settlementCy = supplierCache.getDynamicObject("settlementcyid");
            if (settlementCy != null) {
                data.set(settlecurrency, (Object)settlementCy);
            } else {
                data.set(settlecurrency, (Object)this.getOrgCurrencyInfo().get(orgId));
            }
        } else {
            this.setErrorMsg(String.format(ResManager.loadKDString((String)"[%1$s]\u7c7b\u578b\u7f16\u53f7\u4e3a[%2$s]\u7684\u5355\u636e\u6ca1\u6709\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u7684\u4fe1\u606f\u3002", (String)"EASIntegrationHandle_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), data.getDataEntityType().getName(), data.getString("billno")));
        }
    }

    @Override
    public void inVoiceBizTypeHandle(DynamicObject data) {
        super.inVoiceBizTypeHandle(data);
        DynamicObject supplier = (DynamicObject)data.get("supplier");
        if (supplier == null) {
            data.set("paycondition", null);
            data.set("settletype", null);
            return;
        }
        DynamicObject settlementType = supplier.getDynamicObject("settlementtypeid");
        DynamicObject payCond = supplier.getDynamicObject("paycond");
        data.set("paycondition", payCond == null ? null : payCond.getPkValue());
        data.set("settletype", settlementType == null ? null : settlementType.getPkValue());
        DynamicObject invoiceType = (DynamicObject)supplier.get("invoicecategory");
        String appId = "im";
        if (invoiceType != null && appId != null) {
            Long invoiceTypeId = invoiceType.getLong("id");
            DynamicObject invoiceBizType = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"CommonHelperService", (String)"getInvoiceBizType", (Object[])new Object[]{invoiceTypeId, appId});
            if (invoiceBizType != null) {
                data.set("invoicebiztype", (Object)invoiceBizType);
            } else {
                data.set("invoicebiztype", (Object)DEFAULT_INVOICE_BIZ);
            }
        } else {
            data.set("invoicebiztype", (Object)DEFAULT_INVOICE_BIZ);
        }
    }
}

