/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.invquery;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.im.consts.InvqueryCfgConst;

public class InvqueryCfgSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            this.validSettingParam(extendedDataEntity);
            this.validMappingField(extendedDataEntity);
            this.validReturnField(extendedDataEntity);
            this.validOutRule(extendedDataEntity);
        }
    }

    private void validReturnField(ExtendedDataEntity extendedDataEntity) {
        DynamicObject invCfg = extendedDataEntity.getDataEntity();
        DynamicObjectCollection entries = invCfg.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entries) {
            Boolean update;
            String returnCol = entry.getString("returncol");
            String returnColNo = entry.getString("returncolno");
            if (!StringUtils.isNotEmpty((CharSequence)returnCol) || returnCol.contains(".") || !(update = Boolean.valueOf(entry.getBoolean("update"))).booleanValue()) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5173\u8054\u8fd4\u56de\u5355\u636e\u5b57\u6bb5\u3010{0}\u3011\u6620\u5c04\u914d\u7f6e\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u5c06\u5e93\u5b58\u5b57\u6bb5\u8fd4\u56de\u5355\u636e\u5934\u3002", (String)"InvqueryCfgSaveValidator_10", (String)"scmc-im-opplugin", (Object[])new Object[]{returnColNo}));
        }
    }

    private void validSettingParam(ExtendedDataEntity extendedDataEntity) {
        String billEntity;
        IDataEntityProperty property;
        String notUpdateKey;
        DynamicObject invCfg = extendedDataEntity.getDataEntity();
        String dealType = invCfg.getString("dealtype");
        String actionId = invCfg.getString("actionid");
        String pluginName = invCfg.getString("pluginname");
        if ("plugindeal".equals(dealType)) {
            if (StringUtils.isBlank((CharSequence)pluginName)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u63d2\u4ef6\u5168\u540d\u3002", (String)"InvqueryCfgSaveValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)actionId)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5173\u95ed\u56de\u8c03\u53c2\u6570\u3002", (String)"InvqueryCfgSaveValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(notUpdateKey = invCfg.getString("entrynoupdatefieldkey"))) && invCfg.getDynamicObject("srcbillobj") != null && (property = MetadataServiceHelper.getDataEntityType((String)(billEntity = invCfg.getDynamicObject("srcbillobj").getString("number"))).findProperty(notUpdateKey)) == null) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u4e0d\u66f4\u65b0\u5e93\u5b58\u5b57\u6bb5\u6807\u8bc6\u201d\u5728\u5355\u636e\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"InvqueryCfgSaveValidator_11", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }

    private void validMappingField(ExtendedDataEntity extendedDataEntity) {
        DynamicObject invCfg = extendedDataEntity.getDataEntity();
        DynamicObjectCollection entries = invCfg.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entries) {
            String srcbillcol = entry.getString("srcbillcol");
            String srcbillcolNo = entry.getString("srcbillcolno");
            if (!StringUtils.isNotEmpty((CharSequence)srcbillcol) || srcbillcol.contains(".")) continue;
            Boolean update = entry.getBoolean("update");
            Boolean match = entry.getBoolean("match");
            if (!update.booleanValue() && !match.booleanValue()) continue;
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u5c06\u5e93\u5b58\u5b57\u6bb5\u8fd4\u56de\u5355\u636e\u5934\u3002", (String)"InvqueryCfgSaveValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), srcbillcolNo));
        }
    }

    private void validOutRule(ExtendedDataEntity data) {
        DynamicObject invCfg = data.getDataEntity();
        String useType = invCfg.getString("usetype");
        if (!"B".equals(useType)) {
            return;
        }
        DynamicObjectCollection entries = invCfg.getDynamicObjectCollection("entryentity");
        ArrayList<String> qtyFields = new ArrayList<String>(9);
        boolean isConfigMaterial = false;
        boolean isConfigInvOrg = false;
        for (DynamicObject entry : entries) {
            String invaccCol = entry.getString("invacccol");
            if ("material".equals(invaccCol)) {
                isConfigMaterial = true;
                if (!entry.getBoolean("qfilter") || !entry.getBoolean("update")) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u201c\u7269\u6599\u201d\u5b57\u6bb5\u5fc5\u987b\u8bbe\u4e3a\u201c\u67e5\u8be2\u6761\u4ef6\u201d\u53ca\u201c\u8fd4\u56de\u5355\u636e\u201d\u3002", (String)"InvqueryCfgSaveValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                }
            } else if ("org".equals(invaccCol)) {
                isConfigInvOrg = true;
                if (!entry.getBoolean("qfilter")) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u201c\u5e93\u5b58\u7ec4\u7ec7\u201d\u5b57\u6bb5\u5fc5\u987b\u8bbe\u4e3a\u201c\u67e5\u8be2\u6761\u4ef6\u201d\u3002", (String)"InvqueryCfgSaveValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                }
            } else if (InvqueryCfgConst.OUTRULEQTYFIELDS.contains(invaccCol)) {
                qtyFields.add(invaccCol);
            }
            if (!entry.getBoolean("qfilter") || !entry.getBoolean("fristout")) continue;
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u8bbe\u7f6e\u4e3a\u201c\u67e5\u8be2\u6761\u4ef6\u201d\u4e0e\u201c\u4f18\u5148\u51fa\u5e93\u201d\u3002", (String)"InvqueryCfgSaveValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
        }
        if (!isConfigMaterial) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u201c\u7269\u6599\u201d\u5b57\u6bb5\u3002", (String)"InvqueryCfgSaveValidator_7", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
        if (!isConfigInvOrg) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u201c\u5e93\u5b58\u7ec4\u7ec7\u201d\u5b57\u6bb5\u3002", (String)"InvqueryCfgSaveValidator_8", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
        if (qtyFields.size() != 1) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5e93\u5b58\u5355\u4f4d\u6570\u91cf\u5b57\u6bb5\u6620\u5c04\u6709\u4e14\u53ea\u80fd\u8bbe\u7f6e\u2018\u53ef\u7528\u91cf\u3001\u5e93\u5b58\u91cf\u2019\u5176\u4e2d1\u4e2a\u3002", (String)"InvqueryCfgSaveValidator_9", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }
}

